/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.license;

import com.bwanms.ruledelegator.BaseFormController;
import com.dorado.common.widget.components.OWFCParentPanel;
import com.dorado.common.widget.components.explorer.IOWExplorerNode;
import com.dorado.common.widget.components.explorer.IOWExplorerNodeContainer;
import com.dorado.common.widget.components.explorer.OWExplorerNode;
import com.dorado.common.widget.components.explorer.OWExplorerNodeContainer;
import com.dorado.common.widget.components.formlauncher.IOWFormLauncher;
import com.dorado.common.widget.components.interfaces.IOWGButton;
import com.dorado.common.widget.components.interfaces.IOWGDataWidget;
import com.dorado.common.widget.components.interfaces.IOWGLabel;
import com.dorado.common.widget.components.interfaces.IOWGPanel;
import com.dorado.common.widget.components.interfaces.IOWGStandardPanel;
import com.dorado.common.widget.components.interfaces.IOWGTextField;
import com.dorado.core.ejb.ruleengine.OWRuleEngineClient;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.IOWEventListener;
import com.dorado.runtime.IOWFormUserMethods;
import com.dorado.runtime.IOWRuntimeForm;
import com.dorado.runtime.OWEvent;
import com.dorado.runtime.OWEventAttribValueOperator;
import com.dorado.runtime.OWEventSelector;
import com.dorado.runtime.OWSet;
import com.ngnms.apps.license.AvLSGetStatusParamSet;
import com.ngnms.apps.license.AvLSGetStatusResponse;
import com.ngnms.apps.license.AvLSStatusFormJAVAGUI;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvEmsUtil;
import com.ngnms.common.AvFormID;
import com.ngnms.common.AvServerToFormEvent;
import com.ngnms.common.AvTrace;
import java.awt.Color;
import java.awt.Cursor;
import java.awt.Window;
import java.io.Serializable;
import java.util.Date;
import oracle.help.Help;
import redcell.common.interfaces.IRCOptionPaneListener;
import redcell.common.util.RedCellHelpUtil;
import redcell.common.util.RedCellRuntimeUtil;
import redcell.common.util.RedCellWorkSpaceUtil;

public class AvLSStatusFormFormController
extends BaseFormController
implements IOWEventListener,
IOWFormUserMethods,
IOWRuntimeForm,
IRCOptionPaneListener {
    public AvFormID formID = null;
    public AvClientInternationalizer clientInternationalizer = null;
    public AvServerToFormEvent serverToFormEvent;
    IOWGStandardPanel GeneralPanel;
    IOWGLabel lblProductType;
    IOWGTextField txtProductType;
    IOWGTextField txtExpDate;
    IOWGLabel lblExpDateTime;
    IOWGDataWidget devicesTable;
    IOWGStandardPanel ButtonsPanel;
    IOWGButton btnRefresh;
    IOWGLabel lblStatusLine;
    IOWGButton btnHelp;
    IOWGButton btnClose;
    protected String LSStatus_title;

    public AvLSStatusFormFormController(AvLSStatusFormJAVAGUI form) throws SecurityException, NoSuchFieldException {
        super((OWFCParentPanel)form);
        this.bindFields();
    }

    private void bindFields() throws SecurityException, NoSuchFieldException {
        this.GeneralPanel = (IOWGStandardPanel)this.getComponent("GeneralPanel");
        this.lblProductType = (IOWGLabel)this.getComponent("lblProductType");
        this.txtProductType = (IOWGTextField)this.getComponent("txtProductType");
        this.txtExpDate = (IOWGTextField)this.getComponent("txtExpDate");
        this.lblExpDateTime = (IOWGLabel)this.getComponent("lblExpDateTime");
        this.devicesTable = (IOWGDataWidget)this.getComponent("devicesTable");
        this.ButtonsPanel = (IOWGStandardPanel)this.getComponent("ButtonsPanel");
        this.btnRefresh = (IOWGButton)this.getComponent("btnRefresh");
        this.lblStatusLine = (IOWGLabel)this.getComponent("lblStatusLine");
        this.btnHelp = (IOWGButton)this.getComponent("btnHelp");
        this.btnClose = (IOWGButton)this.getComponent("btnClose");
    }

    public void action(OWEvent pEvent) {
        if (pEvent instanceof AvLSGetStatusResponse) {
            AvLSGetStatusParamSet ev = new AvLSGetStatusParamSet();
            ev.setExpirationDate(((AvLSGetStatusResponse)pEvent).getExpirationDate());
            ev.setProductType(((AvLSGetStatusResponse)pEvent).getProductType());
            ev.setDevices(((AvLSGetStatusResponse)pEvent).getDevices());
            this.processGetResponseEvent(ev);
        } else {
            AvTrace.traceln("AvLS", 2, "Unknown event" + pEvent.getClass().getName());
        }
    }

    public void onCloseForm() {
        try {
            this.serverToFormEvent.removeEventListener((IOWEventListener)this.getThisForm());
            IOWFormLauncher formLauncher = (IOWFormLauncher)this.getUserProperty("FormLauncher");
            OWFCParentPanel form = (OWFCParentPanel)formLauncher.getSelectedPanelContainer().getPanel();
            formLauncher.removePanel(form.getClass().getName(), form.getId());
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLS", 1, e);
        }
    }

    public void onHelp() {
        this.setCursor(Cursor.getPredefinedCursor(3));
        try {
            Help.registerClientWindow((Window)RedCellRuntimeUtil.getLaunchConsole());
            RedCellHelpUtil.showHelp((Window)RedCellRuntimeUtil.getLaunchConsole(), (String)RedCellWorkSpaceUtil.getProperty((String)"redcell.ngnms.help.license", (String)"NgnmsGeneralHelp"));
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvEms", 2, _e);
            AvEmsUtil.showWarningMessage(this.getFormLauncher(), (IRCOptionPaneListener)this.getThisForm(), "HelpNotAvailable", "Error", this.clientInternationalizer);
        }
        this.setCursor(Cursor.getDefaultCursor());
        this.requestFocus();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onInitialise() {
        AvTrace.traceln("AvLS", 1, "In onInitialise ");
        this.getFormController().setBusy(true);
        this.clientInternationalizer = new AvClientInternationalizer("AvCommonTitlesBundle");
        if (this.clientInternationalizer == null) {
            AvTrace.traceln("AvLS", 1, "clientInternationalizer = NULL");
        }
        try {
            this.formID = new AvFormID(this.getThisForm().getClass().getName());
            this.serverToFormEvent = new AvServerToFormEvent();
            OWEventSelector evs = this.serverToFormEvent.getSelector();
            OWEventAttribValueOperator avo = new OWEventAttribValueOperator("FormID", "=", (Serializable)((Object)this.formID.getID()));
            evs.addAttribValueOperator(avo);
            this.serverToFormEvent.addEventListener((IOWEventListener)this.getThisForm());
        }
        catch (Exception _e) {
            AvTrace.traceStack("AvLS", 2, _e);
        }
        finally {
            this.getFormController().setBusy(false);
        }
    }

    public void onRefresh() {
        try {
            AvLSGetStatusParamSet gEvent = new AvLSGetStatusParamSet();
            gEvent.setFormID(this.formID.getID());
            gEvent.emit();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLS", 3, e);
        }
    }

    public void onShowing() {
        AvTrace.traceln("AvLS", 1, "onShowing");
        try {
            if (this.clientInternationalizer != null) {
                this.clientInternationalizer.translatePanel((IOWGPanel)this.GeneralPanel);
                this.clientInternationalizer.translatePanel((IOWGPanel)this.ButtonsPanel);
            }
            AvLSGetStatusParamSet pSet = new AvLSGetStatusParamSet();
            pSet.setFormID(null);
            OWRuleEngineClient ruleEngine = this.getFormController().getRuleEngineClient();
            ruleEngine.callRule("com.ngnms.apps.license.AvLSGetStatus", (IOWEvent)pSet);
            this.processGetResponseEvent(pSet);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLS", 1, e);
        }
    }

    public void optionPaneButtonClicked(int pButton) {
    }

    public void processGetResponseEvent(AvLSGetStatusParamSet pEvent) {
        AvTrace.traceln("AvSessionMngr", 1, "In processGetResponseEvent");
        try {
            String txt = pEvent.getProductType();
            if (txt != null && txt != "") {
                this.txtProductType.setText(this.clientInternationalizer.translateText(txt));
            } else {
                this.txtProductType.setText("");
            }
            long expDate = pEvent.getExpirationDate();
            if (expDate != 0L) {
                Date expirationDate = new Date(expDate);
                if (expirationDate.before(new Date())) {
                    this.txtExpDate.setForeground(Color.red);
                }
                this.txtExpDate.setText(expirationDate.toString());
            } else {
                this.txtExpDate.setText(this.clientInternationalizer.translateText("Unlimited"));
            }
            OWSet devSet = pEvent.getDevices();
            if (devSet != null) {
                this.devicesTable.clearNodes();
                OWExplorerNodeContainer root = (OWExplorerNodeContainer)this.devicesTable.getRoot();
                for (int i = 0; i < devSet.size(); ++i) {
                    AvBeanProxy recordProxy = (AvBeanProxy)devSet.elementAt(i);
                    OWExplorerNode rowNode = new OWExplorerNode();
                    OWExplorerNodeContainer rowContainer = new OWExplorerNodeContainer((IOWExplorerNode)rowNode);
                    OWExplorerNode cell = null;
                    cell = new OWExplorerNode();
                    AvTrace.traceln("AvLS", 1, "DeviceName : " + recordProxy.getAsString("DeviceName"));
                    cell.setText(recordProxy.getAsString("DeviceName"));
                    cell.setStyleID("DevicesTableStyle");
                    rowContainer.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer((IOWExplorerNode)cell));
                    int licensedDevices = recordProxy.getAsInt("NumberOfLicensedDevices");
                    cell = new OWExplorerNode();
                    AvTrace.traceln("AvLS", 1, "NumberOfLicensedDevices : " + recordProxy.getAsInt("NumberOfLicensedDevices"));
                    cell.setText("" + licensedDevices);
                    cell.setStyleID("NumbersTableStyle");
                    rowContainer.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer((IOWExplorerNode)cell));
                    int managedDevices = recordProxy.getAsInt("NumberOfManagedDevices");
                    cell = new OWExplorerNode();
                    AvTrace.traceln("AvLS", 1, "NumberOfManagedDevices : " + recordProxy.getAsInt("NumberOfManagedDevices"));
                    cell.setText("" + managedDevices);
                    if (managedDevices > licensedDevices) {
                        cell.setStyleID("NumbersTableStyleRed");
                    } else {
                        cell.setStyleID("NumbersTableStyle");
                    }
                    rowContainer.add((IOWExplorerNodeContainer)new OWExplorerNodeContainer((IOWExplorerNode)cell));
                    root.add((IOWExplorerNodeContainer)rowContainer);
                }
                this.devicesTable.refresh();
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLS", 3, e);
        }
    }

    public String getTitle() {
        return this.LSStatus_title;
    }

    public void setTitle(String s) {
        super.setTitle(s);
        this.LSStatus_title = s;
    }

    private AvLSStatusFormJAVAGUI getThisForm() {
        return (AvLSStatusFormJAVAGUI)this.getForm();
    }
}

