/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.license;

import com.dorado.common.utility.OWStringUtility;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMClientUtility;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.scheduler.OWScheduleClient;
import com.dorado.core.scheduler.OWScheduleException;
import com.dorado.core.scheduler.OWScheduleItem;
import com.dorado.oware.security.OWSecurityPolicy;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.licensing.verification.decryptapi.LicenseVerificator;
import com.licensing.verification.decryptapi.PrlLicenseDevice;
import com.licensing.verification.decryptapi.PrlManagementFeature;
import com.ngnms.apps.license.AvLSDevice;
import com.ngnms.apps.license.AvLSExpDateTestScheduledRuleParamSet;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvIpConfigCmdOutput;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvUtil;
import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.InetAddress;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import redcell.core.security.RCBOMInternalUseMarker;

public class AvLSStartupUtil {
    public static final String processLicense(IOWBOMClient pBOM, Hashtable pLicenseFeatures) {
        String lsStatus = "OK";
        try {
            AvTrace.traceln("AvLS", 3, "Property is : " + System.getProperty("NGNMS_ROOT"));
            LicenseVerificator lsv = new LicenseVerificator(new File(System.getProperty("NGNMS_ROOT") + "/license.key"));
            lsStatus = AvLSStartupUtil.processManagementFeatures(pBOM, lsv, pLicenseFeatures);
            AvTrace.traceln("AvLS", 3, "productType : " + pLicenseFeatures.get("ProductType") + "lsStatus : " + lsStatus);
            if ("OK".equals(lsStatus) && pLicenseFeatures.get("ProductType") != null) {
                lsStatus = AvLSStartupUtil.processManagedDevices(pBOM, lsv, pLicenseFeatures);
            }
            if ("OK".equals(lsStatus)) {
                lsStatus = AvLSStartupUtil.processIPandMACAddress(lsv, pLicenseFeatures);
            }
            if ("OK".equals(lsStatus)) {
                if (pLicenseFeatures.get("ExpireDate") != null) {
                    AvLSStartupUtil.scheduleExpirationDateTest();
                }
                AvLSStartupUtil.setFeatureEnabled("Av:PmDataCollection", pLicenseFeatures.get("PMCollection") != null);
            }
        }
        catch (Throwable e) {
            AvTrace.traceln("AvLS", 1, "Error in license " + e.getMessage());
            lsStatus = "File \"License.key\" not found!".equals(e.getMessage()) ? "LicenseFileNotFound" : ("License file is damaged.".equals(e.getMessage()) ? "LicenseFileIsDamaged" : "FatalErrorDuringTheLicenseParsing");
        }
        return lsStatus;
    }

    private static void scheduleExpirationDateTest() {
        try {
            AvTrace.traceln("AvLS", 1, "In scheduleExpirationDateTest");
            OWScheduleItem item = new OWScheduleItem("com.ngnms.apps.license.AvLSExpDateTestScheduledRule", (IOWEvent)new AvLSExpDateTestScheduledRuleParamSet(), System.currentTimeMillis(), 0L, 8, 5, 100, false, false, true);
            item.setToExecute(true);
            OWScheduleClient schedClient = new OWScheduleClient();
            schedClient.submitItem(item);
        }
        catch (OWScheduleException e) {
            AvTrace.traceStack("AvLS", 3, (Exception)((Object)e));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static final Vector getMACAddress() {
        Vector macAddr = new Vector();
        try {
            AvClientInternationalizer cli = new AvClientInternationalizer("AvCommonTitlesBundle");
            String addrTitle = "";
            AvIpConfigCmdOutput configCmd = new AvIpConfigCmdOutput();
            String os = configCmd.getOS();
            if (!os.equals("")) {
                InputStream inp = configCmd.getDataInputStream();
                macAddr = os.equals("Windows") ? AvUtil.getWindowsMACAddress(cli.translateText("PhysicalAddress"), new BufferedReader(new InputStreamReader(inp))) : AvUtil.getUnixMACAddress(new BufferedReader(new InputStreamReader(inp)));
                for (int i = 0; i < macAddr.size(); ++i) {
                    System.out.println("System MAC Address : " + (String)macAddr.elementAt(i));
                }
            } else {
                System.out.println("Can't determine MAC Address ");
            }
        }
        catch (Exception e) {
            System.out.println("Can't determine MAC Address ");
            AvTrace.traceStack("AvLS", 3, e);
        }
        finally {
            return macAddr;
        }
    }

    private static final String processManagementFeatures(IOWBOMClient pBOM, LicenseVerificator lsv, Hashtable lsFeaturesHash) throws Exception {
        String lsStatus = "OK";
        AvTrace.traceln("AvLS", 3, "AvLSStartupRule : Get Management Features");
        ArrayList features = lsv.getManagementFeaturesList();
        for (int i = 0; i < features.size(); ++i) {
            String feature = ((PrlManagementFeature)features.get((int)i)).FeatureName;
            AvTrace.traceln("AvLS", 3, "Feature : " + feature);
            if (feature.equals("Carrier")) {
                lsFeaturesHash.put("ProductType", "Carrier");
                continue;
            }
            if (feature.equals("ISP")) {
                lsFeaturesHash.put("ProductType", "ISP");
                continue;
            }
            if (feature.equals("PM Collection")) {
                lsFeaturesHash.put("PMCollection", new Boolean(true));
                continue;
            }
            if (!feature.equals("SW Upgrade")) continue;
            lsFeaturesHash.put("SWUpgrade", new Boolean(true));
        }
        return lsStatus;
    }

    private static String processManagedDevices(IOWBOMClient pBOM, LicenseVerificator lsv, Hashtable lsFeaturesHash) throws Exception {
        String lsStatus = "OK";
        String productType = (String)lsFeaturesHash.get("ProductType");
        ArrayList devicesList = lsv.getLicensedDevicesList();
        if (devicesList.size() == 0) {
            lsStatus = "ManagedDevicesNotDefined";
            AvTrace.traceln("AvLS", 3, "Error." + lsStatus);
        } else {
            AvTrace.traceln("AvLS", 3, "Start test on devices");
            for (int j = 0; j < devicesList.size(); ++j) {
                AvTrace.traceln("AvLS", 3, "Get device # " + j);
                PrlLicenseDevice lsDevice = (PrlLicenseDevice)devicesList.get(j);
                int ind1 = lsDevice.DeviceName.indexOf("(");
                int ind2 = lsDevice.DeviceName.indexOf(")");
                String prType = OWStringUtility.trim((String)lsDevice.DeviceName.substring(ind1 + 1, ind2), (char)' ');
                AvTrace.traceln("AvLS", 3, "prType : " + prType);
                if (!prType.equals(productType)) {
                    lsStatus = "DeviceTypeNotCompatibleWithProductType";
                    AvTrace.traceln("AvLS", 3, "Error." + lsStatus);
                    break;
                }
                String device = OWStringUtility.trim((String)lsDevice.ProductName, (char)' ') + "_" + OWStringUtility.trim((String)lsDevice.DeviceName.substring(0, ind1), (char)' ');
                String devClass = null;
                try {
                    AvTrace.traceln("AvLS", 3, "Look for :" + device);
                    devClass = AvLookup.get("DeviceClassName", device);
                    if (devClass == null) {
                        AvTrace.traceln("AvLS", 3, device + " " + "is not found in lookup table");
                        continue;
                    }
                    AvTrace.traceln("AvLS", 3, device + " " + "is found in lookup table");
                    AvTrace.traceln("AvLS", 3, "Device class is : " + devClass);
                }
                catch (Exception e) {
                    AvTrace.traceln("AvLS", 3, device + " " + "not found in lookup(exception)");
                    AvTrace.traceln("AvLS", 3, "Exception message " + e.getMessage());
                    continue;
                }
                int devNum = 0;
                try {
                    OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(devClass, false);
                    OWBOMAttribValueOperator avo = new OWBOMAttribValueOperator("Model", "NOT_LIKE", (Object)"Undiscovered*");
                    qba.addAttribValueOperator(avo);
                    qba.setMaxQuerySize(0);
                    devNum = pBOM.getCount((OWBOMQuery)qba);
                }
                catch (OWBOMNotFoundException e) {
                    devNum = 0;
                }
                catch (Exception e) {
                    lsStatus = "ErrorAccessingDevicesInBOM";
                    AvTrace.traceln("AvLS", 3, e.getMessage());
                    break;
                }
                AvTrace.traceln("AvLS", 3, "Devices in DB : " + devClass + " " + devNum);
                AvLSDevice dev = new AvLSDevice();
                dev.setDeviceClassName(devClass);
                dev.setDeviceName(device);
                dev.setNumberOfManagedDevices(devNum);
                dev.setNumberOfLicensedDevices(lsDevice.DeviceCount);
                lsFeaturesHash.put(devClass, dev);
            }
        }
        return lsStatus;
    }

    private static String processIPandMACAddress(LicenseVerificator lsv, Hashtable lsFeaturesHash) throws Exception {
        String lsStatus = "OK";
        AvTrace.traceln("AvLS", 3, "Get IP");
        ArrayList ipList = lsv.getIPList();
        ArrayList macList = lsv.getMACList();
        String lsMAC = "";
        if (ipList.size() > 0) {
            InetAddress[] localIPs = InetAddress.getAllByName(InetAddress.getLocalHost().getHostName());
            String[] localIPStr = new String[localIPs.length];
            for (int i = 0; i < localIPs.length; ++i) {
                localIPStr[i] = localIPs[i].getHostAddress();
                AvTrace.traceln("AvLS", 3, "Local IP[ " + i + " ] : " + localIPStr[i]);
            }
            String hostIP = null;
            Vector macAddr = AvLSStartupUtil.getMACAddress();
            boolean found = false;
            for (int k = 0; k < ipList.size() && !found; ++k) {
                hostIP = (String)ipList.get(k);
                for (int i = 0; i < localIPStr.length && !found; ++i) {
                    if (!localIPStr[i].equals(hostIP)) continue;
                    found = true;
                    StringTokenizer st = new StringTokenizer((String)macList.get(k), "-");
                    while (st.hasMoreTokens()) {
                        lsMAC = lsMAC + st.nextToken();
                    }
                    lsMAC = lsMAC.toUpperCase();
                    AvTrace.traceln("AvLS", 3, "LS MAC :" + lsMAC + " Length : " + lsMAC.length());
                }
            }
            if (found) {
                lsFeaturesHash.put("IPAddress", hostIP);
                for (int i = 0; i < macAddr.size(); ++i) {
                    AvTrace.traceln("AvLS", 3, "Dev MAC" + (String)macAddr.elementAt(i) + "Length : " + ((String)macAddr.elementAt(i)).length());
                }
                if (!macAddr.contains(lsMAC)) {
                    lsStatus = "MACAddressNotMatch";
                }
            } else {
                lsStatus = "IpAddressNotMatch";
                AvTrace.traceln("AvLS", 3, "Host IP : " + hostIP);
            }
        }
        return lsStatus;
    }

    private static void setFeatureEnabled(String pFuncName, boolean pEnabled) {
        try {
            IOWBOMClient client = OWBOMClientUtility.getIOWBOMClient((IOWBOMInternalUseMarker)RCBOMInternalUseMarker.getInstance(), (String)"com.dorado.security_dbase", (String)"com.dorado.security_server");
            OWBOMQueryByKey qp = new OWBOMQueryByKey("com.dorado.oware.security.OWSecurityPolicy", pEnabled ? pFuncName + "_disabled" : pFuncName);
            OWSecurityPolicy secPolicy = (OWSecurityPolicy)client.getObjectForUpdate(qp).getRtnObject();
            String policyName = secPolicy.getName();
            if (pEnabled) {
                secPolicy.setName(policyName.substring(0, policyName.length() - "_disabled".length()));
            } else {
                secPolicy.setName(policyName + "_disabled");
            }
            client.commitObject((IOWBean)secPolicy);
            client.commitAll();
        }
        catch (OWBOMNotFoundException e) {
        }
        catch (Exception e) {
            AvTrace.traceStack("AvLS", 3, e);
        }
    }
}

