/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.license;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.license.AvLSGetMACAddressParamSet;
import com.ngnms.apps.license.AvLSGetMACAddressRule;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvIpConfigCmdOutput;
import com.ngnms.common.AvTrace;
import com.ngnms.common.AvUtil;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvLSGetMACAddressRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvLSGetMACAddressRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvLSGetMACAddressRule.run()");
        this.runRule((AvLSGetMACAddressParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvLSGetMACAddressRule.run()");
    }

    public void runRule(AvLSGetMACAddressParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            AvClientInternationalizer cli = new AvClientInternationalizer("AvCommonTitlesBundle");
            String addrTitle = "";
            AvIpConfigCmdOutput configCmd = new AvIpConfigCmdOutput();
            String os = configCmd.getOS();
            if (!os.equals("")) {
                addrTitle = os.equals("Unix") ? cli.translateText("ether") : cli.translateText("PhysicalAddress");
                InputStream inp = configCmd.getDataInputStream();
                Vector macAddr = AvUtil.getSystemMACAddress(os, addrTitle, new BufferedReader(new InputStreamReader(inp)));
                for (int i = 0; i < macAddr.size(); ++i) {
                    System.out.println("MAC Address : " + (String)macAddr.elementAt(i));
                }
            } else {
                System.out.println("Can't determine MAC Address ");
            }
        }
        catch (Exception e) {
            System.out.println("Can't determine MAC Address ");
            AvTrace.traceStack("AvLS", 3, e);
        }
    }

    void myTest() {
        Vector<String> MAC_address = new Vector<String>();
        int LEN_MAC = 17;
        try {
            String ipc_line;
            Process ipc_proc = Runtime.getRuntime().exec("ipconfig.exe /all");
            BufferedReader ipc_in = new BufferedReader(new InputStreamReader(ipc_proc.getInputStream()));
            while ((ipc_line = ipc_in.readLine()) != null) {
                if (ipc_line.indexOf("Physical Address") <= -1 || ipc_line.indexOf("44-45") != -1) continue;
                MAC_address.addElement(ipc_line.substring(ipc_line.length() - 17, ipc_line.length()));
            }
            System.out.println("MAC Address : " + MAC_address);
        }
        catch (Exception e) {
            System.out.println("Can't determine MAC Address ");
            System.out.println(e.getMessage());
        }
    }
}

