/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.equipment;

import RedCell.Config.Location;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.core.bom.OWBOMAPIException;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNestedAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByNestedAttribs;
import com.dorado.core.bom.OWBOMQueryByNullAttribute;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.redcell.inventory.base.commandhandler.RCFilterQueryParamSet;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.dorado.runtime.OWSet;
import com.ngnms.apps.equipment.AvEquipmentFilterByLocationRule;
import com.ngnms.common.AvTrace;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvEquipmentFilterByLocationRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvEquipmentFilterByLocationRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvEquipmentFilterByLocationRule.run()");
        this.runRule((RCFilterQueryParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvEquipmentFilterByLocationRule.run()");
    }

    public void runRule(RCFilterQueryParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        OWSet owset = pParamSet.getFilterData().getValues();
        pParamSet.setIgnoreQuery(true);
        if (owset != null && owset.size() > 0) {
            OWSet values = pParamSet.getFilterData().getValues();
            String location = (String)((OWAttributeValuePair)values.get(0)).getNewValue();
            boolean includeSubLocations = (Boolean)((OWAttributeValuePair)values.get(1)).getNewValue();
            if (location != null && location.trim().length() > 0) {
                pParamSet.setBeans(this.queryObjects(pParamSet.getEntityClassName(), location, includeSubLocations));
                pParamSet.setIgnoreQuery(false);
            }
        }
    }

    private Vector queryObjects(String entityClassName, String location, boolean includeSubLocations) throws OWRuleEngineException {
        Vector result = null;
        try {
            OWBOMQuery query = this.getQuery(entityClassName, location, includeSubLocations);
            result = (Vector)this.getBOM().getObjects(query).getRtnObject();
        }
        catch (OWBOMNotFoundException e) {
        }
        catch (Exception exception) {
            exception.printStackTrace();
        }
        return result;
    }

    private OWBOMQuery getQuery(String entityClassName, String parentLocation, boolean includeSubLocations) throws OWBOMAPIException, OWRuleEngineException {
        OWBOMQueryByNullAttribute query;
        if (parentLocation.equals("*NULL*")) {
            query = new OWBOMQueryByNullAttribute(entityClassName, "Location", false);
        } else {
            Vector locations = this.getAllSubLocations(parentLocation, includeSubLocations);
            OWBOMQueryByNestedAttribs query2 = new OWBOMQueryByNestedAttribs(entityClassName, false);
            OWBOMNestedAttribValueOperator location = new OWBOMNestedAttribValueOperator("Location", "IN", (Object)locations);
            location.addAttribName("LocationID");
            query2.addNestedAttribValueOperator(location);
            query = query2;
        }
        return query;
    }

    private Vector getAllSubLocations(String parentLocation, boolean includeSubLocations) throws OWBOMAPIException, OWRuleEngineException {
        Vector<String> result = new Vector<String>();
        if (includeSubLocations) {
            Vector newVector;
            result.add(parentLocation);
            Vector<String> initial = new Vector<String>();
            initial.add(parentLocation);
            do {
                newVector = new Vector();
                for (String location : initial) {
                    newVector.addAll(this.getAllChildLocations(location));
                }
                result.addAll(newVector);
            } while ((initial = newVector).size() > 0);
        } else {
            result.add(parentLocation);
        }
        return result;
    }

    private Collection getAllChildLocations(String location) throws OWBOMAPIException, OWRuleEngineException {
        OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("RedCell.Config.Location", false);
        qba.addAttribValueOperator(new OWBOMAttribValueOperator("Parent", "=", (Object)location));
        Collection values = null;
        try {
            values = (Collection)this.getBOM().getObjects((OWBOMQuery)qba).getRtnObject();
        }
        catch (OWBOMNotFoundException e) {
            // empty catch block
        }
        ArrayList<String> result = new ArrayList<String>();
        if (values != null) {
            for (Location location1 : values) {
                result.add(location1.getLocationID());
            }
        }
        return result;
    }
}

