/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.common;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.core.rulemgmt.OWRuleInfo;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.common.AvSession;
import com.ngnms.apps.common.AvSessionsStartupRule;
import com.ngnms.common.AvException;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvServerStartupEvent;
import com.ngnms.common.AvTrace;
import com.ngnms.services.common.AvMOUtil;
import java.util.ArrayList;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvSessionsStartupRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvSessionsStartupRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvSessionsStartupRule.run()");
        this.runRule((AvServerStartupEvent)event);
        AvTrace.traceln("AvCS", 1, "<AvSessionsStartupRule.run()");
    }

    public void runRule(AvServerStartupEvent pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            AvTrace.traceln("AvSessionMngr", 3, "AvSessionsStartupRule ...");
            this.initSessions();
            String[] rules = new String[]{"com.ngnms.apps.common.AvSessionNotificationRule", "com.ngnms.apps.common.AvSessionDeviceNotificationRule"};
            int[] ruleCount = new int[]{5, 10};
            for (int i = 0; i < rules.length; ++i) {
                int count = Integer.getInteger(rules[i] + ".count", ruleCount[i]);
                this.loadRule(new OWRuleInfo(rules[i], 1, count, false));
                AvTrace.traceln("AvSessionMngr", 1, "Loaded: " + rules[i] + ", " + count + " instances");
            }
        }
        catch (Exception e) {
            throw new AvException(e, "Failure to initialize the sessions.");
        }
    }

    private void initSessions() throws Exception {
        OWAVPVector avPersistentSessions = AvLookup.getSectionContent("AvPersistentSessions");
        ArrayList<String> persistentSessions = new ArrayList<String>();
        for (OWAttributeValuePair avp : avPersistentSessions) {
            persistentSessions.add(avp.getAttributeName());
        }
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("com.ngnms.apps.common.AvSession", false);
            qba.addAttribValueOperator(new OWBOMAttribValueOperator("Status", "=", (Object)"AvSession_RUNNING"));
            qba.addAttribValueOperator(new OWBOMAttribValueOperator("OR", "Status", "=", (Object)"AvSession_PAUSED"));
            qba.addAttribValueOperator(new OWBOMAttribValueOperator("OR", "Status", "=", (Object)"AvSession_SCHEDULED"));
            Vector results = (Vector)this.getBOM().getObjects((OWBOMQuery)qba).getRtnObject();
            AvTrace.traceln("AvServerStartup", 2, "Failed sessions number : " + results.size());
            for (int i = 0; i < results.size(); ++i) {
                AvSession session = (AvSession)results.elementAt(i);
                if (persistentSessions.contains(session.getClass().getName())) continue;
                AvMOUtil.getObjectForUpdate(this.getBOM(), (IOWBean)session);
                session.setStatus("AvSession_FAILED");
                this.getBOM().commitObject((IOWBean)session);
            }
            this.getBOM().commitAll();
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvServerStartup", 1, "Failed sessions not found");
        }
    }
}

