/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.common;

import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.ruleengine.IOWRuleEngineRuleInterface;
import com.dorado.core.scheduler.OWScheduleClient;
import com.dorado.core.scheduler.OWScheduleException;
import com.dorado.core.scheduler.OWScheduleItem;
import com.dorado.core.security.IOWSecurityDef;
import com.dorado.runtime.IOWBean;
import com.ngnms.apps.common.AvSessionChangedEvent;
import com.ngnms.apps.common.AvSessionDeviceChangedEvent;
import com.ngnms.apps.common.IAvSessionHandler;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvException;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvTrace;
import com.ngnms.services.common.AvJobID;
import com.ngnms.services.common.AvServiceJobDescriptor;
import com.ngnms.services.common.AvServiceUtil;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.Date;
import javax.security.auth.Subject;
import redcell.common.util.RCBOMUtil;

public abstract class AvSessionUtil
extends AvServiceUtil {
    public static final int MAX_SESSION_NAME = 20;
    public static final int MAX_SESSION_DESCRIPTION = 60;
    private static int CONFIGURE_SESSION_RETRIES = Integer.getInteger("com.ngnms.apps.common.AvSessionUtil.configRetries", 5);
    private static boolean debugOn = Boolean.getBoolean("com.ngnms.apps.common.AvSessionUtil.debug");

    protected static AvJobID scheduleJob(IOWRuleEngineRuleInterface pRE, AvServiceJobDescriptor pJob, String pScheduledEvent) throws AvException {
        AvJobID jobID = AvSessionUtil.scheduleJob(pJob, pScheduledEvent);
        AvBeanProxy session = AvSessionUtil.getSessionProxy(pRE, jobID, 0, true);
        session.set("JobID", jobID);
        session.set("Status", "AvSession_SCHEDULED");
        try {
            AvSessionUtil.configureSession(pRE, session, 0);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to set job status to SCHEDULED, job " + jobID);
        }
        return jobID;
    }

    public static void pauseJob(IOWRuleEngineRuleInterface pRE, AvJobID pJobID) throws AvException {
        AvBeanProxy session = AvSessionUtil.getSessionProxy(pRE, pJobID, 0, true);
        AvSessionUtil.pauseJobInt(pJobID, session);
        try {
            AvSessionUtil.configureSession(pRE, session, 0);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to set job status to PAUSED, job " + pJobID);
        }
    }

    public static void pauseJob(AvBeanProxy pSession) throws AvException {
        AvSessionUtil.pauseJobInt((AvJobID)pSession.get("JobID"), pSession);
    }

    public static void pauseJob(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.pauseJobInt(pJobID, pSession);
    }

    private static void pauseJobInt(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        try {
            AvSessionUtil.pauseJob(pJobID);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvSessionMngr", 1, e);
        }
        pSession.set("Status", "AvSession_PAUSED");
    }

    public static void resumeJob(IOWRuleEngineRuleInterface pRE, AvJobID pJobID) throws AvException {
        AvBeanProxy session = AvSessionUtil.getSessionProxy(pRE, pJobID, 0, true);
        AvSessionUtil.resumeJobInt(pJobID, session);
        try {
            AvSessionUtil.configureSession(pRE, session, 0);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to set job status to RESUMED");
        }
    }

    public static void resumeJob(AvBeanProxy pSession) throws AvException {
        AvSessionUtil.resumeJobInt((AvJobID)pSession.get("JobID"), pSession);
    }

    public static void resumeJob(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.resumeJobInt(pJobID, pSession);
    }

    private static void resumeJobInt(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        try {
            AvSessionUtil.resumeJob(pJobID);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvSessionMngr", 1, e);
        }
        pSession.set("Status", "AvSession_SCHEDULED");
    }

    public static void deleteJob(IOWRuleEngineRuleInterface pRE, AvJobID pJobID) throws AvException {
        AvBeanProxy session = AvSessionUtil.getSessionProxy(pRE, pJobID);
        AvSessionUtil.deleteJobInt(pRE, pJobID, session);
        try {
            AvSessionUtil.configureSession(pRE, session);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to set job status to ABORTED, job " + pJobID);
        }
    }

    public static void deleteJob(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.deleteJobInt(pRE, (AvJobID)pSession.get("JobID"), pSession);
    }

    public static void deleteJob(IOWRuleEngineRuleInterface pRE, AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.deleteJobInt(pRE, pJobID, pSession);
    }

    private static void deleteJobInt(IOWRuleEngineRuleInterface pRE, AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        try {
            AvServiceUtil.deleteJob(pRE, pJobID);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvSessionMngr", 1, e);
        }
        if (!pSession.getAsString("Status").equals("AvSession_FINISHED")) {
            pSession.set("Status", "AvSession_ABORTED");
        }
    }

    protected static boolean setJobBusy(IOWRuleEngineRuleInterface pRE, AvJobID pJobID) throws AvException {
        AvBeanProxy session = AvSessionUtil.getSessionProxy(pRE, pJobID);
        if (AvSessionUtil.setJobBusyInt(pJobID, session)) {
            try {
                AvSessionUtil.configureSession(pRE, session);
                return true;
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to set job status to RUNNING");
            }
        }
        return false;
    }

    protected static boolean setJobBusy(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        return AvSessionUtil.setJobBusyInt(pJobID, pSession);
    }

    private static boolean setJobBusyInt(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        if (AvSessionUtil.setJobBusy(pJobID)) {
            long nextCycleTime;
            try {
                OWScheduleClient schedClient = new OWScheduleClient();
                OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
                nextCycleTime = item.getNextExecution();
            }
            catch (Exception e) {
                throw new AvException(e, "Failed to set running job status, job " + pJobID);
            }
            pSession.set("Status", "AvSession_RUNNING");
            pSession.setLong("CycleStartTime", new Date().getTime());
            pSession.setInt("CycleProgress", 0);
            pSession.setLong("NextCycleStartTime", nextCycleTime);
            return true;
        }
        return false;
    }

    protected static void setJobIdle(IOWRuleEngineRuleInterface pRE, AvJobID pJobID) throws AvException {
        AvBeanProxy session = AvSessionUtil.getSessionProxy(pRE, pJobID, 0, false);
        session.setUseGetFromServer(true);
        AvSessionUtil.setJobIdleInt(pJobID, session);
        try {
            AvSessionUtil.configureSession(pRE, session);
            if (session.getAsString("Status").equals("AvSession_FINISHED")) {
                AvSessionUtil.deleteJob(pRE, pJobID);
            }
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to set job status to idle " + pJobID);
        }
    }

    protected static void setJobIdle(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.setJobIdleInt(pJobID, pSession);
    }

    private static void setJobIdleInt(AvJobID pJobID, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.setJobIdle(pJobID);
        try {
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
            long endDate = item.getEndDate();
            if (endDate > 0L && item.getScheduleTimer().getNextExecution() >= endDate || item.getSchedFlags() == 1024 && item.getOccurrences() == 1) {
                pSession.set("Status", "AvSession_FINISHED");
                pSession.setLong("NextCycleStartTime", 0L);
            } else {
                pSession.set("Status", "AvSession_SCHEDULED");
            }
            pSession.setLong("CycleStartTime", 0L);
            pSession.setInt("CycleProgress", 0);
        }
        catch (OWScheduleException e) {
            if (4 == e.getMsgNum()) {
                throw new AvException("Invalid Job ID " + pJobID);
            }
            throw new AvException(e, "Failure to retrieve job " + pJobID);
        }
        catch (Exception e) {
            if (e instanceof AvException) {
                throw (AvException)((Object)e);
            }
            throw new AvException(e, "Failed to set status to idle for job " + pJobID);
        }
    }

    protected static void updateJobProgress(IOWRuleEngineRuleInterface pRE, AvJobID pJobID, int pPercentDone, int pStep) throws AvException {
        AvBeanProxy session = AvSessionUtil.getSessionProxy(pRE, pJobID);
        AvSessionUtil.updateJobProgressInt(pJobID, pPercentDone, pStep, session);
        try {
            AvSessionUtil.configureSession(pRE, session);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to set job progress");
        }
    }

    protected static void updateJobProgress(AvJobID pJobID, int pPercentDone, int pStep, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.updateJobProgressInt(pJobID, pPercentDone, pStep, pSession);
    }

    private static void updateJobProgressInt(AvJobID pJobID, int pPercentDone, int pStep, AvBeanProxy pSession) throws AvException {
        try {
            if (pPercentDone / pStep > pSession.getAsInt("CycleProgress") / pStep) {
                pSession.setInt("CycleProgress", pPercentDone);
            }
        }
        catch (AvException e) {
            throw new AvException((Throwable)((Object)e), "Failed to update job progress, job " + pJobID);
        }
    }

    public static AvBeanProxy getSessionProxy(IOWBOMClient pBOM, OWOID pSessionOWOID, int pDepth) throws AvException {
        return AvSessionUtil.getSessionProxy(pBOM, pSessionOWOID, pDepth, false);
    }

    public static AvBeanProxy getSessionProxy(IOWBOMClient pBOM, OWOID pSessionOWOID, int pDepth, boolean pUseAttrPathFromLookup) throws AvException {
        AvBeanProxy sessionProxy = new AvBeanProxy(pBOM, pSessionOWOID, pDepth, pUseAttrPathFromLookup);
        sessionProxy.setUseGetFromServer(true);
        return sessionProxy;
    }

    public static AvBeanProxy getSessionProxy(IOWBOMClient pBOM, String pSessionName, int pDepth) throws AvException {
        return AvSessionUtil.getSessionProxy(pBOM, pSessionName, pDepth, false);
    }

    public static AvBeanProxy getSessionProxy(IOWBOMClient pBOM, String pSessionName, int pDepth, boolean pUseAttrPathFromLookup) throws AvException {
        AvBeanProxy sessionProxy = new AvBeanProxy(pBOM, "com.ngnms.apps.common.AvSession", pSessionName, pDepth, pUseAttrPathFromLookup);
        sessionProxy.setUseGetFromServer(true);
        return sessionProxy;
    }

    public static AvBeanProxy getSessionProxy(IOWBOMClient pBOM, String pSessionName, int pDepth, String[] pAttrPath) throws AvException {
        AvBeanProxy sessionProxy = new AvBeanProxy(pBOM, "com.ngnms.apps.common.AvSession", pSessionName, pDepth, pAttrPath);
        sessionProxy.setUseGetFromServer(true);
        return sessionProxy;
    }

    public static AvBeanProxy getSessionProxy(IOWRuleEngineRuleInterface pRE, AvJobID pJobID) throws AvException {
        AvBeanProxy sessionProxy = AvSessionUtil.getSessionProxy(pRE, pJobID, 1, false);
        sessionProxy.setUseGetFromServer(true);
        return sessionProxy;
    }

    public static AvBeanProxy getSessionProxy(IOWRuleEngineRuleInterface pRE, AvJobID pJobID, int pDepth, boolean pUseAttrPathFromLookup) throws AvException {
        try {
            OWScheduleClient schedClient = new OWScheduleClient();
            OWScheduleItem item = schedClient.getItem((OWOID)pJobID);
            AvServiceJobDescriptor job = (AvServiceJobDescriptor)item.getRuntimeEvent().readProperty("JobDescriptor");
            String sessionName = job.getRequestorID();
            return new AvBeanProxy(pRE.getBOM(), "com.ngnms.apps.common.AvSession", sessionName, pDepth, pUseAttrPathFromLookup);
        }
        catch (OWScheduleException e) {
            if (4 == e.getMsgNum()) {
                throw new AvException("Invalid Job ID " + pJobID);
            }
            throw new AvException(e, "Failure to retrieve job " + pJobID);
        }
        catch (Exception e) {
            throw new AvException(e, "Failed to get session proxy");
        }
    }

    public static void configureSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSession) throws AvException {
        AvSessionUtil.configureSession(pRE, pSession, 1);
    }

    public static void configureSession(IOWRuleEngineRuleInterface pRE, AvBeanProxy pSession, int pDepth) throws AvException {
        throw new RuntimeException("OLD VERSION EXCEPTION!!!");
    }

    public static IAvSessionHandler getSessionHandler(String pSessionCategory) throws AvException {
        String handlerClassName = AvLookup.get("AvSessionHandlerClassName", pSessionCategory);
        if (debugOn) {
            System.out.println("AvSessionUtil: Category: " + pSessionCategory + "  Class Name: " + handlerClassName);
        }
        try {
            return (IAvSessionHandler)Class.forName(handlerClassName).newInstance();
        }
        catch (Exception e) {
            throw new AvException(e, "Could not instantiate Session Handler for " + pSessionCategory);
        }
    }

    public static void emitSessionChangedEvent(IOWRuleEngineRuleInterface pRE, String pParamSetClassName, String pSessionName, String pSessionStatus, OWOID pSessionOWOID) {
        try {
            AvSessionChangedEvent event = new AvSessionChangedEvent();
            String notificationType = "Modify";
            AvTrace.traceln("AvSessionMngr", 3, "In notifyOnSessionChanged - sessionOWOID = " + pSessionOWOID.getOID());
            if (pParamSetClassName.indexOf("Delete") >= 0) {
                notificationType = "Delete";
            } else if (pParamSetClassName.indexOf("Create") >= 0) {
                notificationType = "Create";
            }
            AvTrace.traceln("AvSessionMngr", 3, "Emiting " + notificationType + " Event for " + pSessionName);
            if (!notificationType.equals("Delete")) {
                AvBeanProxy sessionProxy = new AvBeanProxy(pRE.getBOM(), pSessionOWOID, 0, true);
                event.setMOClassName(sessionProxy.getClassName());
                event.setMO(sessionProxy);
            }
            event.setNotificationType(notificationType);
            event.setSessionName(pSessionName);
            event.setSessionStatus(pSessionStatus);
            event.emit();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvSessionMngr", 3, e);
        }
    }

    public static void emitSessionDeviceChangedEvent(IOWRuleEngineRuleInterface pRE, String pParamSetClassName, String pSessionName, String pTargetNRKey, OWOID pSessionDeviceOWOID) {
        try {
            AvSessionDeviceChangedEvent event = new AvSessionDeviceChangedEvent();
            String notificationType = "Modify";
            AvTrace.traceln("AvSessionMngr");
            AvTrace.traceln("AvSessionMngr", 3, "In notifyOnSessionChanged - sessionDeviceOWOID = " + pSessionDeviceOWOID.getOID());
            AvTrace.traceln("AvSessionMngr");
            if (pParamSetClassName.indexOf("Delete") >= 0) {
                notificationType = "Delete";
            } else if (pParamSetClassName.indexOf("Create") >= 0) {
                notificationType = "Create";
            }
            AvTrace.traceln("AvSessionMngr", 3, "Emiting " + notificationType + " Event for " + pSessionName);
            if (!notificationType.equals("Delete")) {
                AvBeanProxy sessionDeviceProxy = new AvBeanProxy(pRE.getBOM(), pSessionDeviceOWOID, 1, true);
                event.setMOClassName(sessionDeviceProxy.getClassName());
                event.setMO(sessionDeviceProxy);
            }
            event.setNotificationType(notificationType);
            event.setSessionName(pSessionName);
            event.setTargetNRKey(pTargetNRKey);
            event.emit();
        }
        catch (Exception e) {
            AvTrace.traceStack("AvSessionMngr", 3, e);
        }
    }

    public static int getSessionEntityCount(IOWBOMClient pBOM, String pBaseClassName, String pSessionName) throws AvException {
        int count = 0;
        try {
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(pBaseClassName, new OWBOMAttribValueOperator("SessionName", false, "=", pSessionName), false);
            qba.setMaxQuerySize(0);
            count = pBOM.getCount((OWBOMQuery)qba);
        }
        catch (OWBOMNotFoundException nfe) {
            AvTrace.traceln("AvSessionMngr", 2, "No Session Entities Found.");
        }
        catch (Exception e) {
            throw new AvException(e, "Could not get devices count");
        }
        return count;
    }

    public static IOWBean getOWBeanAsSysUser(final IOWBOMClient pBOM, final OWOID pOWOID) {
        try {
            Subject sysSubject = new Subject();
            sysSubject.getPrincipals().add((Principal)IOWSecurityDef.OWARE_SYSTEM_USER_PRINCIPAL);
            return (IOWBean)Subject.doAs(sysSubject, new PrivilegedExceptionAction(){

                public Object run() throws PrivilegedActionException {
                    try {
                        return RCBOMUtil.getOWObject((IOWBOMClient)pBOM, (OWOID)pOWOID);
                    }
                    catch (Exception e) {
                        throw new PrivilegedActionException(e);
                    }
                }
            });
        }
        catch (PrivilegedActionException pae) {
            pae.printStackTrace();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return null;
    }
}

