/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.common;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWOID;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.common.AvSession;
import com.ngnms.apps.common.AvSessionChangedEvent;
import com.ngnms.apps.common.AvSessionScheduler;
import com.ngnms.apps.common.AvSessionSchedulerNotificationEvent;
import com.ngnms.apps.common.AvSessionSchedulerNotificationRule;
import com.ngnms.apps.common.AvSessionUtil;
import com.ngnms.common.AvTrace;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvSessionSchedulerNotificationRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvSessionSchedulerNotificationRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvSessionSchedulerNotificationRule.run()");
        this.runRule((AvSessionSchedulerNotificationEvent)event);
        AvTrace.traceln("AvCS", 1, "<AvSessionSchedulerNotificationRule.run()");
    }

    public void runRule(AvSessionSchedulerNotificationEvent pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            try {
                AvTrace.traceln("AvSessionMngr", 3, "InstanceOID Type:" + pParamSet.getInstanceOID().getClass().getName());
            }
            catch (Exception e) {
                // empty catch block
            }
            String sessionSchedulerOID = ((OWOID)pParamSet.getInstanceOID()).getOID();
            AvTrace.traceln("AvSessionMngr");
            AvTrace.traceln("AvSessionMngr", 3, "In AvSessionSchedulerNotificationRule - sessionSchedulerOID = " + sessionSchedulerOID);
            AvTrace.traceln("AvSessionMngr");
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs("com.ngnms.apps.common.AvSession", false);
            Vector results = (Vector)this.getBOM().getObjects((OWBOMQuery)qba).getRtnObject();
            AvTrace.traceln("AvSessionMngr", 1, "Found " + results.size() + " Sessions.");
            for (int i = 0; i < results.size(); ++i) {
                AvSession session = (AvSession)results.elementAt(i);
                AvSessionScheduler sessionScheduler = session.getScheduler();
                OWOID currentOWOID = sessionScheduler.getHandle();
                AvTrace.traceln("AvSessionMngr", 1, "currentOWOID =  " + currentOWOID.getOID());
                if (!currentOWOID.getOID().equals(sessionSchedulerOID)) continue;
                AvSessionChangedEvent event = new AvSessionChangedEvent();
                String notificationType = "Modify";
                String paramSetClassName = pParamSet.getClass().getName();
                String sessionName = session.getName();
                if (paramSetClassName.indexOf("Delete") >= 0) {
                    notificationType = "Delete";
                } else if (paramSetClassName.indexOf("Create") >= 0) {
                    notificationType = "Create";
                }
                AvTrace.traceln("AvSessionMngr", 1, "Emiting " + notificationType + " Event for " + sessionName);
                event.setNotificationType(notificationType);
                event.setMOClassName(session.getClass().getName());
                event.setMO(AvSessionUtil.getSessionProxy(this.getBOM(), session.getName(), 0, true));
                event.setSessionName(sessionName);
                event.setSessionStatus(session.getStatus());
                event.emit();
                return;
            }
        }
        catch (Exception e) {
            AvTrace.traceStack("AvSessionMngr", 1, e);
        }
    }
}

