/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.common;

import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWOID;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWBaseBean;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.common.AvSession;
import com.ngnms.apps.common.AvSessionQueryRule;
import com.ngnms.apps.common.AvSessionQueryRuleParamSet;
import com.ngnms.apps.common.AvSessionScheduler;
import com.ngnms.apps.common.AvSessionUtil;
import com.ngnms.apps.common.IAvSessionHandler;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvFormGetQueryRuleImpl;
import com.ngnms.common.AvFormGetQueryRuleParamSet;
import com.ngnms.common.AvTrace;
import org.apache.log4j.Logger;

public class AvSessionQueryRuleImpl
extends AvFormGetQueryRuleImpl {
    private boolean useGetFromServer = false;
    private String entityOWOID = null;
    private IAvSessionHandler sessionHandler = null;
    private static final Logger log4j = Logger.getLogger(AvSessionQueryRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvSessionQueryRule.run()");
        this.runRule((AvSessionQueryRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvSessionQueryRule.run()");
    }

    public void runRule(AvSessionQueryRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        this.useGetFromServer = pParamSet.isUseGetFromServer();
        this.entityOWOID = pParamSet.getEntityOWOID();
        if (null != pParamSet.getSessionType()) {
            this.sessionHandler = AvSessionUtil.getSessionHandler(pParamSet.getSessionType());
        }
        super.runRule((AvFormGetQueryRuleParamSet)pParamSet);
    }

    public void addAdditionalInfo(OWBaseBean pBean, AvBeanProxy pProxy) {
        pProxy.setUseGetFromServer(this.useGetFromServer);
        AvSession session = (AvSession)pBean;
        AvSessionScheduler scheduler = session.getScheduler();
        pProxy.putVolatileProperty("StartDate", new Long(scheduler.getStartDate()));
        pProxy.putVolatileProperty("EndDate", new Long(scheduler.getEndDate()));
        int entitiesCount = 0;
        if (null != this.sessionHandler) {
            try {
                entitiesCount = this.sessionHandler.getSessionEntityCount(this.getBOM(), session);
            }
            catch (Exception e) {
                AvTrace.traceStack("AvSessionMngr", 1, e);
            }
        }
        if (entitiesCount == 0) {
            entitiesCount = session.getEntities().size();
        }
        AvTrace.traceln("AvSessionMngr", 2, "EntitiesCount = " + entitiesCount);
        pProxy.putVolatileProperty("EntitiesCount", new Integer(entitiesCount));
    }

    public boolean acceptRecord(OWBaseBean pBean) {
        if (null != this.entityOWOID) {
            try {
                IOWBean sessionEntity = this.sessionHandler.getSessionEntity(this.getBOM(), (AvSession)pBean, new OWOID(this.entityOWOID));
                return null != sessionEntity;
            }
            catch (Exception e) {
                AvTrace.traceln("AvSessionMngr", 1, e.getMessage());
                return false;
            }
        }
        return true;
    }
}

