/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.common;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.common.AvSessionActionRule;
import com.ngnms.apps.common.AvSessionActionRuleParamSet;
import com.ngnms.apps.common.AvSessionActionRuleResponse;
import com.ngnms.apps.common.AvSessionUtil;
import com.ngnms.apps.common.IAvSessionHandler;
import com.ngnms.common.AvBeanProxy;
import com.ngnms.common.AvClientInternationalizer;
import com.ngnms.common.AvException;
import com.ngnms.common.AvTrace;
import org.apache.log4j.Logger;

public class AvSessionActionRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvSessionActionRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvSessionActionRule.run()");
        this.runRule((AvSessionActionRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvSessionActionRule.run()");
    }

    public void runRule(AvSessionActionRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvSessionActionRuleResponse resp;
        block5: {
            AvTrace.traceln("AvSessionMngr", 2, "In AvSessionActionRule");
            String formID = pParamSet.getFormID();
            String category = pParamSet.getCategory();
            String action = pParamSet.getAction();
            String userID = pParamSet.getUserID();
            AvBeanProxy sessionProxy = pParamSet.getSessionProxy();
            resp = new AvSessionActionRuleResponse();
            resp.setFormID(pParamSet.getFormID());
            resp.setCategory(category);
            resp.setAction(action);
            AvTrace.traceln("AvSessionMngr", 3, "Category = " + category);
            AvTrace.traceln("AvSessionMngr", 3, "Action = " + action);
            try {
                AvClientInternationalizer internationalizer = new AvClientInternationalizer("AvPmCollectionTitlesBundle");
                IAvSessionHandler sessionHandler = AvSessionUtil.getSessionHandler(category);
                String errorString = sessionHandler.performSessionAction(this.getEngine(), sessionProxy, action, userID);
                if (null != errorString) {
                    AvTrace.traceln("AvSessionMngr", 1, "Error String: " + errorString);
                    sessionProxy.setString("Status", "AvSession_FAILED");
                    resp.setActionErrorString(errorString);
                    break block5;
                }
                sessionProxy = new AvBeanProxy(this.getBOM(), sessionProxy.getClassName(), sessionProxy.getAsString("Name"), 1);
                int entityCount = 0;
                try {
                    entityCount = sessionHandler.getSessionEntityCount(this.getBOM(), sessionProxy);
                }
                catch (AvException ave) {
                    AvTrace.traceStack("AvSessionMngr", 1, (Exception)((Object)ave));
                }
                sessionProxy.putVolatileProperty("EntitiesCount", new Integer(entityCount));
                resp.setSessionProxy(sessionProxy);
            }
            catch (Exception e) {
                AvTrace.traceStack("AvSessionMngr", 1, e);
            }
        }
        resp.emit();
    }
}

