/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.audit;

import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.collections.OWAVPVector;
import com.dorado.common.exception.OWUserException;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.redcell.rci.dap.RCDAPExecuteParamSet;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.ngnms.apps.audit.AvAuditRuleParamSet;
import com.ngnms.apps.audit.AvStartAuditRule;
import com.ngnms.common.AvLookup;
import com.ngnms.common.AvTrace;
import org.apache.log4j.Logger;

public class AvStartAuditRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvStartAuditRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvStartAuditRule.run()");
        this.runRule((RCDAPExecuteParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvStartAuditRule.run()");
    }

    public void runRule(RCDAPExecuteParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            AvTrace.traceln("AvAudit", 1, "In AvStartAuditRule.");
            OWAVPVector apvVector = AvLookup.getSectionContent("AuditRules");
            String status = "";
            for (int i = 0; i < apvVector.size(); ++i) {
                OWAttributeValuePair valuePair = apvVector.elementAt(i);
                String ruleClassName = (String)valuePair.getValue();
                String ruleName = valuePair.getAttributeName();
                AvAuditRuleParamSet paramSet = new AvAuditRuleParamSet();
                AvTrace.traceln("AvAudit", 2, "Running AvAudit Rule: " + ruleName + " - " + ruleClassName);
                String currentStatus = this.callAuditRule(ruleClassName, paramSet);
                if (currentStatus == null) continue;
                status = status + "\n" + currentStatus;
            }
            AvTrace.traceln("AvAudit", 1, "AvStartAuditRule Done. Status is: \n" + status + "\n---------");
            AvTrace.logMessage("DAP", AvTrace.LOG_USER_ID_APP, pParamSet.getName(), "", status);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvAudit", 1, e);
        }
    }

    private String callAuditRule(String pRuleName, AvAuditRuleParamSet pParamSet) {
        try {
            this.callRule(pRuleName, (IOWEvent)pParamSet);
            return pParamSet.getOutStatus();
        }
        catch (Exception e) {
            AvTrace.traceln("AvAudit", 2, "Failed to Run Rule: " + pRuleName);
            AvTrace.traceStack("AvAudit", 1, e);
            return null;
        }
    }
}

