/*
 * Decompiled with CFR 0.152.
 */
package com.ngnms.apps.audit;

import RedCell.Config.EquipmentKey;
import RedCell.Config.NetworkResourceIPLookup;
import RedCell.Config.SNMPAuthentication;
import com.bwanms.ruledelegator.BaseRuleImpl;
import com.dorado.common.exception.OWUserException;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.OWBOMAttribValueOperator;
import com.dorado.core.bom.OWBOMEnumeration;
import com.dorado.core.bom.OWBOMNotFoundException;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryByAttribs;
import com.dorado.core.bom.OWBOMQueryByKey;
import com.dorado.core.bom.OWBOMQueryByNullAttribute;
import com.dorado.core.ejb.ruleengine.OWRuleEngineException;
import com.dorado.runtime.IOWBean;
import com.dorado.runtime.IOWEvent;
import com.dorado.runtime.OWMutatorException;
import com.dorado.runtime.OWRuleException;
import com.dorado.runtime.OWVector;
import com.ngnms.apps.audit.AvAuditRuleParamSet;
import com.ngnms.apps.audit.AvGeneralAuditRule;
import com.ngnms.common.AvCard;
import com.ngnms.common.AvDevice;
import com.ngnms.common.AvDeviceUtil;
import com.ngnms.common.AvPort;
import com.ngnms.common.AvTrace;
import java.util.Vector;
import org.apache.log4j.Logger;

public class AvGeneralAuditRuleImpl
extends BaseRuleImpl {
    private static final Logger log4j = Logger.getLogger(AvGeneralAuditRule.class);

    public void runDelegated(IOWEvent event) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        AvTrace.traceln("AvCS", 1, ">AvGeneralAuditRule.run()");
        this.runRule((AvAuditRuleParamSet)event);
        AvTrace.traceln("AvCS", 1, "<AvGeneralAuditRule.run()");
    }

    public void runRule(AvAuditRuleParamSet pParamSet) throws OWUserException, OWRuleException, OWRuleEngineException, OWMutatorException {
        try {
            AvTrace.traceln("AvAudit", 1, "In AvGeneralAuditRule.");
            String status = "";
            String currentStatus = this.clearEmptyServiceComponents(this.getBOM());
            if (currentStatus != null && !currentStatus.equals("")) {
                status = currentStatus;
            }
            if ((currentStatus = this.clearEmptyNetworkResourceKeys(this.getBOM())) != null && !currentStatus.equals("")) {
                status = status + "\n" + currentStatus;
            }
            if ((currentStatus = this.cleareEmptySNMPAuthentication(this.getBOM())) != null && !currentStatus.equals("")) {
                status = status + "\n" + currentStatus;
            }
            if ((currentStatus = this.cleareEmptyNetworkResourceIPLookup(this.getBOM())) != null && !currentStatus.equals("")) {
                status = status + "\n" + currentStatus;
            }
            if (status.length() > 0) {
                status = "Generic Audit:\n--------------\n\n" + status + "\n";
            }
            pParamSet.setOutStatus(status);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvAudit", 1, e);
        }
    }

    public String clearEmptyNetworkResourceKeys(IOWBOMClient pBOM) {
        AvTrace.traceln("AvAudit", 3, "In cleareEmptyNetworkResourceKeys");
        return this.deleteWithNullAttribute(pBOM, "RedCell.Config.NetworkResourceKey", "NetworkResource");
    }

    private String cleareEmptySNMPAuthentication(IOWBOMClient pBOM) {
        try {
            AvTrace.traceln("AvAudit", 3, "In cleareEmptySNMPAuthentication");
            String keyClassName = "RedCell.Config.SNMPAuthentication";
            OWBOMQueryByAttribs qba = new OWBOMQueryByAttribs(keyClassName, false);
            Vector<SNMPAuthentication> deleteVector = new Vector<SNMPAuthentication>();
            qba.setMaxQuerySize(30000);
            Vector results = (Vector)pBOM.getObjects((OWBOMQuery)qba).getRtnObject();
            AvTrace.traceln("AvAudit", 3, "Found " + results.size() + " " + keyClassName);
            for (int i = 0; i < results.size(); ++i) {
                SNMPAuthentication authentication = (SNMPAuthentication)results.elementAt(i);
                OWVector equipments = authentication.getEquipment();
                if (equipments != null && equipments.size() != 0) continue;
                AvTrace.traceln("AvAudit", 3, "Deleting " + deleteVector.size() + " (Authentication=" + authentication.getID() + ")");
                pBOM.getObjectForUpdate((IOWBean)authentication);
                deleteVector.addElement(authentication);
            }
            if (deleteVector.size() > 0) {
                pBOM.deleteObjects(deleteVector);
                pBOM.commitObjects(deleteVector);
                pBOM.commitAll();
                return "Deleted " + deleteVector.size() + " Objects of Class: " + keyClassName;
            }
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvAudit", 3, "No RedCell.Config.SNMPAuthentication Found !!!");
        }
        catch (Exception e) {
            AvTrace.traceStack("AvAudit", 1, e);
        }
        return null;
    }

    private String cleareEmptyNetworkResourceIPLookup(IOWBOMClient pBOM) {
        try {
            String className = "RedCell.Config.NetworkResourceIPLookup";
            OWBOMQueryByAttribs attribsQuery = new OWBOMQueryByAttribs(className, true);
            attribsQuery.setMaxQuerySize(30000);
            Vector ipLookupVector = (Vector)pBOM.getObjects((OWBOMQuery)attribsQuery).getRtnObject();
            Vector<NetworkResourceIPLookup> deleteVector = new Vector<NetworkResourceIPLookup>();
            AvTrace.traceln("AvAudit", 3, "Found Total " + ipLookupVector.size() + " " + className);
            for (int i = 0; i < ipLookupVector.size(); ++i) {
                NetworkResourceIPLookup ipLookup = (NetworkResourceIPLookup)ipLookupVector.elementAt(i);
                String keyValue = ipLookup.getKeyValue();
                try {
                    OWBOMQueryByKey keyQuery = new OWBOMQueryByKey("RedCell.Config.EquipmentKey", keyValue);
                    EquipmentKey key = (EquipmentKey)pBOM.getObject(keyQuery).getRtnObject();
                    continue;
                }
                catch (OWBOMNotFoundException ex) {
                    pBOM.getObjectForUpdate((IOWBean)ipLookup);
                    deleteVector.addElement(ipLookup);
                    AvTrace.traceln("AvAudit", 3, "Deleting " + deleteVector.size() + " " + className + " With ClassName = " + ipLookup.getClassName());
                }
            }
            if (deleteVector.size() > 0) {
                pBOM.deleteObjects(deleteVector);
                pBOM.commitObjects(deleteVector);
                pBOM.commitAll();
                return "Deleted " + deleteVector.size() + " Objects of Class: " + className;
            }
        }
        catch (OWBOMNotFoundException e) {
            AvTrace.traceln("AvAudit", 3, "No RedCell.Config.EquipmentKey Found !!!");
        }
        catch (Exception e) {
            AvTrace.traceStack("AvAudit", 1, e);
        }
        return null;
    }

    private String clearEmptyServiceComponents(IOWBOMClient pBOM) {
        AvTrace.traceln("AvAudit", 3, "In clearEmptyServiceComponents");
        String[] objClassNames = new String[]{"com.ngnms.common.AvService", "com.ngnms.common.AvSubscriber", "com.ngnms.common.AvSLAProfile"};
        String status = "";
        String objClassName = "";
        for (int i = 0; i < objClassNames.length; ++i) {
            objClassName = objClassNames[i];
            status = status + this.deleteWithNullAttribute(pBOM, objClassName, "Key");
        }
        status = status + this.deleteWithNullAttribute(pBOM, "com.ngnms.common.AvSLAProfile", "Equipment");
        String[] attrs = new String[]{"Subscriber", "SLAProfile"};
        for (int i = 0; i < attrs.length; ++i) {
            String attr = attrs[i];
            status = status + this.deleteWithNullAttribute(pBOM, "com.ngnms.common.AvService", attr);
        }
        return status;
    }

    public String deleteWithEmptyAttribute(IOWBOMClient pBOM, String pObjClassName, String pAttr) {
        return this.deleteWithNullAttributeInt(pBOM, pObjClassName, pAttr, false);
    }

    public String deleteWithNullAttribute(IOWBOMClient pBOM, String pObjClassName, String pAttr) {
        return this.deleteWithNullAttributeInt(pBOM, pObjClassName, pAttr, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String deleteWithNullAttributeInt(IOWBOMClient pBOM, String pObjClassName, String pAttr, boolean isReference) {
        String status = "";
        Vector<IOWBean> toDelete = new Vector<IOWBean>();
        try {
            Object query = null;
            query = isReference ? new OWBOMQueryByNullAttribute(pObjClassName, pAttr, false) : new OWBOMQueryByAttribs(pObjClassName, new OWBOMAttribValueOperator(pAttr, "=", (Object)""));
            query.setMaxQuerySize(30000);
            OWBOMEnumeration objs = pBOM.getObjectsEnumeration((OWBOMQuery)query);
            AvTrace.traceln("AvAudit", 3, "In deleteWithNullAttribute: Found " + objs.size() + " of " + pObjClassName + " with null " + pAttr);
            while (objs.hasNext()) {
                IOWBean bean = (IOWBean)objs.nextElement();
                if (bean instanceof AvDevice) {
                    AvDeviceUtil.deleteDevice(this.getEngine(), pBOM, (AvDevice)bean);
                    status = status + "Deleted " + pObjClassName + " with null " + pAttr + "\n";
                    continue;
                }
                if (bean instanceof AvCard) {
                    AvDeviceUtil.deleteCard(this.getEngine(), pBOM, (AvCard)bean);
                    status = status + "Deleted " + pObjClassName + " with null " + pAttr + "\n";
                    continue;
                }
                if (bean instanceof AvPort) {
                    AvDeviceUtil.deletePort(this.getEngine(), pBOM, (AvPort)bean);
                    status = status + "Deleted " + pObjClassName + " with null " + pAttr + "\n";
                    continue;
                }
                pBOM.getObjectForUpdate(bean);
                toDelete.addElement(bean);
            }
            if (objs.size() > 0) {
                pBOM.deleteObjects(toDelete);
                pBOM.commitObjects(toDelete);
                pBOM.commitAll();
                status = status + "Deleted " + objs.size() + " " + pObjClassName + " objects with null " + pAttr + "\n";
                return status;
            }
        }
        catch (OWBOMNotFoundException _bnfe) {
            AvTrace.traceln("AvAudit", 3, "In deleteWithNullAttribute: No Objects Found of " + pObjClassName + " with null " + pAttr);
        }
        catch (Exception e) {
            AvTrace.traceStack("AvAudit", 3, e);
        }
        finally {
            return status;
        }
    }
}

