/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.decryptapi;

import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;

public class PrlByteArray {
    private byte[] abBytes;

    public PrlByteArray(byte[] iabBytes) {
        this.abBytes = (byte[])(iabBytes != null ? (byte[])iabBytes.clone() : null);
    }

    public PrlByteArray() {
        this.abBytes = null;
    }

    public PrlByteArray(String istrValue) {
        if (istrValue != null) {
            this.abBytes = istrValue.getBytes();
        }
    }

    public PrlByteArray(int inValue) {
        this.abBytes = PrlByteArray.Int2Bytes(inValue);
    }

    public String toString() {
        if (this.abBytes != null) {
            String strReturn = "";
            for (int i = 0; i < this.abBytes.length; ++i) {
                strReturn = strReturn + "0x" + Integer.toHexString(this.abBytes[i] & 0xFF) + " ";
            }
            return strReturn;
        }
        return "";
    }

    public int length() {
        if (this.abBytes != null) {
            return this.abBytes.length;
        }
        return 0;
    }

    public void readFromStream(InputStream iisInputStream) throws Exception {
        byte[] abSize = new byte[4];
        int nReadCount = iisInputStream.read(abSize);
        if (nReadCount != abSize.length) {
            throw new Exception("Could'n read stream");
        }
        int nSize = PrlByteArray.Bytes2Int(abSize);
        this.abBytes = new byte[nSize];
        nReadCount = iisInputStream.read(this.abBytes);
        if (nReadCount != this.abBytes.length) {
            throw new Exception("Could'n read stream");
        }
    }

    public void writeToStream(OutputStream iosOutputStream) throws Exception {
        try {
            iosOutputStream.write(PrlByteArray.Int2Bytes(this.abBytes.length));
            iosOutputStream.write(this.abBytes);
        }
        catch (Exception Ex) {
            throw new Exception("Write Failed");
        }
    }

    public static byte[] Int2Bytes(int value) {
        byte[] abValue = new byte[]{new Integer(value).byteValue(), new Integer(value >>> 8).byteValue(), new Integer(value >>> 16).byteValue(), new Integer(value >>> 24).byteValue()};
        return abValue;
    }

    public static int Bytes2Int(byte[] abBytes) throws Exception {
        if (abBytes == null || abBytes.length < 4) {
            throw new Exception("Bytes array is null");
        }
        int nResult = 0;
        for (int nIntIndex = 3; 0 <= nIntIndex; --nIntIndex) {
            nResult = nResult << 8 | abBytes[nIntIndex] & 0xFF;
        }
        return nResult;
    }

    public void append(byte[] bytes) {
        int i;
        int nOldLength = this.length();
        int nBytesLength = 0;
        if (bytes != null) {
            nBytesLength = bytes.length;
        }
        byte[] abNewArray = new byte[nOldLength + nBytesLength];
        for (i = 0; i < nOldLength; ++i) {
            abNewArray[i] = this.abBytes[i];
        }
        for (i = 0; i < nBytesLength; ++i) {
            abNewArray[nOldLength + i] = bytes[i];
        }
        this.abBytes = abNewArray;
    }

    public int getInteger() throws Exception {
        return PrlByteArray.Bytes2Int(this.abBytes);
    }

    public byte[] getBytes() {
        return this.abBytes;
    }

    public String getString() {
        return new String(this.abBytes);
    }

    public void pack(PrlByteArray ipbaByteArray) {
        this.append(PrlByteArray.Int2Bytes(ipbaByteArray.length()));
        this.append(ipbaByteArray.getBytes());
    }

    public byte[] getSubArray(int StartIndex, int Size) throws Exception {
        if (0 > StartIndex || StartIndex > this.abBytes.length) {
            throw new ArrayIndexOutOfBoundsException("Start index " + StartIndex + "out of bounds: [0," + this.abBytes.length + "]");
        }
        int nLength = 0;
        nLength = Size == -1 ? this.length() - StartIndex : Size;
        byte[] abResult = new byte[nLength];
        try {
            for (int i = 0; i < nLength; ++i) {
                abResult[i] = this.abBytes[StartIndex + i];
            }
            return abResult;
        }
        catch (Exception ex) {
            throw new ArrayIndexOutOfBoundsException("Couldn't extract a subarray");
        }
    }

    public ArrayList unpack() throws Exception {
        ArrayList<PrlByteArray> alUnpacked = new ArrayList<PrlByteArray>(5);
        int nSize = 0;
        PrlByteArray pbaArray = null;
        for (int nCurrOffset = 0; nCurrOffset < this.abBytes.length; nCurrOffset += nSize + 4) {
            try {
                nSize = PrlByteArray.Bytes2Int(this.getSubArray(nCurrOffset, 4));
                pbaArray = new PrlByteArray(this.getSubArray(nCurrOffset + 4, nSize));
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                throw new ArrayIndexOutOfBoundsException("Invalid Pack starting with " + nCurrOffset);
            }
            alUnpacked.add(pbaArray);
        }
        return alUnpacked;
    }
}

