/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.decryptapi;

import com.licensing.verification.crypto.PrlEnigmaCipher;
import com.licensing.verification.decryptapi.PrlByteArray;
import com.licensing.verification.decryptapi.PrlLicenseDevice;
import com.licensing.verification.decryptapi.PrlManagementFeature;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.ArrayList;

public final class LicenseVerificator {
    private ArrayList alIPList;
    private ArrayList alMACList;
    private ArrayList alLicensedDevices;
    private ArrayList alManagementFeatures;
    private String strCustomerName;
    private int nClientNo;
    private int nPurchaseOrder;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public LicenseVerificator(File licenseFile) throws Exception {
        FileInputStream finLicenseFile = new FileInputStream(licenseFile);
        try {
            this.createLicenseInfoPr(finLicenseFile);
        }
        finally {
            try {
                finLicenseFile.close();
            }
            catch (Exception exception) {}
        }
    }

    public LicenseVerificator(InputStream in) throws Exception {
        this.createLicenseInfoPr(in);
    }

    public String getLicenseInfo() throws Exception {
        return this.createLicenseInfoString();
    }

    public ArrayList getIPList() {
        return this.alIPList;
    }

    public ArrayList getMACList() {
        return this.alMACList;
    }

    public ArrayList getLicensedDevicesList() {
        return this.alLicensedDevices;
    }

    public ArrayList getManagementFeaturesList() {
        return this.alManagementFeatures;
    }

    public String getCustomerName() {
        return this.strCustomerName;
    }

    public int getLicensedClientsNumber() {
        return this.nClientNo;
    }

    public int getLicensedPurchaseOrder() {
        return this.nPurchaseOrder;
    }

    private void createLicenseInfoPr(InputStream finLicenseFile) throws Exception {
        try {
            int nPurchaseOrder;
            int nClientNo;
            String strCustName;
            PrlByteArray pbaLicense = new PrlByteArray();
            pbaLicense.readFromStream(finLicenseFile);
            ArrayList alLicenseRoot = pbaLicense.unpack();
            PrlByteArray pbaEnigmaKey = (PrlByteArray)alLicenseRoot.get(1);
            int[] anKey = new int[pbaEnigmaKey.length() / 4];
            for (int i = 0; i < pbaEnigmaKey.length() / 4; ++i) {
                anKey[i] = PrlByteArray.Bytes2Int(pbaEnigmaKey.getSubArray(i * 4, 4));
            }
            PrlEnigmaCipher decipher = new PrlEnigmaCipher(anKey);
            PrlByteArray pbaRoot = (PrlByteArray)alLicenseRoot.get(2);
            pbaRoot = new PrlByteArray(decipher.Crypt(((PrlByteArray)alLicenseRoot.get(2)).getBytes()));
            ArrayList alRoot = pbaRoot.unpack();
            PrlByteArray pbaCustName = (PrlByteArray)alRoot.get(0);
            this.strCustomerName = strCustName = new String(pbaCustName.getBytes());
            this.nClientNo = nClientNo = ((PrlByteArray)alRoot.get(1)).getInteger();
            this.nPurchaseOrder = nPurchaseOrder = ((PrlByteArray)alRoot.get(2)).getInteger();
            PrlByteArray pbaIPList = (PrlByteArray)alRoot.get(3);
            int nIPCount = pbaIPList.length() / 4;
            this.alIPList = new ArrayList(nIPCount);
            for (int i = 0; i < nIPCount; ++i) {
                byte[] abIP = pbaIPList.getSubArray(i * 4, 4);
                String strIP = (abIP[0] & 0xFF) + "." + (abIP[1] & 0xFF) + "." + (abIP[2] & 0xFF) + "." + (abIP[3] & 0xFF);
                this.alIPList.add(new String(strIP));
            }
            PrlByteArray pbaMACList = (PrlByteArray)alRoot.get(4);
            int nMACCount = pbaMACList.length() / 12;
            this.alMACList = new ArrayList(nMACCount);
            for (int i = 0; i < nMACCount; ++i) {
                String strMAC = new String(pbaMACList.getSubArray(i * 12, 12));
                String strDisplayMAC = "";
                for (int j = 0; j < 6; ++j) {
                    strDisplayMAC = strDisplayMAC + strMAC.substring(j * 2, j * 2 + 2) + (j < 5 ? "-" : "");
                }
                this.alMACList.add(new String(strDisplayMAC));
            }
            PrlByteArray pbaDevices = (PrlByteArray)alRoot.get(5);
            ArrayList alpbaDevices = pbaDevices.unpack();
            this.alLicensedDevices = new ArrayList(alpbaDevices.size());
            for (int i = 0; i < alpbaDevices.size(); ++i) {
                PrlByteArray pbaDevice = (PrlByteArray)alpbaDevices.get(i);
                ArrayList alDevice = pbaDevice.unpack();
                PrlLicenseDevice ldDevice = new PrlLicenseDevice();
                ldDevice.ProductName = ((PrlByteArray)alDevice.get(0)).getString();
                ldDevice.DeviceName = ((PrlByteArray)alDevice.get(1)).getString();
                ldDevice.DeviceCount = ((PrlByteArray)alDevice.get(2)).getInteger();
                this.alLicensedDevices.add(ldDevice);
            }
            PrlByteArray pbaManagementFeatures = (PrlByteArray)alRoot.get(6);
            ArrayList alpbaManagementFeatures = pbaManagementFeatures.unpack();
            this.alManagementFeatures = new ArrayList(alpbaManagementFeatures.size());
            for (int i = 0; i < alpbaManagementFeatures.size(); ++i) {
                PrlByteArray pbaManagementFeature = (PrlByteArray)alpbaManagementFeatures.get(i);
                ArrayList alManagementFeature = pbaManagementFeature.unpack();
                PrlManagementFeature mfFeature = new PrlManagementFeature();
                mfFeature.FeatureName = ((PrlByteArray)alManagementFeature.get(0)).getString();
                this.alManagementFeatures.add(mfFeature);
            }
        }
        catch (Throwable ex) {
            throw new Exception("License file is damaged.");
        }
    }

    private String createLicenseInfoString() {
        int i;
        String strLicense = "";
        strLicense = "Customer Name: " + this.strCustomerName + "\n";
        strLicense = strLicense + "Client No: " + this.nClientNo + "\n";
        strLicense = strLicense + "Purchase Order: " + this.nPurchaseOrder + "\n\n";
        strLicense = strLicense + "IP Addresses / MAC Addresses:\n\n";
        for (i = 0; i < this.alIPList.size(); ++i) {
            String strIP = (String)this.alIPList.get(i);
            String strMAC = (String)this.alMACList.get(i);
            strLicense = strLicense + "IP Address / MAC Address" + i + ": " + strIP + "/" + strMAC + "\n";
        }
        strLicense = strLicense + "\n";
        strLicense = strLicense + "Devices:\n\n";
        for (i = 0; i < this.alLicensedDevices.size(); ++i) {
            PrlLicenseDevice ldDevice = (PrlLicenseDevice)this.alLicensedDevices.get(i);
            strLicense = strLicense + "Product Name: " + ldDevice.ProductName + "\n";
            strLicense = strLicense + "Device  Name: " + ldDevice.DeviceName + "\n";
            strLicense = strLicense + "Device Count: " + ldDevice.DeviceCount + "\n\n";
        }
        strLicense = strLicense + "\n";
        strLicense = strLicense + "Management Features:\n\n";
        for (i = 0; i < this.alManagementFeatures.size(); ++i) {
            PrlManagementFeature mfFeature = (PrlManagementFeature)this.alManagementFeatures.get(i);
            strLicense = strLicense + "Feature Name: " + mfFeature.FeatureName + "\n";
        }
        return strLicense;
    }
}

