/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.decryptapi;

import com.bwanms.domain.logic.LicenseHelper;
import com.bwanms.domain.logic.LicenseSPI;
import com.bwanms.model.license.License;
import com.bwanms.model.license.LicenseFeature;
import com.bwanms.model.license.LicenseFeatureNodeLock;
import com.bwanms.model.license.LicenseFeatureTimed;
import com.bwanms.model.license.LicenseFeatureUsable;
import com.licensing.verification.decryptapi.LicenseVerificator;
import com.licensing.verification.decryptapi.PrlLicenseDevice;
import com.licensing.verification.decryptapi.PrlManagementFeature;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import org.apache.log4j.Logger;

public class LicenseSPIImpl
implements LicenseSPI {
    private static final Logger log = Logger.getLogger(LicenseSPIImpl.class);

    public License parseLicense(byte[] licenseBytes) throws Exception {
        LicenseFeatureNodeLock feature;
        LicenseVerificator lsv = new LicenseVerificator(new ByteArrayInputStream(licenseBytes));
        License license = new License();
        license.setCustomerName(lsv.getCustomerName());
        ArrayList mgmtFeatures = lsv.getManagementFeaturesList();
        for (PrlManagementFeature mgmtFeat : mgmtFeatures) {
            String featureName = mgmtFeat.FeatureName;
            log.debug((Object)("Feature: " + featureName));
            if (featureName.startsWith("Duration")) {
                feature = new LicenseFeatureTimed();
                feature.setName(featureName);
                String duration = featureName.split(" ")[1];
                feature.setExpiration(Long.parseLong(duration) * 24L * 60L * 60L * 1000L);
                license.addLicenseFeature((LicenseFeature)feature);
                continue;
            }
            feature = new LicenseFeature();
            feature.setName(featureName);
            license.addLicenseFeature((LicenseFeature)feature);
        }
        ArrayList devicesList = lsv.getLicensedDevicesList();
        for (PrlLicenseDevice device : devicesList) {
            int paraIdx = device.DeviceName.indexOf(40);
            String deviceName = paraIdx > 0 ? device.DeviceName.substring(0, paraIdx - 1).trim() : device.DeviceName.trim();
            deviceName = device.ProductName + "_" + deviceName;
            log.debug((Object)(deviceName + " " + device.DeviceCount));
            LicenseFeatureUsable feature2 = LicenseHelper.createLicenseFeatureUsable((String)deviceName);
            if (feature2 == null) continue;
            feature2.setQuantity(device.DeviceCount);
            feature2.setLicense(license);
            license.addLicenseFeature((LicenseFeature)feature2);
        }
        ArrayList ipList = lsv.getIPList();
        ArrayList macList = lsv.getMACList();
        if (!ipList.isEmpty() || !macList.isEmpty()) {
            feature = new LicenseFeatureNodeLock();
            feature.setName("Node");
            for (String ip : ipList) {
                feature.addIpAddress(ip);
            }
            for (String mac : macList) {
                feature.addMacAddress(mac);
            }
        }
        return license;
    }
}

