/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.decryptapi;

import com.licensing.verification.crypto.Cryptography;
import com.licensing.verification.decryptapi.PrlByteArray;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.util.ArrayList;

public class Authorisation {
    private PrlLicenseKeyReader lkrKeys;
    private Cryptography cryRSACipher;

    public Authorisation() throws Exception {
        try {
            this.cryRSACipher = new Cryptography();
        }
        catch (Exception ex) {
            throw new Exception("License crypto init errorIntercepted error:" + ex.getMessage());
        }
    }

    private PrlByteArray getDecryptedLicense() throws Exception {
        try {
            this.lkrKeys = new PrlLicenseKeyReader();
        }
        catch (Exception ex) {
            throw new Exception("Key reading errorIntercepted error:" + ex.getMessage());
        }
        try {
            FileInputStream finLicenseFile = new FileInputStream("license.key");
            PrlByteArray pbaLicense = new PrlByteArray();
            pbaLicense.readFromStream(finLicenseFile);
            ArrayList alLicenseRoot = pbaLicense.unpack();
            PrlByteArray pbaLicenseVersion = (PrlByteArray)alLicenseRoot.get(0);
            int nLicenseVersion = pbaLicenseVersion.getInteger();
            if (nLicenseVersion != this.lkrKeys.nVersion) {
                throw new Exception("Key versions differ");
            }
            PrlByteArray pbaRSARoot = (PrlByteArray)alLicenseRoot.get(3);
            this.cryRSACipher.privateKey = this.lkrKeys.pbaRSAkey.getBytes();
            byte[] abRSARoot = this.cryRSACipher.decode(pbaRSARoot.getBytes());
            pbaRSARoot = new PrlByteArray(abRSARoot);
            return pbaRSARoot;
        }
        catch (FileNotFoundException ex) {
            throw new Exception("File \"license.key\" not foundIntercepted error:" + ex.getMessage());
        }
        catch (Exception ex) {
            throw new Exception("License loading errorIntercepted error:" + ex.getMessage());
        }
    }

    public int getNumberOfClients() throws Exception {
        try {
            PrlByteArray pbaRoot = this.getDecryptedLicense();
            ArrayList alRoot = pbaRoot.unpack();
            int nClientNo = ((PrlByteArray)alRoot.get(0)).getInteger();
            return nClientNo;
        }
        catch (Exception ex) {
            throw new Exception("Damaged License StructureIntercepted error:" + ex.getMessage());
        }
    }

    public boolean isIpAddressValid(String istrIPAddress) throws Exception {
        try {
            PrlByteArray pbaRoot = this.getDecryptedLicense();
            ArrayList alRoot = pbaRoot.unpack();
            PrlByteArray pbaIPList = (PrlByteArray)alRoot.get(1);
            int nIPCount = pbaIPList.length() / 4;
            for (int i = 0; i < nIPCount; ++i) {
                byte[] abIP = pbaIPList.getSubArray(i * 4, 4);
                String strIP = (abIP[0] & 0xFF) + "." + (abIP[1] & 0xFF) + "." + (abIP[2] & 0xFF) + "." + (abIP[3] & 0xFF);
                if (!strIP.equals(istrIPAddress)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new Exception("Damaged License StructureIntercepted error:" + ex.getMessage());
        }
    }

    public boolean isIpMACAddressesValid(String istrIPAddress, String istrMACAddress) throws Exception {
        try {
            PrlByteArray pbaRoot = this.getDecryptedLicense();
            ArrayList alRoot = pbaRoot.unpack();
            PrlByteArray pbaIPList = (PrlByteArray)alRoot.get(1);
            PrlByteArray pbaMACList = (PrlByteArray)alRoot.get(2);
            int nIPCount = pbaIPList.length() / 4;
            for (int i = 0; i < nIPCount; ++i) {
                byte[] abIP = pbaIPList.getSubArray(i * 4, 4);
                String strIP = (abIP[0] & 0xFF) + "." + (abIP[1] & 0xFF) + "." + (abIP[2] & 0xFF) + "." + (abIP[3] & 0xFF);
                String strMAC = new String(pbaMACList.getSubArray(i * 12, 12));
                if (!strIP.equals(istrIPAddress) || !strMAC.equals(istrMACAddress)) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new Exception("Damaged License StructureIntercepted error:" + ex.getMessage());
        }
    }

    public int getNumberOfDevices(int inDeviceId) throws Exception {
        try {
            PrlByteArray pbaRoot = this.getDecryptedLicense();
            ArrayList alRoot = pbaRoot.unpack();
            PrlByteArray pbaDevices = (PrlByteArray)alRoot.get(3);
            ArrayList alDevices = pbaDevices.unpack();
            for (int i = 0; i < alDevices.size(); ++i) {
                PrlByteArray pbaDevice = (PrlByteArray)alDevices.get(i);
                ArrayList alDevice = pbaDevice.unpack();
                if (((PrlByteArray)alDevice.get(0)).getInteger() != inDeviceId) continue;
                return ((PrlByteArray)alDevice.get(1)).getInteger();
            }
            return 0;
        }
        catch (Exception ex) {
            throw new Exception("Damaged License StructureIntercepted error:" + ex.getMessage());
        }
    }

    public boolean isManagementFeatureValid(int inFeatureId) throws Exception {
        try {
            PrlByteArray pbaRoot = this.getDecryptedLicense();
            ArrayList alRoot = pbaRoot.unpack();
            PrlByteArray pbaManagementFeatures = (PrlByteArray)alRoot.get(4);
            ArrayList alManagementFeatures = pbaManagementFeatures.unpack();
            for (int i = 0; i < alManagementFeatures.size(); ++i) {
                PrlByteArray pbaManagementFeature = (PrlByteArray)alManagementFeatures.get(i);
                ArrayList alManagementFeature = pbaManagementFeature.unpack();
                if (((PrlByteArray)alManagementFeature.get(0)).getInteger() != inFeatureId) continue;
                return true;
            }
            return false;
        }
        catch (Exception ex) {
            throw new Exception("Damaged License StructureIntercepted error:" + ex.getMessage());
        }
    }

    private final class PrlLicenseKeyReader {
        public int nVersion;
        public PrlByteArray pbaRSAkey;

        private PrlLicenseKeyReader() throws Exception {
            try {
                FileInputStream finKeysFile = new FileInputStream("dkadf.klf");
                PrlByteArray pbaKeys = new PrlByteArray();
                pbaKeys.readFromStream(finKeysFile);
                ArrayList alKeys = pbaKeys.unpack();
                this.nVersion = ((PrlByteArray)alKeys.get(0)).getInteger();
                this.pbaRSAkey = (PrlByteArray)alKeys.get(1);
            }
            catch (FileNotFoundException ex) {
                throw new Exception("File \"dkadf.klf\" not found!");
            }
            catch (Exception ex) {
                throw new Exception("Keys file is damaged");
            }
        }
    }
}

