/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.crypto.enigma;

import com.licensing.verification.crypto.enigma.CAbstractEncoding;
import com.licensing.verification.crypto.enigma.CAbstractEnigmaCryptoMachine;
import java.util.Arrays;

public class CGrayCodeEnigmaCpryptoMachine
extends CAbstractEnigmaCryptoMachine {
    public CGrayCodeEnigmaCpryptoMachine(int inNumberOfRototrs, CAbstractEncoding iabstencEncoding) throws Exception {
        super(inNumberOfRototrs, iabstencEncoding);
    }

    public static int[] Int2Gray(int inValue, int inNumberOfDigits) throws Exception {
        int i;
        if (inNumberOfDigits > 32) {
            throw new Exception("Converting more than 32 bit integers is not supported!");
        }
        if (inNumberOfDigits < 0) {
            throw new Exception("Number of Rotors should be non-negatitive value!");
        }
        int[] anGrayArray = new int[inNumberOfDigits];
        int[] anBinArray = new int[inNumberOfDigits + 1];
        Arrays.fill(anBinArray, 0);
        String strBinValue = Integer.toBinaryString(inValue);
        char[] acBinValue = strBinValue.toCharArray();
        int iIntArrayCounter = anBinArray.length;
        for (i = acBinValue.length - 1; 0 <= i; --i) {
            anBinArray[--iIntArrayCounter] = Character.getNumericValue(acBinValue[i]);
        }
        for (i = anGrayArray.length - 1; 0 <= i; --i) {
            int nMod2Sum = anBinArray[i] + anBinArray[i + 1];
            anGrayArray[i] = nMod2Sum == 1 ? 1 : 0;
        }
        return anGrayArray;
    }

    public static int[] Int2Gray2(int inValue, int inNumberOfDigits) throws Exception {
        if (inNumberOfDigits > 32) {
            throw new Exception("Converting more than 32 bit integers is not supported!");
        }
        if (inNumberOfDigits < 0) {
            throw new Exception("Number of Rotors should be non-negatitive value!");
        }
        int[] anGrayArray = new int[inNumberOfDigits];
        int nGrayDigit = inValue ^ inValue >> 1;
        for (int i = inNumberOfDigits - 1; 0 <= i; --i) {
            anGrayArray[i] = nGrayDigit >> inNumberOfDigits - i - 1 & 1;
        }
        return anGrayArray;
    }

    public int[] getRotorsToRotate(int nSymbolIndex) throws Exception {
        return CGrayCodeEnigmaCpryptoMachine.Int2Gray2(nSymbolIndex % this.nMaxShiftsNo, this.nNumberOfRotors);
    }

    public void SetKeyShifts(int[] ianKeyShifts) throws Exception {
        super.SetKeyShifts(ianKeyShifts);
    }
}

