/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.crypto.enigma;

public abstract class CAbstractRotor {
    protected int[][] anRotorMatrix;
    protected int nAlphabetSize;

    public CAbstractRotor(int inAlphabetSize) throws Exception {
        if (inAlphabetSize == 0) {
            throw new Exception("Alphabet size is zero! Couldn't init Devides");
        }
        this.nAlphabetSize = inAlphabetSize;
        this.anRotorMatrix = new int[inAlphabetSize][2];
        this.resetRotor();
    }

    public int getForwardEncodedValue(int inCode) throws Exception {
        try {
            return this.anRotorMatrix[inCode][1];
        }
        catch (Exception Ex) {
            throw new Exception("No such code " + inCode + " in Rotor matrix. Original Error:" + Ex.getMessage());
        }
    }

    public int getBackwardEncodedValue(int inCode) throws Exception {
        try {
            for (int i = 0; i < this.anRotorMatrix.length; ++i) {
                if (this.anRotorMatrix[i][1] != inCode) continue;
                return i;
            }
            throw new Exception("Internal rotor error");
        }
        catch (Exception Ex) {
            throw new Exception("No such code " + inCode + " in Rotor matrix. Original Error:" + Ex.getMessage());
        }
    }

    public void shiftBy(int inShift) {
        for (int i = 0; i < this.nAlphabetSize; ++i) {
            this.anRotorMatrix[i][1] = ((this.anRotorMatrix[i][1] + inShift) % this.nAlphabetSize + this.nAlphabetSize) % this.nAlphabetSize;
        }
    }

    public void shiftUp() {
        this.shiftBy(1);
    }

    public void shiftDown() {
        this.shiftBy(-1);
    }

    public abstract void resetRotor();
}

