/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.crypto.enigma;

import com.licensing.verification.crypto.enigma.CAbstractEncoding;
import com.licensing.verification.crypto.enigma.CAbstractMessage;
import com.licensing.verification.crypto.enigma.CReflector;
import com.licensing.verification.crypto.enigma.CRotor;

public abstract class CAbstractEnigmaCryptoMachine {
    protected int nNumberOfRotors;
    protected int nMaxShiftsNo;
    protected CRotor[] artrRotors;
    protected CAbstractEncoding abstencEncoding;
    protected CReflector refReflector;
    private String strMessage;
    private String strEncryptedMessage;
    private int nMessageLength;

    public CAbstractEnigmaCryptoMachine(int inNumberOfRototrs, CAbstractEncoding iabstencEncoding) throws Exception {
        if (inNumberOfRototrs > 32) {
            throw new Exception("Cryptomachines with Rotor count > 32 are not supported!");
        }
        if (inNumberOfRototrs < 1) {
            throw new Exception("Number of Rotors should be positive value!");
        }
        this.abstencEncoding = iabstencEncoding;
        this.nNumberOfRotors = inNumberOfRototrs;
        this.refReflector = new CReflector(iabstencEncoding.getAlphabetLength());
        this.artrRotors = new CRotor[this.nNumberOfRotors];
        for (int i = 0; i < this.nNumberOfRotors; ++i) {
            this.artrRotors[i] = new CRotor(iabstencEncoding.getAlphabetLength());
        }
        this.nMaxShiftsNo = (int)Math.pow(2.0, inNumberOfRototrs);
    }

    public void SetKeyShifts(int[] ianKeyShifts) throws Exception {
        if (ianKeyShifts.length < this.nNumberOfRotors) {
            throw new Exception("Number of rotors is greater then supplied key");
        }
        for (int i = 0; i < this.artrRotors.length; ++i) {
            this.artrRotors[i].resetRotor();
            this.artrRotors[i].shiftBy(ianKeyShifts[i]);
        }
    }

    private void setMessage(String istrMessage) {
        this.nMessageLength = istrMessage.length();
        this.strMessage = istrMessage;
    }

    public final void Crypt(CAbstractMessage iamMessage, CAbstractMessage oamCryptogramm) throws Exception {
        for (int i = 0; i < iamMessage.length(); ++i) {
            int j;
            int nActiveCode = this.abstencEncoding.getCode(iamMessage.getAlphabetCharacter(i));
            for (j = 0; j < this.artrRotors.length; ++j) {
                nActiveCode = this.artrRotors[j].getForwardEncodedValue(nActiveCode);
                continue;
            }
            nActiveCode = this.refReflector.getForwardEncodedValue(nActiveCode);
            for (j = this.artrRotors.length - 1; 0 <= j; --j) {
                nActiveCode = this.artrRotors[j].getBackwardEncodedValue(nActiveCode);
                continue;
            }
            this.RotateRotors(i);
            oamCryptogramm.addAlphabetCharacter(this.abstencEncoding.getChar(nActiveCode));
        }
        this.strEncryptedMessage = oamCryptogramm.toString();
    }

    public abstract int[] getRotorsToRotate(int var1) throws Exception;

    protected void RotateRotors(int inLetterIndex) throws Exception {
        int[] anRorateArray = this.getRotorsToRotate(inLetterIndex + 1);
        anRorateArray.toString();
        if (anRorateArray.length < this.artrRotors.length) {
            throw new Exception("Rotors to Rotate indexes array is shorter than Actual Rotors array");
        }
        for (int i = 0; i < this.artrRotors.length; ++i) {
            if (anRorateArray[i] == 0) continue;
            this.artrRotors[i].shiftBy(anRorateArray[i]);
        }
    }
}

