/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.verification.crypto;

import com.isnetworks.provider.jce.ISNetworksProvider;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.security.KeyFactory;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.MessageDigest;
import java.security.PrivateKey;
import java.security.Provider;
import java.security.PublicKey;
import java.security.Security;
import java.security.interfaces.RSAPrivateKey;
import java.security.interfaces.RSAPublicKey;
import java.security.spec.PKCS8EncodedKeySpec;
import java.security.spec.X509EncodedKeySpec;
import javax.crypto.Cipher;
import sun.misc.BASE64Decoder;
import sun.misc.BASE64Encoder;

public class Cryptography {
    public static final int RSA_KEY_LENGTH = 1024;
    public byte[] publicKey;
    public byte[] privateKey;
    private PublicKey publickey;
    private PrivateKey privatekey;
    private Cipher cipher;
    private KeyFactory keyFactory;
    private String blockDelimiter = "A L V A R I O N";

    public Cryptography() {
        Security.addProvider((Provider)new ISNetworksProvider());
        try {
            this.cipher = Cipher.getInstance("RSA/ECB/OAEPPadding", "ISNetworks");
            this.keyFactory = KeyFactory.getInstance("RSA", "ISNetworks");
        }
        catch (Exception e) {
            System.out.println(e.getMessage());
        }
    }

    public String encode(String text) {
        return this.encodeRSA(text);
    }

    public String decode(String encodedText) {
        return this.decodeRSA(encodedText);
    }

    public byte[] encode(byte[] data) {
        return this.encodeRSA(data);
    }

    public byte[] decode(byte[] encodedData) {
        return this.decodeRSA(encodedData);
    }

    public void generateKeys() {
        this.generateRSAKeys();
    }

    private void generateRSAKeys() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA", "ISNetworks");
            keyGen.initialize(1024);
            KeyPair pair = keyGen.generateKeyPair();
            RSAPublicKey publicKey = (RSAPublicKey)pair.getPublic();
            RSAPrivateKey privateKey = (RSAPrivateKey)pair.getPrivate();
            this.publicKey = publicKey.getEncoded();
            this.privateKey = privateKey.getEncoded();
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
        }
    }

    private void GetPublicKey() {
        try {
            X509EncodedKeySpec pubKeySpec = new X509EncodedKeySpec(this.publicKey);
            this.publickey = this.keyFactory.generatePublic(pubKeySpec);
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
        }
    }

    private void GetPrivateKey() {
        try {
            PKCS8EncodedKeySpec privKeySpec = new PKCS8EncodedKeySpec(this.privateKey);
            this.privatekey = this.keyFactory.generatePrivate(privKeySpec);
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
        }
    }

    private byte[] encodeRSA(byte[] data) {
        ByteArrayInputStream is = new ByteArrayInputStream(data);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.GetPublicKey();
        try {
            this.cipher.init(1, this.publickey);
            int mHLen = MessageDigest.getInstance("SHA-1").getDigestLength();
            int rsaBlockSize = this.cipher.getBlockSize() - 2 * mHLen - 1;
            byte[] dataBlock = new byte[rsaBlockSize];
            byte[] encodedBuffer = new byte[]{};
            while (is.available() > rsaBlockSize) {
                is.read(dataBlock, 0, rsaBlockSize);
                encodedBuffer = this.cipher.doFinal(dataBlock);
                os.write(encodedBuffer.length);
                os.write(encodedBuffer);
            }
            dataBlock = new byte[is.available()];
            if (is.read(dataBlock, 0, is.available()) != -1) {
                encodedBuffer = this.cipher.doFinal(dataBlock);
                os.write(encodedBuffer.length);
                os.write(encodedBuffer);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    private byte[] decodeRSA(byte[] encodedData) {
        ByteArrayInputStream is = new ByteArrayInputStream(encodedData);
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        this.GetPrivateKey();
        try {
            this.cipher.init(2, this.privatekey);
            while (is.available() > 0) {
                int bufferLength = is.read();
                byte[] dataBlock = new byte[bufferLength];
                is.read(dataBlock, 0, bufferLength);
                os.write(this.cipher.doFinal(dataBlock));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return os.toByteArray();
    }

    private String encodeRSA(String Text) {
        String encodedtext = "";
        BASE64Encoder encoder = new BASE64Encoder();
        this.GetPublicKey();
        try {
            this.cipher.init(1, this.publickey);
            int mHLen = MessageDigest.getInstance("SHA-1").getDigestLength();
            int blockSize = this.cipher.getBlockSize() - 2 * mHLen - 1;
            while (Text.length() > blockSize) {
                String textBlock = Text.substring(0, blockSize);
                Text = Text.substring(blockSize);
                encodedtext = encodedtext.concat(encoder.encodeBuffer(this.cipher.doFinal(textBlock.getBytes())));
                encodedtext = encodedtext.concat(this.blockDelimiter);
            }
            if (Text.length() != 0) {
                encodedtext = encodedtext.concat(encoder.encodeBuffer(this.cipher.doFinal(Text.getBytes())));
            }
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
        }
        return encodedtext;
    }

    private String decodeRSA(String EncodedText) {
        String decodedText = "";
        BASE64Decoder decoder = new BASE64Decoder();
        this.GetPrivateKey();
        try {
            this.cipher.init(2, this.privatekey);
            while (EncodedText.indexOf(this.blockDelimiter) != -1) {
                int idx = EncodedText.indexOf(this.blockDelimiter);
                String textBlock = EncodedText.substring(0, idx - 1);
                EncodedText = EncodedText.substring(idx + 16);
                decodedText = decodedText.concat(new String(this.cipher.doFinal(decoder.decodeBuffer(textBlock))));
            }
            if (EncodedText.length() != 0) {
                decodedText = decodedText.concat(new String(this.cipher.doFinal(decoder.decodeBuffer(EncodedText))));
            }
        }
        catch (Exception e) {
            System.err.println("Caught exception " + e.toString());
        }
        return decodedText;
    }
}

