/*
 * Decompiled with CFR 0.152.
 */
package com.licensing.test;

import com.licensing.test.DialogLicenseTest;
import com.licensing.verification.decryptapi.LicenseVerificator;
import com.licensing.verification.decryptapi.PrlLicenseDevice;
import com.licensing.verification.decryptapi.PrlManagementFeature;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.util.ArrayList;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultMutableTreeNode;

public class DialogLicenseInfo
extends JDialog {
    public static final String ROOT_NODE_NAME = "License information";
    public static final String LICENSE_NODE_NAME = "License";
    public static final String CUSTOMER_NODE_NAME = "Customer";
    public static final String IPADDRS_NODE_NAME = "IP Address / MAC Address";
    public static final String DEVICES_NODE_NAME = "Devices";
    public static final String FEATURES_NODE_NAME = "Features";
    public static final String MFEATURES_NODE_NAME = "Management features";
    private LicenseVerificator license;
    DefaultMutableTreeNode root = new DefaultMutableTreeNode("License information");
    JPanel jPanel1 = new JPanel();
    GridBagLayout gridBagLayout1 = new GridBagLayout();
    Border border1;
    JPanel jPanelData = new JPanel();
    JPanel jPanelBtns = new JPanel();
    GridBagLayout gridBagLayout2 = new GridBagLayout();
    JButton jButtonCancel = new JButton();
    GridBagLayout gridBagLayout3 = new GridBagLayout();
    JScrollPane jScrollPane1 = new JScrollPane();
    JTree jTreeLicense = new JTree(this.root);
    JMenuBar jMenuBar1 = new JMenuBar();
    JMenu jMenu1 = new JMenu();
    JMenuItem jMenuItemExit = new JMenuItem();
    JMenuItem jMenuItem1 = new JMenuItem();

    public DialogLicenseInfo(Frame frame, String title, boolean modal) {
        super(frame, title, modal);
        try {
            this.setVisible(false);
            this.license = new LicenseVerificator(new File(System.getProperty("user.dir") + "\\license.key"));
            this.jbInit();
            this.pack();
            this.setLocationRelativeTo(frame);
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Error", 0);
            System.exit(1);
        }
    }

    public DialogLicenseInfo() {
        this((Frame)null, "", false);
    }

    private void jbInit() throws Exception {
        this.border1 = BorderFactory.createEmptyBorder(5, 5, 5, 5);
        this.jPanel1.setBorder(this.border1);
        this.jPanel1.setMinimumSize(new Dimension(300, 200));
        this.jPanel1.setPreferredSize(new Dimension(400, 300));
        this.jPanel1.setLayout(this.gridBagLayout1);
        this.jPanelData.setLayout(this.gridBagLayout2);
        this.jButtonCancel.setText("Close");
        this.jButtonCancel.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogLicenseInfo.this.jButtonCancel_actionPerformed(e);
            }
        });
        this.jPanelBtns.setLayout(this.gridBagLayout3);
        this.jMenu1.setText("File");
        this.jMenuItemExit.setText("Exit");
        this.jMenuItemExit.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogLicenseInfo.this.jMenuItemExit_actionPerformed(e);
            }
        });
        this.setJMenuBar(this.jMenuBar1);
        this.setTitle(ROOT_NODE_NAME);
        this.jMenuItem1.setText("Test RSA Crypto");
        this.jMenuItem1.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent e) {
                DialogLicenseInfo.this.jMenuItem1_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.jPanelData, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanel1.add((Component)this.jPanelBtns, new GridBagConstraints(0, 1, 1, 1, 0.0, 0.0, 10, 2, new Insets(5, 0, 0, 0), 0, 0));
        this.jPanelBtns.add((Component)this.jButtonCancel, new GridBagConstraints(0, 0, 1, 1, 0.0, 0.0, 10, 0, new Insets(0, 0, 0, 0), 0, 0));
        this.jPanelData.add((Component)this.jScrollPane1, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.jScrollPane1.getViewport().add((Component)this.jTreeLicense, null);
        this.jMenuBar1.add(this.jMenu1);
        this.jMenu1.add(this.jMenuItem1);
        this.jMenu1.add(this.jMenuItemExit);
        this.initUser();
    }

    private void initUser() {
        this.createNodes(this.root);
    }

    private void createNodes(DefaultMutableTreeNode root) {
        int i;
        DefaultMutableTreeNode customerNode = null;
        DefaultMutableTreeNode licenseNode = null;
        DefaultMutableTreeNode ipAddressNode = null;
        DefaultMutableTreeNode deviceNode = null;
        DefaultMutableTreeNode mFeatureNode = null;
        ArrayList alIP = new ArrayList();
        ArrayList alMAC = new ArrayList();
        ArrayList alDevices = new ArrayList();
        ArrayList alMFeatures = new ArrayList();
        ArrayList<String> alProductLine = new ArrayList<String>();
        customerNode = new DefaultMutableTreeNode(CUSTOMER_NODE_NAME);
        licenseNode = new DefaultMutableTreeNode(LICENSE_NODE_NAME);
        ipAddressNode = new DefaultMutableTreeNode(IPADDRS_NODE_NAME);
        deviceNode = new DefaultMutableTreeNode(DEVICES_NODE_NAME);
        mFeatureNode = new DefaultMutableTreeNode(MFEATURES_NODE_NAME);
        root.add(customerNode);
        root.add(licenseNode);
        customerNode.add(new DefaultMutableTreeNode(this.license.getCustomerName()));
        licenseNode.add(new DefaultMutableTreeNode("NMS clients count: " + Integer.toString(this.license.getLicensedClientsNumber())));
        licenseNode.add(new DefaultMutableTreeNode("Purchase Order: " + Integer.toString(this.license.getLicensedPurchaseOrder())));
        licenseNode.add(ipAddressNode);
        licenseNode.add(deviceNode);
        licenseNode.add(mFeatureNode);
        alIP = this.license.getIPList();
        alMAC = this.license.getMACList();
        for (i = 0; i < alIP.size(); ++i) {
            ipAddressNode.add(new DefaultMutableTreeNode(alIP.get(i) + " / " + alMAC.get(i)));
        }
        alDevices = this.license.getLicensedDevicesList();
        for (i = 0; i < alDevices.size(); ++i) {
            if (alProductLine.contains(((PrlLicenseDevice)alDevices.get((int)i)).ProductName)) continue;
            alProductLine.add(((PrlLicenseDevice)alDevices.get((int)i)).ProductName);
        }
        for (i = 0; i < alProductLine.size(); ++i) {
            DefaultMutableTreeNode productNode = new DefaultMutableTreeNode(alProductLine.get(i));
            deviceNode.add(productNode);
            for (int j = 0; j < alDevices.size(); ++j) {
                if (!((PrlLicenseDevice)alDevices.get((int)j)).ProductName.equals(alProductLine.get(i))) continue;
                productNode.add(new DefaultMutableTreeNode(((PrlLicenseDevice)alDevices.get((int)j)).DeviceName + "; count: " + Integer.toString(((PrlLicenseDevice)alDevices.get((int)j)).DeviceCount)));
            }
        }
        alMFeatures = this.license.getManagementFeaturesList();
        for (i = 0; i < alMFeatures.size(); ++i) {
            mFeatureNode.add(new DefaultMutableTreeNode(((PrlManagementFeature)alMFeatures.get((int)i)).FeatureName));
        }
    }

    void jButtonCancel_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void jMenuItemExit_actionPerformed(ActionEvent e) {
        this.dispose();
    }

    void jMenuItem1_actionPerformed(ActionEvent e) {
        DialogLicenseTest dlg = new DialogLicenseTest(null, "", true);
        dlg.setVisible(true);
    }
}

