/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration.config;

import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.config.ExportDefinition;
import com.bwanms.setup.migration.config.IncludeClass;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;

public class ExportDefinitionConverter
implements Converter {
    private static final TrivialLogger log = TrivialLogger.getLogger(ExportDefinitionConverter.class);

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        ExportDefinition ed = new ExportDefinition();
        ed.setModule(reader.getAttribute("module"));
        ed.setVersion(reader.getAttribute("version"));
        log.debug("module " + ed.getModule() + " version " + ed.getVersion(), new Object[0]);
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            IncludeClass ict = new IncludeClass();
            ict.setName(reader.getAttribute("name"));
            log.debug("include class " + ict.getName(), new Object[0]);
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("exclude-attr".equals(reader.getNodeName())) {
                    ict.getExcludeAttr().add(reader.getValue());
                    log.debug("exclude attribute " + reader.getValue(), new Object[0]);
                } else if ("include-attr".equals(reader.getNodeName())) {
                    ict.getIncludeAttr().add(reader.getValue());
                    log.debug("include attribute " + reader.getValue(), new Object[0]);
                }
                reader.moveUp();
            }
            ed.getIncludeClass().add(ict);
            reader.moveUp();
        }
        return ed;
    }

    public boolean canConvert(Class type) {
        return ExportDefinition.class.equals((Object)type);
    }
}

