/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration.backup.license;

import com.bwanms.model.license.License;
import com.bwanms.model.license.LicenseFile;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.Utils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import javax.persistence.Table;

public class BackupLicense {
    private static String LICENSE_TABLE_NAME = License.class.getAnnotation(Table.class).name();
    private static String LICENSE_FILE_TABLE_NAME;
    private static final TrivialLogger log;

    public static void main(String[] args) {
        log.info("TASK:Backup License Files", new Object[0]);
        log.info("PROG:0", new Object[0]);
        if (args.length > 0) {
            File dir = new File(args[0]);
            if (!dir.isDirectory() && !dir.mkdirs()) {
                log.info("ERROR:error creating backup path " + dir.getAbsolutePath(), new Object[0]);
                System.exit(1);
            }
            BackupLicense.doBackup(dir);
        } else {
            log.info("ERROR:no output folder", new Object[0]);
            System.exit(1);
        }
        log.info("PROG:100", new Object[0]);
    }

    private static void doBackup(File dir) {
        try {
            Connection con = Utils.getDBConnection();
            try {
                int all;
                Statement stm = con.createStatement();
                String query = "SELECT COUNT(*) FROM " + LICENSE_TABLE_NAME + ", " + LICENSE_FILE_TABLE_NAME + " WHERE " + LICENSE_TABLE_NAME + ".licenseFile_id = " + LICENSE_FILE_TABLE_NAME + ".id";
                ResultSet rs = stm.executeQuery(query);
                if (rs.next() && (all = rs.getInt(1)) > 0) {
                    query = "SELECT " + LICENSE_FILE_TABLE_NAME + ".id, " + LICENSE_TABLE_NAME + ".active, " + LICENSE_FILE_TABLE_NAME + ".licenseBytes" + " FROM " + LICENSE_TABLE_NAME + ", " + LICENSE_FILE_TABLE_NAME + " WHERE " + LICENSE_TABLE_NAME + ".licenseFile_id = " + LICENSE_FILE_TABLE_NAME + ".id";
                    rs = stm.executeQuery(query);
                    int prog = 0;
                    String filePath = dir.getAbsolutePath() + File.separator;
                    while (rs.next()) {
                        String id = rs.getString(1);
                        boolean active = rs.getBoolean(2);
                        Blob license = rs.getBlob(3);
                        String fileName = "License_" + id + (active ? "_active" : "") + ".key";
                        log.info("Creating license file " + fileName, new Object[0]);
                        BackupLicense.writeToFile(filePath + fileName, license.getBinaryStream());
                        log.info("OK", new Object[0]);
                        log.info("PROG:" + ++prog * 100 / all, new Object[0]);
                    }
                }
            }
            catch (SQLException sqle) {
                log.info("ERROR:" + sqle.getMessage(), new Object[0]);
                System.exit(1);
            }
        }
        catch (Throwable e) {
            log.info("ERROR:" + e.getMessage(), new Object[0]);
            System.exit(1);
        }
    }

    private static void writeToFile(String name, InputStream is) {
        byte[] b = new byte[1024];
        try {
            int len;
            FileOutputStream out = new FileOutputStream(name);
            while ((len = is.read(b)) > 0) {
                ((OutputStream)out).write(b, 0, len);
            }
        }
        catch (FileNotFoundException fnfe) {
            log.info("ERROR:" + fnfe.getMessage(), new Object[0]);
        }
        catch (IOException ioe) {
            log.info("ERROR:" + ioe.getMessage(), new Object[0]);
        }
    }

    static {
        if ((LICENSE_TABLE_NAME == null || LICENSE_TABLE_NAME.equals("")) && ((LICENSE_TABLE_NAME = License.class.getAnnotation(org.hibernate.annotations.Table.class).name()) == null || LICENSE_TABLE_NAME.equals(""))) {
            LICENSE_TABLE_NAME = License.class.getSimpleName();
        }
        if (((LICENSE_FILE_TABLE_NAME = LicenseFile.class.getAnnotation(Table.class).name()) == null || LICENSE_FILE_TABLE_NAME.equals("")) && ((LICENSE_FILE_TABLE_NAME = LicenseFile.class.getAnnotation(org.hibernate.annotations.Table.class).name()) == null || LICENSE_FILE_TABLE_NAME.equals(""))) {
            LICENSE_FILE_TABLE_NAME = LicenseFile.class.getSimpleName();
        }
        log = TrivialLogger.getLogger();
    }
}

