/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration.backup.configuration;

import com.bwanms.model.file.AbstractFile;
import com.bwanms.model.file.FileData;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.Utils;
import com.bwanms.util.EntityUtil;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.zip.ZipException;
import java.util.zip.ZipInputStream;

public class BackupConfiguration {
    private static String ABSTRACT_FILE_TABLE_NAME = EntityUtil.getTableName(AbstractFile.class);
    private static String CONFIGURATION_BACKUP_TABLE_NAME = "RbBackupConfigFile";
    private static String FILE_DATA_TABLE_NAME = EntityUtil.getTableName(FileData.class);
    private static final TrivialLogger log = TrivialLogger.getLogger();

    public static void main(String[] args) {
        log.info("TASK:Backup Configuration Files", new Object[0]);
        log.info("PROG:0", new Object[0]);
        if (args.length > 0) {
            File dir = new File(args[0]);
            if (!dir.isDirectory() && !dir.mkdirs()) {
                log.info("ERROR: error creating backup path " + dir.getAbsolutePath(), new Object[0]);
                System.exit(1);
            }
            BackupConfiguration.doBackup(dir);
        } else {
            log.info("ERROR:no output folder", new Object[0]);
            System.exit(1);
        }
        log.info("PROG:100", new Object[0]);
    }

    private static void doBackup(File dir) {
        try {
            Connection con = Utils.getDBConnection();
            try {
                int all;
                Statement stm = con.createStatement();
                String query = "SELECT COUNT(*) FROM " + ABSTRACT_FILE_TABLE_NAME + ", " + CONFIGURATION_BACKUP_TABLE_NAME + ", " + FILE_DATA_TABLE_NAME + " WHERE " + ABSTRACT_FILE_TABLE_NAME + ".id=" + CONFIGURATION_BACKUP_TABLE_NAME + ".id AND " + ABSTRACT_FILE_TABLE_NAME + ".fileData_id = " + FILE_DATA_TABLE_NAME + ".id";
                ResultSet rs = stm.executeQuery(query);
                if (rs.next() && (all = rs.getInt(1)) > 0) {
                    query = "SELECT " + CONFIGURATION_BACKUP_TABLE_NAME + ".equipmentName, " + CONFIGURATION_BACKUP_TABLE_NAME + ".fileType, " + ABSTRACT_FILE_TABLE_NAME + ".timestamp, " + FILE_DATA_TABLE_NAME + ".bytes" + " FROM " + ABSTRACT_FILE_TABLE_NAME + ", " + CONFIGURATION_BACKUP_TABLE_NAME + ", " + FILE_DATA_TABLE_NAME + " WHERE " + ABSTRACT_FILE_TABLE_NAME + ".id=" + CONFIGURATION_BACKUP_TABLE_NAME + ".id AND " + ABSTRACT_FILE_TABLE_NAME + ".fileData_id = " + FILE_DATA_TABLE_NAME + ".id";
                    rs = stm.executeQuery(query);
                    int prog = 0;
                    SimpleDateFormat sdf = new SimpleDateFormat("MM.dd.yy.HH.mm.ss");
                    Calendar calendar = Calendar.getInstance();
                    String filePath = dir.getAbsolutePath() + File.separator;
                    while (rs.next()) {
                        String eqName = rs.getString(1);
                        String fileType = rs.getString(2);
                        long date = rs.getLong(3);
                        Blob fileData = rs.getBlob(4);
                        calendar.setTimeInMillis(date);
                        String fileName = eqName + "_" + fileType + "_" + sdf.format(calendar.getTime()) + ".res";
                        log.info("Creating backup file " + fileName, new Object[0]);
                        BackupConfiguration.writeToFile(filePath + fileName, fileData.getBinaryStream());
                        log.info("OK", new Object[0]);
                        log.info("PROG:" + ++prog * 100 / all, new Object[0]);
                    }
                }
            }
            catch (SQLException sqle) {
                log.info("ERROR:" + sqle.getMessage(), new Object[0]);
                System.exit(1);
            }
        }
        catch (Throwable e) {
            log.info("ERROR:" + e.getMessage(), new Object[0]);
            System.exit(1);
        }
    }

    private static void writeToFile(String name, InputStream is) {
        byte[] b = new byte[1024];
        try {
            int len;
            FileOutputStream out = new FileOutputStream(name);
            ZipInputStream zis = new ZipInputStream(is);
            zis.getNextEntry();
            while ((len = zis.read(b, 0, 1024)) > 0) {
                ((OutputStream)out).write(b, 0, len);
            }
        }
        catch (FileNotFoundException fnfe) {
            log.info("ERROR: " + fnfe.getMessage(), new Object[0]);
        }
        catch (ZipException ze) {
            log.info("ERROR: " + ze.getMessage(), new Object[0]);
        }
        catch (IOException ioe) {
            log.info("ERROR: " + ioe.getMessage(), new Object[0]);
        }
    }
}

