/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration.backup;

import com.bwanms.model.ObjectID;
import com.bwanms.setup.migration.HibernateUtil;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.Utils;
import com.bwanms.setup.migration.backup.Attribute;
import com.bwanms.setup.migration.backup.ObjectType;
import com.bwanms.setup.migration.backup.Partition;
import com.bwanms.setup.migration.model.ImportCache;
import com.ngnms.setup.migration.Base64Decoder;
import com.ngnms.setup.migration.Base64Encoder;
import com.ngnms.setup.migration.Base64FormatException;
import com.thoughtworks.xstream.converters.ConversionException;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.Entity;
import org.hibernate.Criteria;
import org.hibernate.EntityMode;
import org.hibernate.Session;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PartitionConverter
implements Converter {
    private static final TrivialLogger log = TrivialLogger.getLogger(PartitionConverter.class);
    private static final String UID_KEY = "UID_KEY";
    private static final String TAG_OBJECT = "object";
    private static final String TAG_REFOBJ = "refobj";
    private static final String TAG_ATTRIBUTE = "attribute";
    private static final String TAG_PRIMITIVE = "primitive";
    private static final String TAG_STREAM = "stream";
    private static final String TAG_MAP = "map";
    private static final String TAG_COLLECTION = "collection";
    private static final String TAG_ARRAY = "array";
    private static final String TAG_NULL = "null";
    private static final String TAG_VALUE = "value";
    private static final String TAG_ENTRY = "entry";
    private static final String TAG_KEY = "key";
    private static final String LIST = "list";
    private static final String SET = "set";
    private static HashSet<Class<? extends Serializable>> primitives = new HashSet();
    private Session session = null;

    public PartitionConverter(Session session) {
        this.session = session;
    }

    public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        Partition partition = (Partition)source;
        writer.addAttribute("module", partition.getModule());
        writer.addAttribute("version", partition.getVersion());
        if (context.get((Object)UID_KEY) == null) {
            context.put((Object)UID_KEY, new HashMap());
        }
        Map<String, ObjectType> objects = partition.getObjects();
        for (ObjectType objectType : objects.values()) {
            this.marshalObjectType(writer, context, objects, objectType);
        }
    }

    private void marshalObjectType(HierarchicalStreamWriter writer, MarshallingContext context, Map<String, ObjectType> objects, ObjectType objectType) {
        String className = objectType.getType();
        int pos = className.lastIndexOf(46);
        String simpleName = "";
        if (pos > -1) {
            simpleName = className.substring(pos + 1);
        }
        String msg = "Exporting... " + simpleName;
        log.info(msg, new Object[0]);
        log.info("TASK:" + msg, new Object[0]);
        ClassMetadata classMetadata = this.session.getSessionFactory().getClassMetadata(className);
        Criteria criteria = this.session.createCriteria(className);
        int startPage = 0;
        int batchSize = 1000;
        int results = 0;
        int total = 0;
        criteria.setMaxResults(batchSize);
        long start = 0L;
        long selectTime = 0L;
        do {
            log.info("START STEP", new Object[0]);
            start = System.currentTimeMillis();
            List beans = this.select(criteria, startPage);
            selectTime = System.currentTimeMillis() - start;
            results = beans.size();
            log.info(String.format("Extracted %d %s in %d millis", results, simpleName, selectTime), new Object[0]);
            startPage += batchSize;
            this.marshalBeans(writer, context, objects, objectType, beans, classMetadata);
            this.session.clear();
            long duration = System.currentTimeMillis() - start;
            log.info(String.format("Exported %d/%d %s in %d/%d millis", results, total += results, simpleName, duration - selectTime, duration), new Object[0]);
        } while (results == batchSize);
        log.info(String.format("Finish exporting %d %s", total, simpleName), new Object[0]);
    }

    private void marshalBeans(HierarchicalStreamWriter writer, MarshallingContext context, Map<String, ObjectType> objects, ObjectType objectType, List beans, ClassMetadata classMetadata) {
        int count = 0;
        StringBuilder builder = new StringBuilder(60);
        for (Object bean : beans) {
            ++count;
            builder.setLength(0);
            builder.append(objectType.getType()).append(".").append(classMetadata.getIdentifier(bean, EntityMode.POJO));
            String uid = builder.toString();
            if (this.marshalledObject(uid, context)) continue;
            this.marshallObject(writer, objects, bean, context);
        }
    }

    private List select(Criteria criteria, int startPage) {
        criteria.setFirstResult(startPage);
        List beans = criteria.list();
        return beans;
    }

    private boolean marshalledObject(String uid, MarshallingContext context) {
        return ((HashMap)context.get((Object)UID_KEY)).containsKey(uid);
    }

    private void cacheUID(String uid, MarshallingContext context) {
        HashMap cache = (HashMap)context.get((Object)UID_KEY);
        cache.put(uid, null);
    }

    private void marshallObject(HierarchicalStreamWriter writer, Map<String, ObjectType> objects, Object bean, MarshallingContext context) {
        Class<?> beanClass = bean.getClass();
        if (beanClass.isArray()) {
            this.marshallArray(bean, writer, objects, context);
        } else if (beanClass.getAnnotation(Entity.class) != null) {
            this.marshallEntity(writer, objects, bean, context);
        } else if (bean instanceof Collection) {
            this.marshalCollection((Collection)bean, writer, objects, context);
        } else if (bean instanceof Map) {
            this.marshalMap((Map)bean, writer, objects, context);
        } else if (beanClass.isPrimitive() || primitives.contains(beanClass)) {
            boolean stringWorkaround = false;
            if (String.class.isAssignableFrom(beanClass)) {
                String str = (String)bean;
                int len = str.length();
                int i = 0;
                while (i < len && !Character.isIdentifierIgnorable(str.charAt(i++))) {
                }
                boolean bl = stringWorkaround = i < len;
            }
            if (stringWorkaround) {
                this.marshallStream((Serializable)bean, writer, objects, context);
            } else {
                this.marshalPrimitive(bean, writer);
            }
        } else if (bean instanceof Serializable) {
            this.marshallStream((Serializable)bean, writer, objects, context);
        } else {
            ConversionException conversionException = new ConversionException("unsupported attribute type (not Serializable) " + bean.getClass());
            throw conversionException;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private void marshallArray(Object bean, HierarchicalStreamWriter writer, Map<String, ObjectType> objects, MarshallingContext context) {
        Class<?> beanClass = bean.getClass();
        Class<?> componentType = beanClass.getComponentType();
        writer.startNode(TAG_ARRAY);
        writer.addAttribute("type", componentType.getName());
        if (componentType.isPrimitive()) {
            if (!byte[].class.equals(beanClass)) throw new ConversionException(" array of primitive " + componentType + " not supported");
            writer.startNode(TAG_VALUE);
            writer.setValue(new String(this.encodeBase64((byte[])bean)));
            writer.endNode();
        } else {
            Object[] values = (Object[])bean;
            for (int i = 0; i < values.length; ++i) {
                this.marshallObject(writer, objects, values[i], context);
            }
        }
        writer.endNode();
    }

    private void marshallEntity(HierarchicalStreamWriter writer, Map<String, ObjectType> objects, Object bean, MarshallingContext context) {
        String uid;
        ClassMetadata classMetadata = this.session.getSessionFactory().getClassMetadata(bean.getClass());
        ObjectType objectType = objects.get(bean.getClass().getName());
        if (objectType == null) {
            objectType = Utils.createObjectType(bean, classMetadata);
        }
        if (this.marshalledObject(uid = objectType.getType() + "." + classMetadata.getIdentifier(bean, EntityMode.POJO), context)) {
            writer.startNode(TAG_REFOBJ);
            writer.addAttribute("type", objectType.getType());
            writer.addAttribute("uid", uid);
            writer.endNode();
            return;
        }
        this.cacheUID(uid, context);
        writer.startNode(TAG_OBJECT);
        writer.addAttribute("type", objectType.getType());
        log.debug("bean " + bean + " metadata for class " + classMetadata.getEntityName(), new Object[0]);
        log.debug("entityname " + classMetadata.getEntityName() + " mappedClass " + classMetadata.getMappedClass(EntityMode.POJO), new Object[0]);
        writer.addAttribute("uid", uid);
        List<Attribute> attributes = objectType.getAttributes();
        for (Attribute attribute : attributes) {
            writer.startNode(TAG_ATTRIBUTE);
            writer.addAttribute("name", attribute.getName());
            log.debug("attribute " + attribute.getName(), new Object[0]);
            Object propertyValue = classMetadata.getPropertyValue(bean, attribute.getName(), EntityMode.POJO);
            log.debug(" value " + propertyValue, new Object[0]);
            if (propertyValue == null) {
                writer.startNode(TAG_NULL);
                writer.endNode();
            } else {
                this.marshallObject(writer, objects, propertyValue, context);
            }
            writer.endNode();
        }
        writer.endNode();
    }

    private void marshallStream(Serializable value, HierarchicalStreamWriter writer, Map<String, ObjectType> objects, MarshallingContext context) {
        writer.startNode(TAG_STREAM);
        writer.addAttribute("type", value.getClass().getName());
        writer.setValue(new String(this.encodeBase64(value)));
        writer.endNode();
    }

    private void marshalMap(Map map, HierarchicalStreamWriter writer, Map<String, ObjectType> objects, MarshallingContext context) {
        writer.startNode(TAG_MAP);
        if (map != null) {
            for (Map.Entry entry : map.entrySet()) {
                writer.startNode(TAG_ENTRY);
                writer.startNode(TAG_KEY);
                this.marshallObject(writer, objects, entry.getKey(), context);
                writer.endNode();
                writer.startNode(TAG_VALUE);
                this.marshallObject(writer, objects, entry.getValue(), context);
                writer.endNode();
                writer.endNode();
            }
        }
        writer.endNode();
    }

    private void marshalPrimitive(Object propertyValue, HierarchicalStreamWriter writer) {
        writer.startNode(TAG_PRIMITIVE);
        writer.addAttribute("type", propertyValue.getClass().getName());
        writer.setValue(propertyValue.toString());
        writer.endNode();
    }

    private void marshalCollection(Collection collection, HierarchicalStreamWriter writer, Map<String, ObjectType> objects, MarshallingContext context) {
        writer.startNode(TAG_COLLECTION);
        writer.addAttribute("type", this.getCollectionType(collection.getClass()));
        Iterator iter = collection.iterator();
        while (iter.hasNext()) {
            this.marshallObject(writer, objects, iter.next(), context);
        }
        writer.endNode();
    }

    private String getCollectionType(Class clazz) {
        if (!Collection.class.isAssignableFrom(clazz)) {
            throw new ConversionException("class " + clazz + " is not a Collection");
        }
        if (List.class.isAssignableFrom(clazz)) {
            return LIST;
        }
        if (Set.class.isAssignableFrom(clazz)) {
            return SET;
        }
        throw new ConversionException("Collection of subtype " + clazz + " not supported!");
    }

    private byte[] encodeBase64(Object bean) {
        try {
            ByteArrayOutputStream buff = new ByteArrayOutputStream();
            ObjectOutputStream outObj = new ObjectOutputStream(buff);
            outObj.writeObject(bean);
            outObj.close();
            return this.encodeBase64(buff.toByteArray());
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    private byte[] encodeBase64(byte[] bytes) {
        ByteArrayOutputStream out64 = new ByteArrayOutputStream();
        Base64Encoder encoder = new Base64Encoder((InputStream)new ByteArrayInputStream(bytes), (OutputStream)out64);
        try {
            encoder.process();
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
        return out64.toByteArray();
    }

    private Object decodeObjectBase64(String value) {
        ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64Decoder decoder = new Base64Decoder((InputStream)in, (OutputStream)out);
        try {
            decoder.process();
            byte[] bytes = out.toByteArray();
            ObjectInputStream ois = new ObjectInputStream(new ByteArrayInputStream(bytes));
            return ois.readObject();
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
        catch (Base64FormatException e) {
            throw new ConversionException((Throwable)e);
        }
        catch (ClassNotFoundException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    private byte[] decodeBytesBase64(String value) {
        ByteArrayInputStream in = new ByteArrayInputStream(value.getBytes());
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        Base64Decoder decoder = new Base64Decoder((InputStream)in, (OutputStream)out);
        try {
            decoder.process();
            return out.toByteArray();
        }
        catch (IOException e) {
            throw new ConversionException((Throwable)e);
        }
        catch (Base64FormatException e) {
            throw new ConversionException((Throwable)e);
        }
    }

    public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Partition partition = new Partition();
        partition.setModule(reader.getAttribute("module"));
        partition.setVersion(reader.getAttribute("version"));
        String msg = "Importing... " + partition.getModule();
        log.info(msg, new Object[0]);
        log.info("TASK:" + msg, new Object[0]);
        log.info("PROG:0", new Object[0]);
        if (context.get((Object)UID_KEY) == null) {
            context.put((Object)UID_KEY, new HashMap());
        }
        int batch = 20;
        int counter = 0;
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            String nodeName = reader.getNodeName();
            if (TAG_OBJECT.equals(nodeName)) {
                this.umarshalObject(reader, context);
                if (++counter % batch == 0) {
                    this.session.flush();
                    this.session.clear();
                }
            }
            reader.moveUp();
        }
        log.info("PROG:100", new Object[0]);
        return partition;
    }

    private Object umarshalObject(HierarchicalStreamReader reader, UnmarshallingContext context) {
        log.debug("umarshal Object", new Object[0]);
        String objType = reader.getAttribute("type");
        String uid = reader.getAttribute("uid");
        log.debug("type " + objType + " uid " + uid, new Object[0]);
        try {
            Class<?> objClass = Class.forName(objType);
            String objId = uid.split(objType + ".")[1];
            log.debug("obj id " + objId, new Object[0]);
            ClassMetadata classMetadata = HibernateUtil.currentSession().getSessionFactory().getClassMetadata(objClass);
            Class idClass = classMetadata.getIdentifierType().getReturnedClass();
            Serializable idInstance = (Serializable)idClass.getConstructor(String.class).newInstance(objId);
            log.debug("identifier class " + idClass, new Object[0]);
            Object bean = classMetadata.instantiate(idInstance, EntityMode.POJO);
            log.debug("instance " + bean, new Object[0]);
            this.memoryCache(uid, bean, context);
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                String nodeName = reader.getNodeName();
                if (!TAG_ATTRIBUTE.equals(nodeName)) {
                    throw new ConversionException("tag not suported " + nodeName);
                }
                String attName = reader.getAttribute("name");
                log.debug("node " + nodeName + " name " + attName, new Object[0]);
                Object value = this.unmarshalAttribute(reader, context);
                classMetadata.setPropertyValue(bean, attName, value, EntityMode.POJO);
                reader.moveUp();
            }
            log.debug("save entity " + bean, new Object[0]);
            this.session.save(bean);
            this.cacheDBObject(uid, classMetadata, bean);
            this.removeMemoryCached(uid, context);
            return bean;
        }
        catch (Exception e) {
            throw new ConversionException("Failed to unmarshal object: " + uid, (Throwable)e);
        }
    }

    private void removeMemoryCached(String uid, UnmarshallingContext context) {
        ((HashMap)context.get((Object)UID_KEY)).remove(uid);
    }

    private void memoryCache(String uid, Object bean, UnmarshallingContext context) {
        ((HashMap)context.get((Object)UID_KEY)).put(uid, bean);
    }

    private Object getMemoryCached(String uid, UnmarshallingContext context) {
        return ((HashMap)context.get((Object)UID_KEY)).get(uid);
    }

    private void cacheDBObject(String uid, ClassMetadata classMetadata, Object bean) {
        ImportCache cache = new ImportCache();
        cache.setClassName(bean.getClass().getName());
        cache.setNewId((Long)classMetadata.getIdentifier(bean, EntityMode.POJO));
        String[] values = this.decodeUID(uid);
        cache.setOldId(Long.parseLong(values[1]));
        log.debug("caching: " + cache, new Object[0]);
        this.session.save((Object)cache);
    }

    private Object getCachedObject(String uid, UnmarshallingContext context) {
        Object temp = this.getMemoryCached(uid, context);
        if (temp != null) {
            return temp;
        }
        String[] result = this.decodeUID(uid);
        ImportCache cached = (ImportCache)this.session.createCriteria(ImportCache.class).add((Criterion)Restrictions.eq((String)"className", (Object)result[0])).add((Criterion)Restrictions.eq((String)"oldId", (Object)new Long(result[1]))).uniqueResult();
        log.debug("Get cached: " + cached, new Object[0]);
        Object bean = this.session.get(result[0], (Serializable)Long.valueOf(cached.getNewId()));
        log.debug("bean: " + bean, new Object[0]);
        return bean;
    }

    String[] decodeUID(String uid) {
        int index = uid.lastIndexOf(".");
        String clazz = uid.substring(0, index);
        String id = uid.substring(index + 1);
        log.debug(String.format("Class %s with id %s", clazz, id), new Object[0]);
        return new String[]{clazz, id};
    }

    private Object unmarshalAttribute(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object result = null;
        if (reader.hasMoreChildren()) {
            reader.moveDown();
            result = this.delegateUnmarshall(reader, context);
            reader.moveUp();
        }
        return result;
    }

    /*
     * WARNING - void declaration
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private Object umarshalArray(HierarchicalStreamReader reader, UnmarshallingContext context) {
        void var5_8;
        String type = reader.getAttribute("type");
        if (!reader.hasMoreChildren()) return null;
        reader.moveDown();
        String childName = reader.getNodeName();
        Object var5_5 = null;
        if (TAG_VALUE.equals(childName)) {
            if (!"byte".equals(type)) throw new ConversionException(" array of primitive " + type + " not supported");
            byte[] byArray = this.decodeBytesBase64(reader.getValue());
        } else {
            LinkedList<Object> list = new LinkedList<Object>();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                Object element = this.delegateUnmarshall(reader, context);
                list.add(element);
                reader.moveUp();
            }
            try {
                Object[] objectArray = list.toArray((Object[])Array.newInstance(Class.forName(type), list.size()));
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        reader.moveUp();
        return var5_8;
    }

    private Object umarshalRefObj(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String attrUID = reader.getAttribute("uid");
        log.debug("refobj " + attrUID, new Object[0]);
        return this.getCachedObject(attrUID, context);
    }

    private Collection<Object> unmarshalCollection(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            ArrayList<Object> result;
            String type = reader.getAttribute("type");
            if (LIST.equals(type)) {
                result = new ArrayList();
            } else if (SET.equals(type)) {
                result = new HashSet();
            } else {
                throw new ConversionException("Collection of type " + type + " not supported!");
            }
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                Object element = this.delegateUnmarshall(reader, context);
                result.add(element);
                reader.moveUp();
            }
            return result;
        }
        catch (SecurityException e) {
            throw new ConversionException("", (Throwable)e);
        }
    }

    private Object delegateUnmarshall(HierarchicalStreamReader reader, UnmarshallingContext context) {
        Object element = null;
        String nodeName = reader.getNodeName();
        if (TAG_PRIMITIVE.equals(nodeName)) {
            element = this.unmarshalPrimitive(reader, context);
        } else if (TAG_STREAM.equals(nodeName)) {
            element = this.unmarshalStream(reader, context);
        } else if (TAG_MAP.equals(nodeName)) {
            element = this.unmarshalMap(reader, context);
        } else if (TAG_COLLECTION.equals(nodeName)) {
            element = this.unmarshalCollection(reader, context);
        } else if (TAG_OBJECT.equals(nodeName)) {
            element = this.umarshalObject(reader, context);
        } else if (TAG_REFOBJ.equals(nodeName)) {
            element = this.umarshalRefObj(reader, context);
        } else if (TAG_ARRAY.equals(nodeName)) {
            element = this.umarshalArray(reader, context);
        } else if (!TAG_NULL.equals(nodeName)) {
            throw new UnsupportedOperationException("node not suported " + nodeName);
        }
        return element;
    }

    private Map unmarshalMap(HierarchicalStreamReader reader, UnmarshallingContext context) {
        HashMap<Object, Object> result = new HashMap<Object, Object>();
        while (reader.hasMoreChildren()) {
            reader.moveDown();
            reader.moveDown();
            reader.moveDown();
            Object key = this.delegateUnmarshall(reader, context);
            reader.moveUp();
            reader.moveUp();
            reader.moveDown();
            reader.moveDown();
            Object value = this.umarshalObject(reader, context);
            reader.moveUp();
            reader.moveUp();
            result.put(key, value);
            reader.moveUp();
        }
        return new HashMap();
    }

    private Object unmarshalStream(HierarchicalStreamReader reader, UnmarshallingContext context) {
        String value = reader.getValue();
        Object obj = this.decodeObjectBase64(value);
        if (obj instanceof ObjectID) {
            ObjectID objID = (ObjectID)obj;
            StringBuilder uid = new StringBuilder();
            uid.append(objID.getClassName()).append(".").append(objID.getIdentifier().toString());
            Object owner = this.getCachedObject(uid.toString(), context);
            if (owner != null) {
                return new ObjectID(objID.getClassName(), this.session.getIdentifier(owner));
            }
        }
        return obj;
    }

    private Object unmarshalPrimitive(HierarchicalStreamReader reader, UnmarshallingContext context) {
        try {
            String result;
            String type = reader.getAttribute("type");
            String value = reader.getValue();
            log.debug("\tnode primitive type " + type + " value " + value, new Object[0]);
            if (String.class.getName().equals(type)) {
                result = value;
            } else {
                Class<?> attClass = Class.forName(type);
                if (primitives.contains(attClass)) {
                    result = attClass.getConstructor(String.class).newInstance(value);
                } else {
                    throw new ConversionException(attClass + " not supported as primitives!");
                }
            }
            return result;
        }
        catch (Exception e) {
            throw new ConversionException("", (Throwable)e);
        }
    }

    public boolean canConvert(Class type) {
        return Partition.class.equals((Object)type);
    }

    static {
        primitives.add(Integer.class);
        primitives.add(Long.class);
        primitives.add(Byte.class);
        primitives.add(Short.class);
        primitives.add(Float.class);
        primitives.add(Double.class);
        primitives.add(Boolean.class);
        primitives.add(String.class);
    }
}

