/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.plugin.impl.PluginScanner;
import com.bwanms.setup.migration.DatasourceParser;
import com.bwanms.setup.migration.Datasources;
import com.bwanms.setup.migration.ExportException;
import com.bwanms.setup.migration.HibernateUtil;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.backup.Attribute;
import com.bwanms.setup.migration.backup.ObjectType;
import com.bwanms.setup.migration.config.ExportDefinition;
import com.bwanms.setup.migration.config.ExportDefinitionConverter;
import com.bwanms.setup.migration.config.IncludeClass;
import com.bwanms.util.JarResources;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.sql.Connection;
import java.sql.DriverManager;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import org.hibernate.EntityMode;
import org.hibernate.metadata.ClassMetadata;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class Utils {
    private static final TrivialLogger log = TrivialLogger.getLogger(Utils.class);
    public static final String METAINF_FILE = "META-INF/meta-inf.xml";
    public static final String EXPORTDEF_FILE = "export-def.xml";
    public static final String TRANSFORM_FILE = "transform.xsl";
    public static final String BACKUP_FILE = "backup.xml";

    public static ObjectType createObjectType(Object bean, ClassMetadata classMetadata) {
        ObjectType type = new ObjectType();
        type.setType(bean.getClass().getName());
        String[] propertyNames = classMetadata.getPropertyNames();
        List<Attribute> attributes = type.getAttributes();
        Class clasz = classMetadata.getMappedClass(EntityMode.POJO);
        for (int j = 0; j < propertyNames.length; ++j) {
            Method setter = Utils.getSetter(clasz, propertyNames[j]);
            if (setter != null && Modifier.isPublic(setter.getModifiers())) {
                log.debug("property " + propertyNames[j] + " added", new Object[0]);
                Attribute attribute = new Attribute();
                attribute.setName(propertyNames[j]);
                attributes.add(attribute);
                continue;
            }
            log.debug("property " + propertyNames[j] + " excluded (setter is not public)", new Object[0]);
        }
        return type;
    }

    public static ObjectType createObjectType(IncludeClass includedClass) throws ExportException {
        log.info("creating objectType for class " + includedClass.getName(), null);
        ClassMetadata classMetadata = HibernateUtil.getClassMetadata(includedClass.getName());
        if (classMetadata == null) {
            throw new ExportException("mapping for entity " + includedClass.getName() + " not found!");
        }
        String[] propertyNames = classMetadata.getPropertyNames();
        Class clasz = classMetadata.getMappedClass(EntityMode.POJO);
        boolean hasAttributes = includedClass.hasAttributes();
        HashSet<String> excludeAttr = includedClass.getExcludeAttr();
        HashSet<String> includeAttr = includedClass.getIncludeAttr();
        ObjectType objectType = new ObjectType();
        objectType.setType(includedClass.getName());
        List<Attribute> attributes = objectType.getAttributes();
        for (int j = 0; j < propertyNames.length; ++j) {
            if (hasAttributes) {
                if (!includeAttr.isEmpty() && includeAttr.contains(propertyNames[j])) {
                    Utils.addAttribute(clasz, attributes, propertyNames[j]);
                    continue;
                }
                if (excludeAttr.isEmpty() || excludeAttr.contains(propertyNames[j])) continue;
                Utils.addAttribute(clasz, attributes, propertyNames[j]);
                continue;
            }
            Utils.addAttribute(clasz, attributes, propertyNames[j]);
        }
        return objectType;
    }

    private static void addAttribute(Class clasz, List<Attribute> attributes, String propertyName) {
        Method setter = Utils.getSetter(clasz, propertyName);
        if (setter != null && Modifier.isPublic(setter.getModifiers())) {
            log.debug("property " + propertyName + " added", new Object[0]);
            Attribute attribute = new Attribute();
            attribute.setName(propertyName);
            attributes.add(attribute);
        } else {
            log.debug("property " + propertyName + " excluded (setter is not public)", new Object[0]);
        }
    }

    public static Method getSetter(Class clazz, String property) {
        String setterName = Utils.getSetterName(property);
        for (Method method : clazz.getMethods()) {
            if (!method.getName().equals(setterName)) continue;
            return method;
        }
        return null;
    }

    private static String getSetterName(String property) {
        return "set" + Character.toUpperCase(property.charAt(0)) + property.substring(1);
    }

    private static XStream createXStream() {
        XStream xStream = new XStream((HierarchicalStreamDriver)new DomDriver());
        xStream.alias("export-definition", ExportDefinition.class);
        xStream.alias("include-class", IncludeClass.class);
        xStream.alias("exclude-attr", String.class);
        xStream.alias("include-attr", String.class);
        xStream.registerConverter((Converter)new ExportDefinitionConverter());
        return xStream;
    }

    private static ExportDefinition unmarshall(File xmlFile) throws FileNotFoundException {
        XStream xStream = Utils.createXStream();
        return (ExportDefinition)xStream.fromXML((Reader)new FileReader(xmlFile));
    }

    private static ExportDefinition unmarshall(InputStream input) throws FileNotFoundException {
        XStream xStream = Utils.createXStream();
        return (ExportDefinition)xStream.fromXML(input);
    }

    public static ExportDefinition[] getExportDefinitions() throws IOException {
        log.info("Preparing...", new Object[0]);
        log.info("TASK:Preparing...", new Object[0]);
        StringBuffer path = new StringBuffer();
        path.append(System.getenv("SERVER_DEPLOY_PATH")).append(File.separator).append(System.getenv("PLUGIN_PATH"));
        List modules = PluginScanner.scanFolderForJaredTextResources((String)path.toString(), (String)EXPORTDEF_FILE);
        ExportDefinition[] results = new ExportDefinition[modules.size()];
        int i = 1;
        for (String module : modules) {
            ExportDefinition expDef = Utils.unmarshall(new ByteArrayInputStream(module.getBytes()));
            log.info("PROG:" + Utils.progress(i, results.length), new Object[0]);
            if ("core".equalsIgnoreCase(expDef.getModule())) {
                results[0] = expDef;
                continue;
            }
            results[i++] = expDef;
        }
        return results;
    }

    public static Map<String, List<Object>> getTransformations(String path) {
        log.info("PROG:0", new Object[0]);
        HashMap<String, List<Object>> map = new HashMap<String, List<Object>>();
        try {
            File[] files = new File(path).listFiles();
            if (files != null) {
                int count = 0;
                for (File file : files) {
                    if (file.isFile() && file.getName().toLowerCase().endsWith("jar")) {
                        JarResources jarResources = new JarResources(file.getAbsolutePath());
                        byte[] config = jarResources.getResource(EXPORTDEF_FILE);
                        if (config != null) {
                            ExportDefinition expDef = Utils.unmarshall(new ByteArrayInputStream(config));
                            byte[] transf = jarResources.getResource(TRANSFORM_FILE);
                            if (transf != null) {
                                ArrayList<Object> list = new ArrayList<Object>(2);
                                list.add(expDef.getVersion());
                                list.add(transf);
                                map.put(expDef.getModule(), list);
                            }
                        }
                    } else if (file.isDirectory()) {
                        // empty if block
                    }
                    log.info("PROG:" + Utils.progress(++count, files.length), new Object[0]);
                }
            }
        }
        catch (Exception e) {
            log.error("", e);
            throw new RuntimeException(e);
        }
        return map;
    }

    public static int progress(int count, int size) {
        return (int)((float)count / (float)size * 100.0f);
    }

    public static Connection getDBConnection() throws Exception {
        Properties props = Utils.loadProperties();
        log.info("Aquire a connection to the database", new Object[0]);
        String driver = props.getProperty("hibernate.connection.driver_class");
        String url = props.getProperty("hibernate.connection.url");
        String userName = props.getProperty("hibernate.connection.username");
        String passwd = props.getProperty("hibernate.connection.password");
        log.info("Making a test connection using hibernate.properties", new Object[0]);
        Class.forName(driver);
        Connection con = DriverManager.getConnection(url, userName, passwd);
        log.info("Connection to database succesfull", new Object[0]);
        return con;
    }

    private static Properties loadProperties() throws Exception {
        log.info("Load hibernate.properties ...", new Object[0]);
        Properties props = new Properties();
        try {
            Properties temp = new Properties();
            StringBuffer path = new StringBuffer();
            path.append(System.getenv("SERVER_DEPLOY_PATH")).append(File.separator).append("hibernate.properties");
            temp.load(new FileInputStream(path.toString()));
            props.setProperty("hibernate.dialect", temp.getProperty("hibernate.dialect"));
            path = new StringBuffer();
            path.append(System.getenv("OWARE_USER_ROOT")).append(File.separator);
            path.append("oware").append(File.separator);
            path.append("jboss-3.2.3").append(File.separator);
            path.append("server").append(File.separator);
            path.append("oware").append(File.separator);
            path.append("deploy").append(File.separator).append("alvaristar-ds.xml");
            DatasourceParser parser = new DatasourceParser(new FileInputStream(path.toString()));
            Datasources result = parser.parseDatasource();
            props.setProperty("hibernate.connection.driver_class", result.getDriverClass());
            props.setProperty("hibernate.connection.url", result.getConnectionUrl());
            props.setProperty("hibernate.connection.username", result.getUserName());
            props.setProperty("hibernate.connection.password", result.getPassword());
            props.setProperty("hibernate.c3p0.min_size", result.getMinPoolSize());
            props.setProperty("hibernate.c3p0.max_size", result.getMaxPoolSize());
            props.setProperty("hibernate.c3p0.timeout", result.getIdleTimeoutMinutes());
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        return props;
    }
}

