/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import java.io.FileInputStream;
import java.io.PrintStream;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Properties;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class TrivialLogger {
    private static TrivialLogger logger = null;
    private static final char BLANK = ' ';
    private static final PrintStream DFLT_OUTPUT = System.out;
    private static final LEVEL DFLT_LEVEL = LEVEL.INFO;
    private static final SimpleDateFormat DFLT_DATEFORMAT = new SimpleDateFormat("HH:mm:ss.SSS");
    private PrintStream output = null;
    private SimpleDateFormat dateFormat = null;
    private LEVEL level = null;

    private TrivialLogger() {
        try {
            Properties properties = new Properties();
            properties.load(new FileInputStream("tLog.properties"));
            String targetName = properties.getProperty("tLog.output.target", "stdout").toUpperCase();
            this.output = TARGET.valueOf(targetName).outputStream(properties.getProperty("tLog.output.target.file", "tlog.log"));
            if (this.output == null) {
                this.output = DFLT_OUTPUT;
            }
            String levelName = properties.getProperty("tLog.level", "INFO").toUpperCase();
            this.level = LEVEL.valueOf(levelName);
            if (this.level == null) {
                this.level = DFLT_LEVEL;
            }
            String format = properties.getProperty("tLog.dateformat", "HH:mm:ss.SSS");
            this.dateFormat = new SimpleDateFormat(format);
            if (this.dateFormat == null) {
                this.dateFormat = DFLT_DATEFORMAT;
            }
        }
        catch (Throwable t) {
            this.output = DFLT_OUTPUT;
            this.level = DFLT_LEVEL;
            this.dateFormat = DFLT_DATEFORMAT;
        }
    }

    public static final TrivialLogger getLogger() {
        if (logger == null) {
            logger = new TrivialLogger();
        }
        return logger;
    }

    public static final TrivialLogger getLogger(Class<?> clazz) {
        return TrivialLogger.getLogger();
    }

    public boolean isDebugEnabled() {
        return this.checkLevel(LEVEL.DEBUG);
    }

    public void debug(String message, Object ... args) {
        if (this.checkLevel(LEVEL.DEBUG)) {
            this.output.println(this.format(LEVEL.DEBUG, message, new Object[0]));
        }
    }

    public void info(String message, Object ... args) {
        if (this.checkLevel(LEVEL.INFO)) {
            this.output.println(this.format(LEVEL.INFO, message, args));
        }
    }

    public void warn(String message, Object ... args) {
        if (this.checkLevel(LEVEL.WARN)) {
            this.output.println(this.format(LEVEL.WARN, message, new Object[0]));
        }
    }

    public void error(String message, Object ... args) {
        if (this.checkLevel(LEVEL.ERROR)) {
            this.output.println(this.format(LEVEL.ERROR, message, new Object[0]));
        }
    }

    private String format(LEVEL level, String message, Object ... args) {
        StringBuffer buffer = new StringBuffer();
        buffer.append(this.dateFormat.format(new Date())).append(' ').append(level.name()).append(' ');
        if (args != null && args.length > 0) {
            buffer.append(String.format(message, args));
        } else {
            buffer.append(message);
        }
        return buffer.toString();
    }

    private boolean checkLevel(LEVEL level) {
        return level.compareTo(this.level) >= 0;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static enum TARGET {
        STDOUT{

            public PrintStream outputStream(String fileName) {
                return System.out;
            }
        }
        ,
        STDERR{

            public PrintStream outputStream(String fileName) {
                return System.err;
            }
        }
        ,
        FILE{

            public PrintStream outputStream(String fileName) throws Exception {
                return new PrintStream(fileName);
            }
        };


        public abstract PrintStream outputStream(String var1) throws Exception;
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum LEVEL {
        DEBUG(0),
        INFO(1),
        WARN(2),
        ERROR(3);

        private int level;

        private LEVEL(int level) {
            this.level = level;
        }

        public int level() {
            return this.level;
        }
    }
}

