/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.setup.migration.AbstractExporter;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.Utils;
import com.dorado.common.utility.OWAttributeValuePair;
import com.dorado.common.utility.OWUTF8Util;
import com.dorado.common.utility.OWXMLConversionUtils;
import com.dorado.core.bom.IOWBOMClient;
import com.dorado.core.bom.IOWBOMInternalUseMarker;
import com.dorado.core.bom.OWBOMFatClient;
import com.dorado.core.bom.OWBOMQuery;
import com.dorado.core.bom.OWBOMQueryAllByClass;
import com.dorado.core.security.OWPermission;
import com.dorado.core.security.OWPermissionCollection;
import com.dorado.core.security.OWPermissionUtility;
import com.dorado.oware.core.usermanagement.OWRole;
import com.dorado.oware.core.usermanagement.OWUser;
import com.dorado.oware.security.OWSecurityPolicy;
import com.dorado.runtime.OWBaseHashtable;
import com.dorado.runtime.OWBaseVector;
import com.dorado.runtime.OWBean;
import com.dorado.runtime.OWBeanUserAttributes;
import com.dorado.runtime.OWBoolean;
import com.dorado.runtime.OWDouble;
import com.dorado.runtime.OWFloat;
import com.dorado.runtime.OWHashtable;
import com.dorado.runtime.OWInteger;
import com.dorado.runtime.OWLong;
import com.dorado.runtime.OWNotImplementedException;
import com.dorado.runtime.OWObject;
import com.dorado.runtime.OWObjectToBase64Serializer;
import com.dorado.runtime.OWSet;
import com.dorado.runtime.OWString;
import com.dorado.runtime.OWVector;
import com.dorado.runtime.OWXMLizer;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.annotations.AnnotationReflectionConverter;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.ConverterLookup;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OwareExporter
extends AbstractExporter
implements IOWBOMInternalUseMarker {
    private static final TrivialLogger log = TrivialLogger.getLogger();
    IOWBOMClient bomAPI = new OWBOMFatClient((IOWBOMInternalUseMarker)this, true);
    HierarchicalStreamDriver driver = new DomDriver();
    XStream xStream = new XStream(this.driver);
    private static List<String> builtinRoles = new ArrayList<String>();
    private static List<String> builtinUsers = new ArrayList<String>();

    public OwareExporter(String outputFile) throws Exception {
        super(outputFile);
        this.xStream.registerConverter((Converter)new OWUserConverter());
        this.xStream.registerConverter((Converter)new OWSecurityPolicyConverter());
    }

    @Override
    public boolean doExport() throws Exception {
        log.info("[export] - start", new Object[0]);
        this.exportMetaInf();
        this.exportData(OWRole.class, "db/seedroles.xml");
        this.exportData(OWUser.class, "db/seedusers.xml");
        this.exportData(OWSecurityPolicy.class, "db/seedperms.xml");
        this.zip.close();
        log.info("[export] - end", new Object[0]);
        return true;
    }

    private void exportMetaInf() throws IOException {
        log.info("Preparing...", new Object[0]);
        log.info("TASK:Preparing...", new Object[0]);
        this.exportManifest();
        this.exportOcpInstall();
    }

    private void exportManifest() throws IOException {
        ZipEntry backup = new ZipEntry("META-INF/MANIFEST.MF");
        backup.setMethod(8);
        this.zip.putNextEntry(backup);
        PrintStream output = new PrintStream(this.zip);
        output.println("Manifest-Version: 1.0");
        output.println("Ant-Version: Apache Ant 1.5.2");
        output.println("Created-By: (A* v3.x Data Migration Tool)");
        output.println("Content-Version: ");
        output.println("User-Directory: ");
        output.println("Install-Path: META-INF/ocp.install");
        output.flush();
        this.zip.closeEntry();
        log.info("PROG:10", new Object[0]);
    }

    private void exportOcpInstall() throws IOException {
        ZipEntry backup = new ZipEntry("META-INF/ocp.install");
        backup.setMethod(8);
        this.zip.putNextEntry(backup);
        PrintStream output = new PrintStream(this.zip);
        ConverterLookup converters = this.xStream.getConverterLookup();
        HierarchicalStreamWriter writer = this.driver.createWriter((OutputStream)output);
        output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        writer.startNode("device-driver");
        writer.startNode("install");
        output.println("<!-- Roles -->");
        writer.startNode("import");
        writer.startNode("file");
        writer.setValue("db/seedroles.xml");
        writer.endNode();
        Converter converter = converters.lookupConverterForType(OWRole.class);
        if (converter instanceof AnnotationReflectionConverter) {
            writer.startNode("dbms");
            writer.setValue("owbusdb");
            writer.endNode();
            writer.startNode("importer");
            writer.setValue("SOAP_IMPORTER");
            writer.endNode();
        } else {
            log.warn("OWRole table won't be exported!", new Object[0]);
        }
        writer.endNode();
        log.info("PROG:40", new Object[0]);
        output.println("<!-- Users -->");
        writer.startNode("import");
        writer.startNode("file");
        writer.setValue("db/seedusers.xml");
        writer.endNode();
        converter = converters.lookupConverterForType(OWUser.class);
        if (converter instanceof AnnotationReflectionConverter) {
            writer.startNode("dbms");
            writer.setValue("owbusdb");
            writer.endNode();
            writer.startNode("importer");
            writer.setValue("SOAP_IMPORTER");
            writer.endNode();
        } else if (converter instanceof OWUserConverter) {
            writer.startNode("importer");
            writer.setValue("redcell.core.usersys.RCUserHandler2");
            writer.endNode();
        }
        writer.endNode();
        log.info("PROG:65", new Object[0]);
        output.println("<!-- Permissions  -->");
        writer.startNode("import");
        writer.startNode("file");
        writer.setValue("db/seedperms.xml");
        writer.endNode();
        converter = converters.lookupConverterForType(OWSecurityPolicy.class);
        if (converter instanceof AnnotationReflectionConverter) {
            writer.startNode("dbms");
            writer.setValue("owbusdb");
            writer.endNode();
            writer.startNode("importer");
            writer.setValue("SOAP_IMPORTER");
            writer.endNode();
        } else if (converter instanceof OWSecurityPolicyConverter) {
            writer.startNode("importer");
            writer.setValue("redcell.core.usersys.RCFunctionHandler");
            writer.endNode();
        }
        writer.endNode();
        log.info("PROG:90", new Object[0]);
        writer.endNode();
        writer.endNode();
        writer.flush();
        this.zip.closeEntry();
        log.info("PROG:100", new Object[0]);
    }

    private void exportData(Class<?> clazz, String entryName) throws Exception {
        log.info("Exporting ... %s", clazz.getName());
        log.info("TASK:Exporting... " + clazz.getSimpleName(), new Object[0]);
        OWBOMQueryAllByClass qbc = new OWBOMQueryAllByClass(clazz.getCanonicalName(), false);
        Collection objects = (Collection)this.bomAPI.getObjects((OWBOMQuery)qbc).getReturnObject();
        int size = objects.size();
        int count = 0;
        int progress = 0;
        ZipEntry zipEntry = new ZipEntry(entryName);
        zipEntry.setMethod(8);
        this.zip.putNextEntry(zipEntry);
        PrintStream output = new PrintStream(this.zip);
        output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        ConverterLookup converters = this.xStream.getConverterLookup();
        if (converters.lookupConverterForType(clazz) instanceof AnnotationReflectionConverter) {
            for (OWBean bean : objects) {
                ++count;
                if (!this.canExport(bean)) continue;
                output.println(bean.toXML());
                StringBuffer buf = new StringBuffer("Exporting ");
                buf.append(bean.getClass().getSimpleName());
                buf.append("\n\tKEY :\t").append(bean.getKEY());
                OWBeanUserAttributes userAttrs = bean.getUserAttributes((IOWBOMInternalUseMarker)this);
                for (OWAttributeValuePair attr : userAttrs.values()) {
                    buf.append("\n\t").append(attr.getAttributeName());
                    buf.append(" :\t").append(attr.getNewValue());
                }
                log.info("\towoid: " + bean.getHandle().getOID(), new Object[0]);
                progress = Utils.progress(count, size);
                log.info("PROG:" + progress, new Object[0]);
            }
            if (progress < 100) {
                log.info("PROG:" + Utils.progress(count, size), new Object[0]);
            }
        } else if (OWUser.class.equals(clazz)) {
            HierarchicalStreamWriter writer = this.driver.createWriter((OutputStream)output);
            this.xStream.alias("RCUser", clazz);
            writer.startNode("OWUsers");
            writer.startNode("XMLConfig");
            writer.addAttribute("handlerClassName", "redcell.core.usersys.RCUserHandler2");
            writer.addAttribute("instanceClass", "com.dorado.oware.core.usermanagement.OWUser");
            writer.endNode();
            for (OWBean bean : objects) {
                ++count;
                if (!this.canExport(bean)) continue;
                this.xStream.marshal((Object)bean, writer);
                log.info("\towoid: " + bean.getHandle().getOID(), new Object[0]);
                progress = Utils.progress(count, size);
                log.info("PROG:" + progress, new Object[0]);
            }
            if (progress < 100) {
                log.info("PROG:" + Utils.progress(count, size), new Object[0]);
            }
            writer.endNode();
        } else if (OWSecurityPolicy.class.equals(clazz)) {
            HierarchicalStreamWriter writer = this.driver.createWriter((OutputStream)output);
            this.xStream.alias("OWPolicyInstance", clazz);
            writer.startNode("OWPolicy");
            writer.startNode("XMLConfig");
            writer.addAttribute("handlerClassName", "redcell.core.usersys.RCFunctionHandler");
            writer.addAttribute("instanceClass", "com.dorado.oware.security.OWSecurityPolicy");
            writer.endNode();
            for (OWBean bean : objects) {
                ++count;
                if (!this.canExport(bean)) continue;
                this.xStream.marshal((Object)bean, writer);
                log.info("\towoid: " + bean.getHandle().getOID(), new Object[0]);
                progress = Utils.progress(count, size);
                log.info("PROG:" + progress, new Object[0]);
            }
            if (progress < 100) {
                log.info("PROG:" + Utils.progress(count, size), new Object[0]);
            }
            writer.endNode();
        }
    }

    private boolean canExport(OWBean bean) {
        Class<?> clazz = bean.getClass();
        if (OWRole.class.isAssignableFrom(clazz)) {
            return !builtinRoles.contains(((OWRole)bean).getRoleId());
        }
        if (OWUser.class.isAssignableFrom(clazz)) {
            return !builtinUsers.contains(((OWUser)bean).getUserId());
        }
        return true;
    }

    private static class OWSecurityPolicyConverter
    implements Converter {
        final boolean verbose = false;

        private OWSecurityPolicyConverter() {
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            OWSecurityPolicy policy = (OWSecurityPolicy)value;
            StringBuffer buf = new StringBuffer("Exporting Security Policy");
            writer.addAttribute("instanceID", policy.getKEY());
            writer.addAttribute("displayName", policy.getDisplayName());
            buf.append("\n\tinstanceID :\t").append(policy.getKEY());
            buf.append("\n\tdisplayName :\t").append(policy.getDisplayName());
            writer.startNode("OWPermissionCollection");
            OWPermissionCollection perms = (OWPermissionCollection)policy.getPermCollection();
            if (perms != null) {
                Enumeration en = perms.elements();
                while (en.hasMoreElements()) {
                    OWPermission perm = (OWPermission)en.nextElement();
                    buf.append("\n\tpermission :");
                    writer.startNode("OWPermission");
                    writer.addAttribute("principal", perm.getName());
                    writer.addAttribute("actions", perm.getActions());
                    writer.addAttribute("roleFlag", perm.getRoleFlag() ? "True" : "False");
                    writer.addAttribute("target", perm.getTarget());
                    writer.endNode();
                    buf.append("\n\t\tprincipal :\t").append(perm.getName());
                    buf.append("\n\t\tactions :\t").append(perm.getActions());
                }
            }
            writer.endNode();
            String actionString = OWPermissionUtility.getActions((int)policy.getAvailableActionsMask());
            for (String action : actionString.split(",")) {
                writer.startNode("Actions");
                writer.addAttribute("actionString", action);
                writer.endNode();
            }
            buf.append("\n\tactions :\t").append(actionString);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
        }

        public boolean canConvert(Class clazz) {
            return OWSecurityPolicy.class.isAssignableFrom(clazz);
        }
    }

    private static class OWUserConverter
    implements Converter {
        final boolean verbose = false;

        private OWUserConverter() {
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            OWUser user = (OWUser)value;
            StringBuffer buf = new StringBuffer("Exporting User");
            writer.addAttribute("firstName", user.getFirstName());
            writer.addAttribute("lastName", user.getLastName());
            writer.addAttribute("userId", user.getUserId());
            buf.append("\n\tuserId :\t").append(user.getUserId());
            buf.append("\n\tfirstName :\t").append(user.getFirstName());
            buf.append("\n\tlastName :\t").append(user.getLastName());
            this.writeUserAttribute("password", user.getPassword(), writer);
            buf.append("\n\tpassword :\t").append(user.getPassword());
            OWVector roles = user.getRoles();
            if (roles != null) {
                buf.append("\n\tgroups :\t");
                for (int i = 0; i < roles.size(); ++i) {
                    OWRole role = (OWRole)roles.get(i);
                    if (role == null) continue;
                    this.writeUserAttribute("group", role.getRoleId(), writer);
                    buf.append(role.getRoleId()).append(",");
                }
            }
            this.writeUserAttribute("enabled", "true", writer);
            this.writeUserAttribute("icon", "RedCell.Images.Contact.Contact", writer);
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
        }

        public boolean canConvert(Class clazz) {
            return OWUser.class.isAssignableFrom(clazz);
        }

        private void writeUserAttribute(String name, String value, HierarchicalStreamWriter writer) {
            writer.startNode("UserAttrib");
            writer.addAttribute("name", name);
            writer.addAttribute("value", value);
            writer.endNode();
        }
    }

    private static class OWBeanSOAPConverter
    implements Converter,
    IOWBOMInternalUseMarker {
        static Map<Class<?>, String> marshallTypeMap = new HashMap();
        final boolean verbose = false;

        private OWBeanSOAPConverter() {
        }

        public void marshal(Object value, HierarchicalStreamWriter writer, MarshallingContext context) {
            OWBean bean = (OWBean)value;
            Class<?> clazz = bean.getClass();
            StringBuffer buf = new StringBuffer("Exporting " + clazz.getSimpleName());
            writer.addAttribute("xsi:id", bean.getXMLID() == null ? "1" : bean.getXMLID());
            writer.addAttribute("xmlns:xsi", "http://www.w3.org/1999/XMLSchema-instance");
            writer.startNode("class");
            writer.setValue(bean.getClass().getCanonicalName());
            writer.endNode();
            writer.startNode("BPAttributes");
            writer.startNode("OW_KEY");
            try {
                writer.setValue(bean.getKEY());
                buf.append("\n\tKEY :\t").append(bean.getKEY());
            }
            catch (OWNotImplementedException e) {
                e.printStackTrace();
            }
            writer.endNode();
            writer.endNode();
            writer.startNode(clazz.getCanonicalName() + ".Attributes");
            OWBeanUserAttributes userAttrs = bean.getUserAttributes((IOWBOMInternalUseMarker)this);
            for (OWAttributeValuePair attr : userAttrs.values()) {
                writer.startNode(attr.getAttributeName());
                Object val = attr.getNewValue();
                if (val instanceof OWObject) {
                    OWObject owObj = (OWObject)val;
                    writer.startNode("class");
                    writer.setValue("ObjectWrapper");
                    writer.endNode();
                    writer.startNode("compressed");
                    writer.addAttribute("xsi:type", "xsd:boolean");
                    writer.setValue(owObj.isCompressed() ? "true" : "false");
                    writer.endNode();
                    writer.startNode("isByteArray");
                    writer.addAttribute("xsi:type", "xsd:boolean");
                    writer.setValue(owObj.isByteArrayType() ? "true" : "false");
                    writer.endNode();
                }
                writer.startNode("value");
                if (val != null) {
                    try {
                        Class<?> type = val.getClass();
                        String mappedType = marshallTypeMap.get(type);
                        if (mappedType != null) {
                            if (val instanceof OWObject) {
                                writer.addAttribute("xsi:type", "SOAP-ENC:base64");
                                writer.setValue(OWXMLConversionUtils.escapeDelimiters((String)OWObjectToBase64Serializer.getStringFromObject((Object)val)));
                            } else if (!(val instanceof OWSet || val instanceof OWVector || val instanceof OWHashtable || val instanceof OWBaseVector || val instanceof OWBaseHashtable)) {
                                writer.addAttribute("xsi:type", mappedType);
                                String str = val.toString();
                                if (val instanceof Date) {
                                    str = OWXMLizer.getDateString((Date)((Date)val));
                                }
                                writer.setValue(OWUTF8Util.convertNativeToUTF8((String)str));
                            }
                        } else {
                            writer.addAttribute("xsi:type", "SOAP-ENC:base64");
                            if (val instanceof Serializable) {
                                writer.setValue(OWXMLConversionUtils.escapeDelimiters((String)OWObjectToBase64Serializer.getStringFromObject((Object)val)));
                            }
                        }
                    }
                    catch (Exception e) {
                        // empty catch block
                    }
                }
                writer.endNode();
                writer.endNode();
                buf.append("\n\t").append(attr.getAttributeName());
                buf.append(" :\t").append(attr.getNewValue());
            }
            writer.endNode();
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            throw new UnsupportedOperationException("NOT IMPLEMENTED YET");
        }

        public boolean canConvert(Class clazz) {
            return OWBean.class.isAssignableFrom(clazz);
        }

        static {
            marshallTypeMap.put(OWString.class, "xsd:string");
            marshallTypeMap.put(OWDouble.class, "xsd:double");
            marshallTypeMap.put(OWInteger.class, "xsd:integer");
            marshallTypeMap.put(OWFloat.class, "xsd:float");
            marshallTypeMap.put(OWBoolean.class, "xsd:boolean");
            marshallTypeMap.put(OWLong.class, "xsd:long");
            marshallTypeMap.put(OWSet.class, "Set");
            marshallTypeMap.put(OWVector.class, "List");
            marshallTypeMap.put(OWHashtable.class, "Dictionary");
            marshallTypeMap.put(OWBaseVector.class, "BaseList");
            marshallTypeMap.put(OWBaseHashtable.class, "BaseDictionary");
            marshallTypeMap.put(OWObject.class, "ObjectWrapper");
            marshallTypeMap.put(String.class, "xsd:string");
            marshallTypeMap.put(Double.class, "xsd:double");
            marshallTypeMap.put(Integer.class, "xsd:integer");
            marshallTypeMap.put(Float.class, "xsd:float");
            marshallTypeMap.put(Boolean.class, "xsd:boolean");
            marshallTypeMap.put(Long.class, "xsd:long");
            marshallTypeMap.put(Date.class, "xsd:date");
        }
    }
}

