/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.setup.migration.AbstractImporter;
import com.bwanms.setup.migration.HibernateUtil;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.Utils;
import com.bwanms.setup.migration.backup.Configuration;
import com.bwanms.setup.migration.backup.Partition;
import com.bwanms.setup.migration.backup.PartitionConverter;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.xml.StaxDriver;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stream.StreamResult;
import javax.xml.transform.stream.StreamSource;
import org.hibernate.Session;
import org.hibernate.Transaction;

public class NMSImporter
extends AbstractImporter {
    public static final TrivialLogger log = TrivialLogger.getLogger(NMSImporter.class);
    private HierarchicalStreamDriver driver;
    private String inputFile = null;
    private String workingDir = null;
    private InputStream input = null;

    public NMSImporter(String inputFile) throws Exception {
        super(inputFile);
        this.inputFile = inputFile;
        int idx = inputFile.lastIndexOf(File.separator);
        this.workingDir = idx < 0 ? System.getProperty("user.dir") : inputFile.substring(0, idx);
        this.driver = new StaxDriver();
    }

    public boolean doImport() throws Exception {
        log.info("Preparing...", new Object[0]);
        log.info("TASK:Preparing...", new Object[0]);
        Transaction tx = null;
        Session session = null;
        try {
            session = HibernateUtil.currentSession();
            XStream xStream = new XStream(this.driver);
            xStream.registerConverter((Converter)new PartitionConverter(session));
            xStream.alias("configuration", Configuration.class);
            xStream.alias("partition", Partition.class);
            xStream.useAttributeFor("version", String.class);
            xStream.useAttributeFor("date", Date.class);
            xStream.addImplicitCollection(Configuration.class, "partitions", Partition.class);
            if (!this.doTransform()) {
                boolean bl = false;
                return bl;
            }
            tx = session.beginTransaction();
            Configuration config = (Configuration)xStream.fromXML(this.input);
            log.debug("partitions " + config.getPartitions().size(), new Object[0]);
            tx.commit();
        }
        catch (Exception e) {
            if (tx != null) {
                tx.rollback();
            }
            throw e;
        }
        finally {
            if (session != null) {
                session.close();
            }
        }
        return true;
    }

    private boolean doTransform() throws Exception {
        HierarchicalStreamReader reader;
        String filename = null;
        LinkedList<String[]> partitions = new LinkedList<String[]>();
        ZipInputStream localZip = new ZipInputStream(new FileInputStream(this.inputFile));
        ZipEntry zipEntry = localZip.getNextEntry();
        if (zipEntry != null && "META-INF/meta-inf.xml".equalsIgnoreCase(zipEntry.getName()) && "configuration".equalsIgnoreCase((reader = this.driver.createReader((InputStream)localZip)).getNodeName())) {
            filename = reader.getAttribute("file");
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                if ("partition".equalsIgnoreCase(reader.getNodeName())) {
                    partitions.add(new String[]{reader.getAttribute("module"), reader.getAttribute("version")});
                }
                reader.moveUp();
            }
        }
        zipEntry = this.zip.getNextEntry();
        while (zipEntry != null && !filename.equalsIgnoreCase(zipEntry.getName())) {
            zipEntry = this.zip.getNextEntry();
        }
        if (zipEntry != null) {
            StringBuilder path = new StringBuilder();
            path.append(System.getenv("SERVER_DEPLOY_PATH")).append(File.separator).append(System.getenv("PLUGIN_PATH"));
            Map<String, List<Object>> transfMap = Utils.getTransformations(path.toString());
            log.info("Applying transformations...", new Object[0]);
            log.info("TASK:Applying transformations...", new Object[0]);
            int totalTransf = 0;
            for (String[] part : partitions) {
                String module = part[0];
                int currVersion = Integer.parseInt(part[1]);
                int finalVersion = Integer.parseInt((String)transfMap.get(module).get(0));
                totalTransf = finalVersion - currVersion;
            }
            if (totalTransf > 0) {
                int transfCount = 0;
                TransformerFactory transFact = TransformerFactory.newInstance();
                StreamSource xmlSource = new StreamSource(this.zip);
                log.info("PROG:0", new Object[0]);
                for (String[] part : partitions) {
                    String module = part[0];
                    List<Object> transfData = transfMap.get(module);
                    int finalVersion = Integer.parseInt((String)transfData.get(0));
                    StreamSource xslSource = new StreamSource(new ByteArrayInputStream((byte[])transfData.get(1)));
                    Transformer trans = transFact.newTransformer(xslSource);
                    trans.setOutputProperty("method", "xml");
                    trans.setOutputProperty("indent", "yes");
                    String resultFile = null;
                    for (int currVersion = Integer.parseInt(part[1]); currVersion < finalVersion; ++currVersion) {
                        File file;
                        int nextVersion = currVersion + 1;
                        trans.setParameter("currVersion", currVersion);
                        if (resultFile != null && (file = new File(resultFile)) != null && file.isFile()) {
                            file.delete();
                        }
                        resultFile = String.format("%s%stransf-%s-v%dv%d.xml", this.workingDir, File.separator, module, currVersion, nextVersion);
                        StreamResult xmlResult = new StreamResult(new FileOutputStream(resultFile));
                        log.info(String.format("Transform module[%s] : v%d -> v%d", module, currVersion, nextVersion), new Object[0]);
                        trans.transform(xmlSource, xmlResult);
                        log.info("PROG:" + Utils.progress(++transfCount, totalTransf), new Object[0]);
                        xmlSource = new StreamSource(new FileInputStream(resultFile));
                        this.inputFile = resultFile;
                    }
                }
                this.input = new FileInputStream(this.inputFile);
            } else {
                this.input = this.zip;
            }
            return true;
        }
        return false;
    }
}

