/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.setup.migration.AbstractExporter;
import com.bwanms.setup.migration.ExportException;
import com.bwanms.setup.migration.HibernateUtil;
import com.bwanms.setup.migration.TrivialLogger;
import com.bwanms.setup.migration.Utils;
import com.bwanms.setup.migration.backup.Configuration;
import com.bwanms.setup.migration.backup.ObjectType;
import com.bwanms.setup.migration.backup.Partition;
import com.bwanms.setup.migration.backup.PartitionConverter;
import com.bwanms.setup.migration.config.ExportDefinition;
import com.bwanms.setup.migration.config.IncludeClass;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;

public class NMSExporter
extends AbstractExporter {
    private static final TrivialLogger log = TrivialLogger.getLogger(NMSExporter.class);

    public NMSExporter(String outputFile) throws Exception {
        super(outputFile);
    }

    public boolean doExport() throws Exception {
        Date configurationDate = new Date();
        String configurationVersion = "1";
        try {
            DomDriver driver = new DomDriver();
            XStream xStream = new XStream((HierarchicalStreamDriver)driver);
            xStream.registerConverter((Converter)new PartitionConverter(HibernateUtil.currentSession()));
            xStream.alias("configuration", Configuration.class);
            xStream.alias("partition", Partition.class);
            xStream.useAttributeFor("version", String.class);
            xStream.useAttributeFor("date", Date.class);
            xStream.addImplicitCollection(Configuration.class, "partitions", Partition.class);
            ExportDefinition[] exportDefinitions = Utils.getExportDefinitions();
            Configuration configuration = new Configuration();
            configuration.setDate(configurationDate);
            configuration.setVersion("1");
            List<Partition> partitions = configuration.getPartitions();
            for (int i = 0; i < exportDefinitions.length; ++i) {
                ExportDefinition ed = exportDefinitions[i];
                Partition partition = new Partition();
                partition.setModule(ed.getModule());
                partition.setVersion(ed.getVersion());
                log.debug("parsing configuration for module " + ed.getModule(), new Object[0]);
                List<IncludeClass> listIncludedClasses = ed.getIncludeClass();
                Map<String, ObjectType> objects = partition.getObjects();
                for (IncludeClass includedClass : listIncludedClasses) {
                    log.debug("include class " + includedClass.getName(), new Object[0]);
                    ObjectType objectType = Utils.createObjectType(includedClass);
                    objects.put(objectType.getType(), objectType);
                }
                partitions.add(partition);
            }
            PrintStream infoOut = this.createOutputStream("META-INF/meta-inf.xml");
            HierarchicalStreamWriter writer = driver.createWriter((OutputStream)infoOut);
            writer.startNode("configuration");
            writer.addAttribute("file", "backup.xml");
            for (Partition partition : partitions) {
                writer.startNode("partition");
                writer.addAttribute("module", partition.getModule());
                writer.addAttribute("version", partition.getVersion());
                writer.endNode();
            }
            writer.endNode();
            infoOut.flush();
            PrintStream backupOut = this.createOutputStream("backup.xml");
            xStream.toXML((Object)configuration, (OutputStream)backupOut);
            backupOut.flush();
            backupOut.close();
        }
        catch (IOException e) {
            e.printStackTrace();
            throw new ExportException(e);
        }
        return true;
    }

    private PrintStream createOutputStream(String fileName) throws IOException {
        ZipEntry backup = new ZipEntry(fileName);
        backup.setMethod(8);
        this.zip.putNextEntry(backup);
        PrintStream output = new PrintStream(this.zip);
        output.println("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n");
        return output;
    }
}

