/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.plugin.impl.PluginScanner;
import com.bwanms.setup.migration.DatasourceParser;
import com.bwanms.setup.migration.Datasources;
import com.bwanms.setup.migration.TrivialLogger;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.hibernate.metadata.ClassMetadata;
import org.w3c.dom.Document;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class HibernateUtil {
    private static final TrivialLogger log = TrivialLogger.getLogger(HibernateUtil.class);
    private static SessionFactory sessionFactory = null;
    private static ThreadLocal<Session> session = new ThreadLocal();
    private static String SERVER_DEPLOY_PATH = null;
    private static String PLUGIN_PATH;

    private HibernateUtil() {
    }

    private static SessionFactory getSessionFactory() {
        System.setProperty("com.bwanms.platform", "local");
        if (sessionFactory == null) {
            log.info("Create Hibernate Session Factory", new Object[0]);
            try {
                AnnotationConfiguration configuration = new AnnotationConfiguration();
                configuration.setProperties(HibernateUtil.loadProperties());
                DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
                Document document = builder.parse(new ByteArrayInputStream(HibernateUtil.loadMappings().getBytes()));
                sessionFactory = configuration.configure(document).buildSessionFactory();
            }
            catch (Throwable t) {
                log.error("Initial SessionFactory creation failed." + t, new Object[0]);
                throw new ExceptionInInitializerError(t);
            }
        }
        return sessionFactory;
    }

    public static Session currentSession() throws HibernateException {
        Session s = session.get();
        if (s == null) {
            s = HibernateUtil.getSessionFactory().openSession();
            session.set(s);
        }
        return s;
    }

    public static void closeSession() throws HibernateException {
        Session s = session.get();
        if (s != null) {
            s.close();
        }
        session.set(null);
    }

    public static ClassMetadata getClassMetadata(Class<?> clazz) {
        return HibernateUtil.getSessionFactory().getClassMetadata(clazz);
    }

    public static ClassMetadata getClassMetadata(String name) {
        return HibernateUtil.getSessionFactory().getClassMetadata(name);
    }

    private static Properties loadProperties() throws Exception {
        log.info("Load hibernate.properties ...", new Object[0]);
        Properties props = new Properties();
        try {
            Properties temp = new Properties();
            StringBuffer path = new StringBuffer();
            path.append(SERVER_DEPLOY_PATH).append(File.separator).append("hibernate.properties");
            temp.load(new FileInputStream(path.toString()));
            props.setProperty("hibernate.dialect", temp.getProperty("hibernate.dialect"));
            path = new StringBuffer();
            path.append(System.getenv("OWARE_USER_ROOT")).append(File.separator);
            path.append("oware").append(File.separator);
            path.append("jboss-3.2.3").append(File.separator);
            path.append("server").append(File.separator);
            path.append("oware").append(File.separator);
            path.append("deploy").append(File.separator).append("alvaristar-ds.xml");
            DatasourceParser parser = new DatasourceParser(new FileInputStream(path.toString()));
            Datasources result = parser.parseDatasource();
            props.setProperty("hibernate.connection.driver_class", result.getDriverClass());
            props.setProperty("hibernate.connection.url", result.getConnectionUrl());
            props.setProperty("hibernate.connection.username", result.getUserName());
            props.setProperty("hibernate.connection.password", result.getPassword());
            props.setProperty("hibernate.c3p0.min_size", result.getMinPoolSize());
            props.setProperty("hibernate.c3p0.max_size", result.getMaxPoolSize());
            props.setProperty("hibernate.c3p0.timeout", result.getIdleTimeoutMinutes());
        }
        catch (Throwable t) {
            throw new Exception(t);
        }
        return props;
    }

    private static String loadMappings() {
        log.info("Load hibernate-mappings.xml ...", new Object[0]);
        StringBuilder configurationXML = new StringBuilder();
        configurationXML.append("<hibernate-configuration><session-factory>\n");
        StringBuffer path = new StringBuffer();
        path.append(SERVER_DEPLOY_PATH).append(File.separator).append(PLUGIN_PATH);
        List includes = PluginScanner.scanFolderForJaredTextResources((String)path.toString(), (String)"hibernate-mappings.xml.inc");
        for (String include : includes) {
            configurationXML.append(include);
        }
        configurationXML.append("\n</session-factory></hibernate-configuration>");
        return configurationXML.toString();
    }

    static {
        try {
            SERVER_DEPLOY_PATH = System.getenv("SERVER_DEPLOY_PATH");
        }
        catch (Exception e) {
            // empty catch block
        }
        if (SERVER_DEPLOY_PATH == null) {
            SERVER_DEPLOY_PATH = System.getenv("OWARE_USER_ROOT") + "/oware/jboss-3.2.3/server/oware/deploy/bwanms.sar";
        }
        PLUGIN_PATH = null;
        try {
            PLUGIN_PATH = System.getenv("PLUGIN_PATH");
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (PLUGIN_PATH == null) {
            PLUGIN_PATH = "lib/dd";
        }
    }
}

