/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.gui.Internationalizer;
import com.bwanms.model.fault.EventTemplate;
import com.bwanms.model.fault.EventTemplateBehavior;
import com.bwanms.model.fault.EventTemplateFilter;
import com.bwanms.model.fault.EvtTmplFilterEvtOID;
import com.bwanms.setup.migration.HibernateUtil;
import java.lang.reflect.Method;
import org.hibernate.Session;
import org.hibernate.Transaction;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class DefaultTemplatesGenerator {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        if (args.length <= 0) {
            System.out.println("Usage: owlaunch com.bwanms.setup.migration.DefaultTemplatesGenerator <TrapTypeClassName>\nExample class: com.bwanms.rb.model.constants.RbTrapType");
            System.exit(1);
        }
        String className = args[0];
        try {
            Class<?> clazz = Class.forName(className);
            Internationalizer i18n = Internationalizer.getSimpleInternationalizer(clazz);
            Method m = clazz.getMethod("values", new Class[0]);
            Enum[] traps = (Enum[])m.invoke(clazz, new Object[0]);
            Transaction tx = null;
            Session session = null;
            try {
                session = HibernateUtil.currentSession();
                tx = session.beginTransaction();
                for (Enum trap : traps) {
                    EventTemplate templ = DefaultTemplatesGenerator.generateTemplate(trap, i18n);
                    if (templ == null) continue;
                    session.save((Object)templ);
                }
                tx.commit();
            }
            catch (Exception e) {
                if (tx != null) {
                    tx.rollback();
                }
                System.exit(1);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    private static EventTemplate generateTemplate(Enum<?> trap, Internationalizer i18n) {
        if ("unexpectedValue".equals(trap.name())) {
            return null;
        }
        EventTemplate templ = new EventTemplate();
        templ.setName(i18n != null ? i18n.translateString(trap.toString()) : trap.name());
        templ.setDescription("Default template");
        templ.setOwner("SYSTEM");
        templ.setPriority(Long.valueOf(1L));
        templ.setCreationDate(System.currentTimeMillis());
        EventTemplateFilter filter = new EventTemplateFilter();
        try {
            Method m = trap.getClass().getMethod("oid", new Class[0]);
            String oid = (String)m.invoke(trap, new Object[0]);
            filter.addEventOID(new EvtTmplFilterEvtOID(filter, oid));
        }
        catch (Exception e) {
            return null;
        }
        templ.setFilter(filter);
        EventTemplateBehavior behavior = new EventTemplateBehavior();
        behavior.setAckRequired(false);
        behavior.setAutoSendEmail(false);
        behavior.setAlarmSeverity((byte)-1);
        behavior.setUserClassifier("None");
        templ.setBehavior(behavior);
        return templ;
    }
}

