/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.setup.migration.Datasources;
import com.bwanms.setup.migration.TrivialLogger;
import com.thoughtworks.xstream.XStream;
import com.thoughtworks.xstream.converters.Converter;
import com.thoughtworks.xstream.converters.MarshallingContext;
import com.thoughtworks.xstream.converters.UnmarshallingContext;
import com.thoughtworks.xstream.io.HierarchicalStreamDriver;
import com.thoughtworks.xstream.io.HierarchicalStreamReader;
import com.thoughtworks.xstream.io.HierarchicalStreamWriter;
import com.thoughtworks.xstream.io.xml.DomDriver;
import java.io.IOException;
import java.io.InputStream;

public class DatasourceParser {
    private static final TrivialLogger log = TrivialLogger.getLogger(DatasourceParser.class);
    private InputStream inputStream;

    public DatasourceParser() {
    }

    public DatasourceParser(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    public InputStream getInputStream() {
        return this.inputStream;
    }

    public void setInputStream(InputStream inputStream) {
        this.inputStream = inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Datasources parseDatasource() {
        if (this.inputStream == null) {
            throw new UnsupportedOperationException("Datasource file is not setted!");
        }
        log.debug("start parsing datasource file ", new Object[0]);
        DomDriver driver = new DomDriver();
        XStream xStream = new XStream((HierarchicalStreamDriver)driver);
        xStream.alias("datasources", Datasources.class);
        xStream.registerConverter((Converter)new DatasourcesConverter());
        try {
            Datasources datasources = (Datasources)xStream.fromXML(this.inputStream);
            return datasources;
        }
        finally {
            try {
                if (this.inputStream != null) {
                    this.inputStream.close();
                }
            }
            catch (IOException e) {
                log.error("Can't close file reader on file " + this.inputStream, new Object[0]);
            }
        }
    }

    static class DatasourcesConverter
    implements Converter {
        DatasourcesConverter() {
        }

        public void marshal(Object source, HierarchicalStreamWriter writer, MarshallingContext context) {
        }

        public Object unmarshal(HierarchicalStreamReader reader, UnmarshallingContext context) {
            Datasources datasources = new Datasources();
            reader.moveDown();
            while (reader.hasMoreChildren()) {
                reader.moveDown();
                this.setProperty(datasources, reader);
                reader.moveUp();
            }
            reader.moveUp();
            return datasources;
        }

        private void setProperty(Datasources datasources, HierarchicalStreamReader reader) {
            if ("jndi-name".equals(reader.getNodeName())) {
                datasources.setJndiName(reader.getValue());
            } else if ("connection-url".equals(reader.getNodeName())) {
                datasources.setConnectionUrl(reader.getValue());
            } else if ("driver-class".equals(reader.getNodeName())) {
                datasources.setDriverClass(reader.getValue());
            } else if ("user-name".equals(reader.getNodeName())) {
                datasources.setUserName(reader.getValue());
            } else if ("password".equals(reader.getNodeName())) {
                datasources.setPassword(reader.getValue());
            } else if ("min-pool-size".equals(reader.getNodeName())) {
                datasources.setMinPoolSize(reader.getValue());
            } else if ("max-pool-size".equals(reader.getNodeName())) {
                datasources.setMaxPoolSize(reader.getValue());
            } else if ("idle-timeout-minutes".equals(reader.getNodeName())) {
                datasources.setIdleTimeoutMinutes(reader.getValue());
            }
        }

        public boolean canConvert(Class type) {
            return Datasources.class.equals((Object)type);
        }
    }
}

