/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.setup.migration;

import com.bwanms.setup.migration.AbstractExporter;
import com.bwanms.setup.migration.NMSExporter;
import com.bwanms.setup.migration.NMSImporter;
import com.bwanms.setup.migration.OwareExporter;
import com.bwanms.setup.migration.TrivialLogger;

public class DataMigrator {
    private static final TrivialLogger log = TrivialLogger.getLogger();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public static void main(String[] args) {
        boolean success = true;
        try {
            block14: {
                block13: {
                    if (args.length <= 0) throw new CmdLineException("Empty command line!");
                    if (!args[0].equals("-export")) break block13;
                    switch (args.length) {
                        case 2: {
                            System.out.println("\nDATA MIGRATOR - Export Configuration\n");
                            success = DataMigrator.exportData(args[1], false);
                            break block14;
                        }
                        case 3: {
                            if (args[1].equalsIgnoreCase("oware")) {
                                System.out.println("\nDATA MIGRATOR - Export Security\n");
                                success = DataMigrator.exportData(args[2], true);
                            }
                            break block14;
                        }
                        default: {
                            throw new CmdLineException("Wrong command line format!");
                        }
                    }
                }
                if (!args[0].equals("-import")) throw new CmdLineException("Wrong command : <" + args[0] + ">!");
                if (args.length == 2) {
                    System.out.println("\nDATA MIGRATOR - Import Configuration\n");
                    success = DataMigrator.importData(args[1]);
                }
            }
            log.info("Done.", new Object[0]);
            System.exit(success ? 0 : 1);
        }
        catch (CmdLineException e) {
            System.out.println("15:14:29,404 ERROR " + e.getMessage());
            System.out.println("\nUsage : owlaunch com.bwanms.setup.migration.DataMigrator -<command> [oware] <fileName>");
            System.out.println("\t<command>: export / import");
            System.out.println("\t[oware]: oware flag (only for export)");
            System.out.println("\t<fileName>: archive file name\n");
            success = false;
            System.exit(success ? 0 : 1);
            return;
        }
        catch (Throwable e2) {
            e2.printStackTrace();
            String msg = e2.getMessage();
            if (msg == null || msg.length() == 0) {
                Throwable cause = e2.getCause();
                msg = cause != null ? cause.getMessage() : "Unknown application or system error";
            }
            log.error(msg, new Object[0]);
            success = false;
            System.exit(success ? 0 : 1);
            {
                catch (Throwable throwable) {
                    System.exit(success ? 0 : 1);
                    throw throwable;
                }
            }
            return;
        }
        return;
    }

    private static boolean exportData(String outputFile, boolean owareFlag) throws Exception {
        AbstractExporter exporter = null;
        exporter = owareFlag ? new OwareExporter(outputFile) : new NMSExporter(outputFile);
        if (exporter == null) {
            log.error("Exporter not found!", new Object[0]);
            return false;
        }
        if (!exporter.doExport()) {
            log.error("Export failure!", new Object[0]);
            return false;
        }
        return true;
    }

    private static boolean importData(String inputFile) throws Exception {
        NMSImporter importer = new NMSImporter(inputFile);
        if (importer == null) {
            log.error("Importer not found!", new Object[0]);
            return false;
        }
        if (!importer.doImport()) {
            log.error("Import failure!", new Object[0]);
            return false;
        }
        return true;
    }

    private static class CmdLineException
    extends Exception {
        public CmdLineException(String message) {
            super(message);
        }
    }
}

