/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.session;

import javax.transaction.Synchronization;
import org.hibernate.Session;
import org.jboss.hibernate.session.HibernateContext;
import org.jboss.logging.Logger;

class TransactionSynch
implements Synchronization {
    private static Logger log = Logger.getLogger(TransactionSynch.class);
    private String name;
    private Session session;

    public TransactionSynch(String name, Session session) {
        if (log.isTraceEnabled()) {
            log.trace((Object)("Preparing synch [name=" + name + ", session=" + session + "]"));
        }
        if (session == null) {
            throw new IllegalArgumentException("Session to synchronize cannot be null");
        }
        this.name = name;
        this.session = session;
    }

    public void beforeCompletion() {
        if (!this.session.isOpen()) {
            log.warn((Object)"Session already closed");
        } else {
            try {
                log.trace((Object)"Flushing Session");
                this.session.flush();
            }
            catch (Throwable t) {
                log.warn((Object)"Error flushing session");
            }
        }
    }

    public void afterCompletion(int status) {
        if (this.session.isOpen()) {
            try {
                log.trace((Object)"Closing Session");
                this.session.close();
            }
            catch (Throwable t) {
                log.warn((Object)"Unable to close session");
            }
        }
        if (this.session != HibernateContext.unbind(this.name)) {
            log.warn((Object)"Synch encountered different session in context while performing unbind");
        }
    }
}

