/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.session;

import java.util.HashMap;
import java.util.Map;
import javax.naming.InitialContext;
import javax.naming.NamingException;
import javax.transaction.RollbackException;
import javax.transaction.Synchronization;
import javax.transaction.SystemException;
import javax.transaction.Transaction;
import javax.transaction.TransactionManager;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.jboss.hibernate.session.TransactionNotSupportedException;
import org.jboss.hibernate.session.TransactionSynch;
import org.jboss.logging.Logger;
import org.jboss.tm.TransactionLocal;

public class HibernateContext {
    private static final Logger log = Logger.getLogger(HibernateContext.class);
    private static final TransactionLocal sessions = new TransactionLocal(){

        protected Object initialValue() {
            return new HashMap();
        }
    };

    public static Session getUnmanagedSession(String name) throws HibernateException, IllegalStateException {
        Session managedSession = HibernateContext.lookupSession(name);
        if (managedSession == null) {
            throw new IllegalStateException("No managed session found for current context");
        }
        return managedSession.getSessionFactory().openSession(managedSession.connection());
    }

    public static void releaseUnmanagedSession(Session unmanagedSession) throws HibernateException {
        unmanagedSession.close();
    }

    public static Session getSession(String name) {
        Session currentSession = HibernateContext.lookupSession(name);
        if (currentSession == null) {
            log.trace((Object)"No session bound; generating");
            currentSession = HibernateContext.generateSession(name);
            HibernateContext.bind(name, currentSession);
        }
        return currentSession;
    }

    public static boolean hasBind(String name) {
        return ((Map)sessions.get()).containsKey(name);
    }

    public static void bind(String name, Session currentSession) throws HibernateException {
        if (HibernateContext.hasBind(name)) {
            throw new HibernateException("Session already bound to [" + name + "] for current transaction");
        }
        ((Map)sessions.get()).put(name, currentSession);
    }

    public static Session unbind(String name) {
        return (Session)((Map)sessions.get()).remove(name);
    }

    public static void prepareSession(String name, Session session) throws HibernateException {
        InitialContext context = null;
        try {
            context = new InitialContext();
            TransactionManager tm = (TransactionManager)context.lookup("java:/TransactionManager");
            Transaction transaction = tm.getTransaction();
            if (transaction == null) {
                throw new TransactionNotSupportedException("Transaction not supported");
            }
            transaction.registerSynchronization((Synchronization)new TransactionSynch(name, session));
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to locate TransactionManager", (Throwable)e);
        }
        catch (IllegalStateException e) {
            throw new HibernateException("Unable to register transaction synch", (Throwable)e);
        }
        catch (RollbackException e) {
            throw new HibernateException("Unable to register transaction synch", (Throwable)e);
        }
        catch (SystemException e) {
            throw new HibernateException("Unable to locate Transaction", (Throwable)e);
        }
        finally {
            HibernateContext.release(context);
        }
    }

    private static Session lookupSession(String name) {
        return (Session)((Map)sessions.get()).get(name);
    }

    private static Session generateSession(String name) throws HibernateException {
        SessionFactory factory = HibernateContext.locateSessionFactory(name);
        return factory.openSession();
    }

    private static SessionFactory locateSessionFactory(String name) throws HibernateException {
        InitialContext context = null;
        try {
            SessionFactory factory;
            context = new InitialContext();
            SessionFactory sessionFactory = factory = (SessionFactory)context.lookup(name);
            return sessionFactory;
        }
        catch (NamingException e) {
            throw new HibernateException("Unable to locate SessionFactory in JNDI under name [" + name + "]", (Throwable)e);
        }
        finally {
            HibernateContext.release(context);
        }
    }

    private static void release(InitialContext ctx) {
        if (ctx != null) {
            try {
                ctx.close();
            }
            catch (Throwable t) {
                log.info((Object)"Unable to release context", t);
            }
        }
    }
}

