/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jmx;

import com.bwanms.platform.PlatformFactory;
import com.bwanms.plugin.impl.PluginScanner;
import java.io.ByteArrayInputStream;
import java.util.List;
import java.util.Properties;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.w3c.dom.Document;

public class HibernateLocal {
    public static final String SESSION_FACTORY_NAME = "java:/bwanms/HibernateSessionFactory";
    private static HibernateLocal instance;
    private Properties factoryProperties = null;
    private String pluginsFolder = null;

    public static HibernateLocal getInstance() {
        if (instance == null) {
            instance = new HibernateLocal();
        }
        return instance;
    }

    private HibernateLocal() {
    }

    public void start() {
        try {
            AnnotationConfiguration configuration = new AnnotationConfiguration();
            if (this.factoryProperties != null) {
                configuration.setProperties(this.factoryProperties);
            }
            StringBuilder configurationXML = new StringBuilder();
            configurationXML.append("<hibernate-configuration><session-factory>\n");
            List<String> includes = PluginScanner.scanFolderForJaredTextResources(this.pluginsFolder, "hibernate-mappings.xml.inc");
            for (String include : includes) {
                configurationXML.append(include);
            }
            configurationXML.append("\n</session-factory></hibernate-configuration>");
            DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
            Document document = builder.parse(new ByteArrayInputStream(configurationXML.toString().getBytes()));
            SessionFactory sessionFactory = configuration.configure(document).buildSessionFactory();
            PlatformFactory.getApplicationLayerPlatform().getLookup().bind(SESSION_FACTORY_NAME, sessionFactory);
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void stop() {
        HibernateLocal.lookup().close();
        PlatformFactory.getApplicationLayerPlatform().getLookup().unbind(SESSION_FACTORY_NAME);
    }

    public static SessionFactory lookup() {
        return (SessionFactory)PlatformFactory.getApplicationLayerPlatform().getLookup().lookup(SESSION_FACTORY_NAME);
    }

    public void setFactoryProperties(Properties factoryProperties) {
        this.factoryProperties = factoryProperties;
    }

    public String getPluginsFolder() {
        return this.pluginsFolder;
    }

    public void setPluginsFolder(String pluginsFolder) {
        this.pluginsFolder = pluginsFolder;
    }
}

