/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.hibernate.jmx;

import com.bwanms.plugin.impl.PluginScanner;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileReader;
import java.util.List;
import javax.naming.InitialContext;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.apache.log4j.Logger;
import org.hibernate.SessionFactory;
import org.hibernate.cfg.AnnotationConfiguration;
import org.jboss.hibernate.jmx.HibernateMBean;
import org.jboss.system.ServiceMBeanSupport;
import org.w3c.dom.Document;

public class Hibernate
extends ServiceMBeanSupport
implements HibernateMBean {
    private static final Logger log = Logger.getLogger(Hibernate.class);
    public static final String SESSION_FACTORY_NAME = "java:/bwanms/HibernateSessionFactory";
    private final String HIBERNATE_MAPPINGS_INCLUDE = "<!--HIBERNATE_MAPPINGS_INCLUDE-->";
    private SessionFactory sessionFactory;
    private String bwaNmsSarHome;

    public String getBwaNmsSarHome() {
        return this.bwaNmsSarHome;
    }

    public void setBwaNmsSarHome(String bwaNmsSarHome) {
        this.bwaNmsSarHome = bwaNmsSarHome;
    }

    public String getName() {
        return "Hibernate";
    }

    public boolean isSessionFactoryRunning() {
        return this.sessionFactory != null;
    }

    public void rebuildSessionFactory() throws Exception {
        this.destroySessionFactory();
        this.buildSessionFactory();
    }

    public void startService() throws Exception {
        this.buildSessionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stopService() throws Exception {
        InitialContext context = new InitialContext();
        this.destroySessionFactory();
    }

    private void buildSessionFactory() throws Exception {
        log.info((Object)"*******BUILDING HIBERNATE SESSION FACTORY*******");
        log.info((Object)("BWANMS.SAR: " + this.bwaNmsSarHome));
        File hibCfg = new File(this.bwaNmsSarHome + "/hibernate.cfg.xml");
        List<String> includes = PluginScanner.scanFolderForJaredTextResources(this.bwaNmsSarHome + "/lib", "hibernate-mappings.xml.inc");
        StringBuilder contents = new StringBuilder();
        for (String mappings : includes) {
            contents.append(mappings);
        }
        log.debug((Object)contents.toString());
        StringBuilder hibCfgTxt = this.readText(hibCfg);
        int idx = hibCfgTxt.indexOf("<!--HIBERNATE_MAPPINGS_INCLUDE-->");
        if (idx == -1) {
            throw new Exception("Invalid hibernate.cfg.xml: can't find mappings include marker (<!--HIBERNATE_MAPPINGS_INCLUDE-->)");
        }
        hibCfgTxt.insert(idx + "<!--HIBERNATE_MAPPINGS_INCLUDE-->".length() + 1, includes);
        log.debug((Object)("\n" + hibCfgTxt));
        DocumentBuilder builder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        Document document = builder.parse(new ByteArrayInputStream(hibCfgTxt.toString().getBytes()));
        AnnotationConfiguration cfg = new AnnotationConfiguration();
        cfg.configure(document);
        this.sessionFactory = cfg.buildSessionFactory();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private StringBuilder readText(File f) throws Exception {
        StringBuilder txt = new StringBuilder();
        BufferedReader fin = null;
        try {
            String line;
            fin = new BufferedReader(new FileReader(f));
            while ((line = fin.readLine()) != null) {
                txt.append(line);
            }
        }
        finally {
            if (fin != null) {
                fin.close();
            }
        }
        return txt;
    }

    private void destroySessionFactory() throws Exception {
        if (this.sessionFactory != null) {
            this.sessionFactory.close();
            this.sessionFactory = null;
        }
    }
}

