/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.xml;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.log4j.Logger;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class XmlFileManager {
    private static final String PROP_DOC_BUILDER_FACTORY = "javax.xml.parsers.DocumentBuilderFactory";
    private static final String PROP_TRANSFORMER_FACTORY = "javax.xml.transform.TransformerFactory";
    private static final Logger logger;
    private static final XPath xpath;
    private static final ClassLoader xmlSchemaLoader;
    private final DocumentBuilder docBuilder;
    private final SchemaFactory w3cXmlSchemaFactory;
    private final Document dom;

    private XmlFileManager() {
        throw new UnsupportedOperationException();
    }

    public XmlFileManager(InputStream is, String w3cXmlSchemaPath) throws SAXException, IOException, ParserConfigurationException {
        this(is, w3cXmlSchemaPath, null);
    }

    public XmlFileManager(InputStream is, String w3cXmlSchemaPath, ErrorHandler validationErrorHandler) throws SAXException, IOException, ParserConfigurationException {
        String initialDocBuilderFactoryProp = System.setProperty(PROP_DOC_BUILDER_FACTORY, "com.sun.org.apache.xerces.internal.jaxp.DocumentBuilderFactoryImpl");
        if (logger.isDebugEnabled()) {
            logger.debug((Object)("javax.xml.parsers.DocumentBuilderFactory(initial): " + initialDocBuilderFactoryProp));
            logger.debug((Object)("javax.xml.parsers.DocumentBuilderFactory(now): " + System.getProperty(PROP_DOC_BUILDER_FACTORY)));
        }
        this.docBuilder = DocumentBuilderFactory.newInstance().newDocumentBuilder();
        if (initialDocBuilderFactoryProp != null) {
            System.setProperty(PROP_DOC_BUILDER_FACTORY, initialDocBuilderFactoryProp);
        }
        if (!this.docBuilder.getClass().getName().startsWith("com.sun.org.apache.xerces.internal.")) {
            logger.warn((Object)("DocumentBuilder class is not a jre implementation: " + this.docBuilder.getClass().getName()));
            logger.warn((Object)"DocumentBuilder implementation found in next resources: ");
            Enumeration<URL> urls = XmlFileManager.class.getClassLoader().getResources(this.docBuilder.getClass().getName().replace('.', '/') + ".class");
            while (urls.hasMoreElements()) {
                logger.warn((Object)("\t" + urls.nextElement()));
            }
        }
        this.dom = this.docBuilder.parse(is);
        this.w3cXmlSchemaFactory = SchemaFactory.newInstance("http://www.w3.org/2001/XMLSchema");
        if (w3cXmlSchemaPath != null) {
            InputStream xsdIn = xmlSchemaLoader.getResourceAsStream(w3cXmlSchemaPath);
            Schema xmlSchema = this.w3cXmlSchemaFactory.newSchema(new StreamSource(xsdIn));
            String initialTransformerFactoryProp = System.setProperty(PROP_TRANSFORMER_FACTORY, "com.sun.org.apache.xalan.internal.xsltc.trax.TransformerFactoryImpl");
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("javax.xml.transform.TransformerFactory(initial): " + initialTransformerFactoryProp));
                logger.debug((Object)("javax.xml.transform.TransformerFactory(now): " + System.getProperty(PROP_TRANSFORMER_FACTORY)));
            }
            Validator xmlSchemaValidator = xmlSchema.newValidator();
            if (validationErrorHandler != null) {
                xmlSchemaValidator.setErrorHandler(validationErrorHandler);
            }
            xmlSchemaValidator.validate(new DOMSource(this.dom));
            if (initialTransformerFactoryProp != null) {
                System.setProperty(PROP_TRANSFORMER_FACTORY, initialTransformerFactoryProp);
            }
        }
    }

    public final List<Map<String, String>> retrieveValues(String expression) throws XPathExpressionException {
        NodeList nodes = (NodeList)xpath.evaluate(expression, this.dom, XPathConstants.NODESET);
        ArrayList<Map<String, String>> ret = new ArrayList<Map<String, String>>(nodes.getLength());
        for (int i = 0; i < nodes.getLength(); ++i) {
            Node node = nodes.item(i);
            if (logger.isDebugEnabled()) {
                XmlFileManager.printDOM(node, 0);
            }
            if (!node.hasChildNodes()) continue;
            HashMap<String, String> paramsToValues = new HashMap<String, String>();
            this.addChildValues(node, paramsToValues);
            ret.add(paramsToValues);
        }
        return ret;
    }

    private void addChildValues(Node node, Map<String, String> paramsToValues) {
        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            if (this.hasChildElem(childNode)) {
                this.addChildValues(childNode, paramsToValues);
                continue;
            }
            String value = childNode.getTextContent();
            if (value != null) {
                value = value.trim();
            }
            paramsToValues.put(childNode.getNodeName(), value);
        }
    }

    private boolean hasChildElem(Node node) {
        if (node == null || !node.hasChildNodes()) {
            return false;
        }
        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            if (childNode.getNodeType() != 1) continue;
            return true;
        }
        return false;
    }

    private static void printDOM(Node node, int level) {
        String prefix = "";
        for (int i = 0; i < level; ++i) {
            prefix = prefix + "\t";
        }
        String text = node.getNodeValue();
        if (text != null) {
            text = text.trim();
        }
        if (node.getNodeType() != 3 || text != null && text.length() > 0) {
            logger.debug((Object)(level + ": " + prefix + node.getNodeName() + " [" + text + "]"));
        }
        ++level;
        for (Node childNode = node.getFirstChild(); childNode != null; childNode = childNode.getNextSibling()) {
            XmlFileManager.printDOM(childNode, level);
        }
    }

    static {
        try {
            logger = Logger.getLogger(XmlFileManager.class);
            xpath = XPathFactory.newInstance().newXPath();
            xmlSchemaLoader = XmlFileManager.class.getClassLoader();
        }
        catch (Exception e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

