/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

import com.bwanms.validation.WeakRange;
import java.io.Serializable;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakRangeValidator
implements Validator<WeakRange>,
Serializable {
    private long max;
    private long min;

    public void initialize(WeakRange parameters) {
        this.max = parameters.max();
        this.min = parameters.min();
    }

    public boolean isValid(Object value) {
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            try {
                double dv = Double.parseDouble((String)value);
                return dv >= (double)this.min && dv <= (double)this.max;
            }
            catch (NumberFormatException nfe) {
                return false;
            }
        }
        if (value instanceof Double || value instanceof Float) {
            double nfe = ((Number)value).doubleValue();
            return nfe >= (double)this.min && nfe <= (double)this.max;
        }
        if (value instanceof Number) {
            long lv = ((Number)value).longValue();
            return lv >= this.min && lv <= this.max;
        }
        return false;
    }
}

