/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

import com.bwanms.validation.WeakMultiRanges;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakMultiRangesValidator
implements Validator<WeakMultiRanges> {
    private double[] ranges;

    public void initialize(WeakMultiRanges parameters) {
        this.ranges = parameters.ranges();
    }

    public boolean isValid(Object value) {
        double dv;
        if (value == null || this.ranges == null || this.ranges.length == 0) {
            return true;
        }
        if (value instanceof String) {
            try {
                dv = Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else if (value instanceof Number) {
            dv = ((Number)value).doubleValue();
        } else {
            return false;
        }
        for (int i = 0; i < this.ranges.length; i += 2) {
            if (this.ranges.length - 1 == i) {
                return this.ranges[i] == dv;
            }
            if (!(this.ranges[i] <= dv) || !(dv <= this.ranges[i + 1])) continue;
            return true;
        }
        return false;
    }
}

