/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

import com.bwanms.validation.WeakFloatStepRange;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakFloatStepRangeValidator
implements Validator<WeakFloatStepRange> {
    private static final String REGEX_FLOATING_POINT = "^[-]?([1-9]{1}[0-9]{0,5}(\\.[0-9]{1,5})?|0(\\.[0-9]{1,5})?)$";
    private double min;
    private double max;
    private double step;
    private double[] acceptedValues;

    public void initialize(WeakFloatStepRange parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
        this.step = parameters.step();
        this.acceptedValues = parameters.acceptedValues();
    }

    public boolean isValid(Object value) {
        double dv;
        double tempStep = this.step;
        if (value == null) {
            return true;
        }
        if (value instanceof String && value.toString().trim().matches(REGEX_FLOATING_POINT)) {
            try {
                dv = Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else if (value instanceof Number) {
            dv = ((Number)value).doubleValue();
        } else {
            return false;
        }
        for (double acceptedValue : this.acceptedValues) {
            if (dv != acceptedValue) continue;
            return true;
        }
        if (dv < this.min || dv > this.max) {
            return false;
        }
        int mul = 1;
        int prec = 0;
        while (tempStep - (double)((long)tempStep) > 0.0) {
            tempStep *= 10.0;
            mul *= 10;
            ++prec;
        }
        String sv = String.valueOf(dv);
        sv = String.format("%." + prec + "f", dv);
        if (dv != Double.valueOf(sv)) {
            return false;
        }
        long muliv = Math.round(dv * (double)mul);
        return ((double)muliv - this.min * (double)mul) % (double)((long)tempStep) == 0.0;
    }

    public static void main(String[] args) {
        WeakFloatStepRangeValidator validator = new WeakFloatStepRangeValidator();
        validator.min = 1.0;
        validator.max = 10.0;
        validator.acceptedValues = new double[]{-2.0, -1.0};
        double step = 0.3;
        System.out.println("-3\t" + validator.isValid(-3));
        System.out.println("-2\t" + validator.isValid(-2));
        System.out.println("-1\t" + validator.isValid(-1));
        int i = (int)validator.min;
        while ((double)i <= validator.max) {
            for (int d = 0; d < 10; ++d) {
                double dv = Double.valueOf(i + "." + d);
                validator.step = step;
                System.out.println(dv + "\t" + validator.isValid(dv));
            }
            ++i;
        }
    }
}

