/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

import com.bwanms.validation.WeakFloatRange;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class WeakFloatRangeValidator
implements Validator<WeakFloatRange> {
    private double min;
    private double max;

    public void initialize(WeakFloatRange parameters) {
        this.min = parameters.min();
        this.max = parameters.max();
    }

    public boolean isValid(Object value) {
        double dv;
        if (value == null) {
            return true;
        }
        if (value instanceof String) {
            try {
                dv = Double.parseDouble((String)value);
            }
            catch (NumberFormatException e) {
                return false;
            }
        } else if (value instanceof Number) {
            dv = ((Number)value).doubleValue();
        } else {
            return false;
        }
        return this.min <= dv && dv <= this.max;
    }
}

