/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

public class IPv4Validator {
    public static final String REGEX_ANY_IP = "^(?:1\\d?\\d?|2(?:[0-4]\\d?|[6-9]|5[0-5]?)?|[3-9]\\d?|0)(?:\\.(?:1\\d?\\d?|2(?:[0-4]\\d?|[6-9]|5[0-5]?)?|[3-9]\\d?|0)){3}$";
    public static final String REGEX_VALID_IP = "^(?:1(?:[013-9]\\d?|2[0-689]?)?|2(?:[01]\\d?|[3-9]|2[0-3]?)?|[3-9]\\d?)(?:\\.(?:1\\d?\\d?|2(?:[0-4]\\d?|[6-9]|5[0-5]?)?|[3-9]\\d?|0)){3}$";
    public static final String REGEX_ROUTE_MASK = "^(:?255\\.){3}(:?25[245]|24[08]|224|192|128|0)|(:?255\\.){2}(:?25[245]|24[08]|224|192|128|0)\\.0|255\\.(:?25[245]|24[08]|224|192|128|0)(:?\\.0){2}|(:?25[245]|24[08]|224|192|128|0)(:?\\.0){3}$";
    public static final String REGEX_HOST_MASK = "^(:?255\\.){3}(:?25[24]|24[08]|224|192|128|0)|(:?255\\.){2}(:?25[245]|24[08]|224|192|128|0)\\.0|255\\.(:?25[245]|24[08]|224|192|128|0)(:?\\.0){2}|(:?25[245]|24[08]|224|192|128)(:?\\.0){3}$";
    private static final int MSB = Integer.MIN_VALUE;
    private static final String MSG_INVALID_IP_FORMAT = "Invalid IP format";
    private static final String MSG_RESERVED_IP = "Reserved IP";
    private static final String MSG_LOOPBACK = "Loopback - reserved IP";
    private static final String MSG_INVALID_HOST_MASK = "Invalid host mask";
    private static final String MSG_INVALID_ROUTE_MASK = "Invalid route mask";
    private static final String MSG_NETWORK_IP = "Network IP";
    private static final String MSG_BROADCAST_IP = "Broadcast IP";
    private static final String MSG_HOST_IP = "Host IP";
    private static final String MSG_MSB_ZERO = "MSB is 0";
    private static final String MSG_LSB_ONE = "LSB is 1";
    private static final String MSG_OK_SPECIAL_CASE = "OK - special case";
    private static final String MSG_OK = "OK";

    private IPv4Validator() {
    }

    public static boolean isValidIp(String ipAddress) {
        if (ipAddress == null || ipAddress.length() < 7) {
            return false;
        }
        return ipAddress.matches(REGEX_VALID_IP);
    }

    public static boolean isValidIp(int ipAddress) {
        int firstByte = ipAddress >>> 24;
        return firstByte <= 223 && firstByte != 0 && firstByte != 127;
    }

    public static boolean isIp(String ipAddress) {
        if (ipAddress == null || ipAddress.length() < 7) {
            return false;
        }
        return ipAddress.matches(REGEX_ANY_IP);
    }

    public static boolean isValidHostMask(String mask) {
        try {
            int m = IPv4Validator.valueOf(mask);
            return IPv4Validator.isValidHostMask(m);
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean isValidHostMask(int mask) {
        if ((mask & Integer.MIN_VALUE) == 0 || (mask & 1) == 1) {
            return false;
        }
        return IPv4Validator.isValidRouteMask(mask);
    }

    public static boolean isValidRouteMask(String mask) {
        try {
            return IPv4Validator.isValidRouteMask(IPv4Validator.valueOf(mask));
        }
        catch (RuntimeException e) {
            return false;
        }
    }

    public static boolean isValidRouteMask(int mask) {
        if (mask == 0 || mask == -1) {
            return true;
        }
        if ((mask & Integer.MIN_VALUE) == 0 || (mask & 1) == 1) {
            return false;
        }
        int noOfTrailingZeros = Integer.numberOfTrailingZeros(mask);
        if (noOfTrailingZeros > 0) {
            mask >>= noOfTrailingZeros;
        }
        return mask == -1;
    }

    public static boolean isValidNetworkIp(String ipAddress, String mask) {
        int reverseMask;
        if (!IPv4Validator.isValidIp(ipAddress) || !IPv4Validator.isValidHostMask(mask)) {
            return false;
        }
        int ip = IPv4Validator.valueOf(ipAddress);
        return (ip & (reverseMask = ~IPv4Validator.valueOf(mask))) == 0;
    }

    public static boolean isValidRouteIp(String ipAddress, String mask) {
        boolean zeroCase = ipAddress.equals("0.0.0.0") && mask.equals("0.0.0.0");
        boolean specialCase = ipAddress.equals("127.0.0.0") && mask.equals("255.0.0.0");
        boolean oneMask = mask.equals("255.255.255.255");
        if (zeroCase || specialCase) {
            return true;
        }
        if (!oneMask) {
            return IPv4Validator.isValidNetworkIp(ipAddress, mask);
        }
        return IPv4Validator.isValidIp(ipAddress);
    }

    public static boolean isValidBroadcastIp(String ipAddress, String mask) {
        int reverseMask;
        if (!IPv4Validator.isValidIp(ipAddress) || !IPv4Validator.isValidHostMask(mask)) {
            return false;
        }
        int ip = IPv4Validator.valueOf(ipAddress);
        return (ip & (reverseMask = ~IPv4Validator.valueOf(mask))) == reverseMask;
    }

    public static boolean isValidHostIp(String ipAddress, String mask) {
        int reverseMask;
        if (!IPv4Validator.isValidIp(ipAddress) || !IPv4Validator.isValidHostMask(mask)) {
            return false;
        }
        int ip = IPv4Validator.valueOf(ipAddress);
        int hostBits = ip & (reverseMask = ~IPv4Validator.valueOf(mask));
        return hostBits != 0 && hostBits != reverseMask;
    }

    public static boolean ipBelogsToNetwork(String ipAddress, String netIpAddress, String netIpMask) {
        if (!IPv4Validator.isValidIp(ipAddress) || !IPv4Validator.isValidHostIp(netIpAddress, netIpMask)) {
            return false;
        }
        int ip = IPv4Validator.valueOf(ipAddress);
        int netIp = IPv4Validator.valueOf(netIpAddress);
        int netMask = IPv4Validator.valueOf(netIpMask);
        return (ip & netMask) == (netIp & netMask);
    }

    public static int valueOf(String ip) {
        if (!IPv4Validator.isIp(ip)) {
            throw new IllegalArgumentException("Invalid IPv4 format: " + ip);
        }
        int ipValue = 0;
        for (String b : ip.split("\\.")) {
            ipValue <<= 8;
            ipValue |= Integer.valueOf(b).intValue();
        }
        return ipValue;
    }

    public static String toString(int ip) {
        StringBuilder sb = new StringBuilder(15);
        for (int shift = 24; shift > 0; shift -= 8) {
            sb.append(ip >>> shift & 0xFF).append('.');
        }
        return sb.append(ip & 0xFF).toString();
    }

    private static int getRandomIp(int minIp) {
        return minIp | Long.valueOf(Math.round(Math.random() * 2.147483647E9)).intValue();
    }

    public static void main(String[] args) {
        String[][] ipPairs;
        String[][] masks;
        String[][] ips;
        int i;
        boolean checkFirstBytes = false;
        boolean checkMasks = false;
        if (checkFirstBytes) {
            for (i = 0; i < 256; ++i) {
                String ip = i + ".0.0.0";
                System.out.println("isValidIp(): " + ip + ": " + IPv4Validator.isValidIp(ip));
            }
            System.out.println();
        }
        if (checkMasks) {
            for (i = 0; i < 34; ++i) {
                int m = ~(1 << i) + 1;
                if (i == 32) {
                    m = 0;
                } else if (i > 32) {
                    m = IPv4Validator.getRandomIp(-8388608);
                }
                String mask = IPv4Validator.toString(m);
                System.out.println(String.format("isValidRouteMask(): %s: %s", mask, IPv4Validator.isValidRouteMask(mask)));
                System.out.println(String.format("  ROUTE_MASK_REGEX: %s: %s\n", mask, mask.matches(REGEX_ROUTE_MASK)));
                System.out.println(String.format(" isValidHostMask(): %s: %s", mask, IPv4Validator.isValidHostMask(mask)));
                System.out.println(String.format("   HOST_MASK_REGEX: %s: %s\n", mask, mask.matches(REGEX_HOST_MASK)));
            }
        }
        for (String[] ip : ips = new String[][]{{"a.b.c.d", MSG_INVALID_IP_FORMAT}, {"0.0.0.00", MSG_INVALID_IP_FORMAT}, {"0.0.0.0.", MSG_INVALID_IP_FORMAT}, {"0.0.0,0", MSG_INVALID_IP_FORMAT}, {"0.0.0..0", MSG_INVALID_IP_FORMAT}, {"0.0.0", MSG_INVALID_IP_FORMAT}, {"1.0.256.1", MSG_INVALID_IP_FORMAT}, {"0.0.0.0", MSG_RESERVED_IP}, {"0.255.255.255", MSG_RESERVED_IP}, {"1.0.0.0", MSG_OK}, {"17.2.4.89", MSG_OK}, {"126.255.255.255", MSG_OK}, {"127.0.0.0", MSG_LOOPBACK}, {"127.23.45.1", MSG_LOOPBACK}, {"127.255.255.255", MSG_LOOPBACK}, {"128.0.0.0", MSG_OK}, {"196.2.148.23", MSG_OK}, {"223.255.255.255", MSG_OK}, {"224.0.0.0", MSG_RESERVED_IP}, {"240.123.255.255", MSG_RESERVED_IP}, {"255.255.255.192", MSG_RESERVED_IP}, {"255.255.255.255", MSG_RESERVED_IP}}) {
            System.out.println(String.format("isIp(): %s: %s", ip[0], IPv4Validator.isIp(ip[0])));
        }
        System.out.println();
        for (String[] ip : ips) {
            System.out.println(String.format("isValidIp(): %s: %s (%s)", ip[0], IPv4Validator.isValidIp(ip[0]), ip[1]));
        }
        System.out.println();
        for (String[] mask : masks = new String[][]{{"0.0.0.00", MSG_INVALID_IP_FORMAT}, {"0.0.0.0", MSG_MSB_ZERO}, {"0.0.0.1", MSG_MSB_ZERO}, {"127.0.0.0", MSG_MSB_ZERO}, {"128.0.0.0", MSG_OK}, {"128.0.0.1", MSG_LSB_ONE}, {"128.0.0.7", MSG_LSB_ONE}, {"192.0.0.0", MSG_OK}, {"192.1.0.0", MSG_INVALID_HOST_MASK}, {"223.0.0.0", MSG_INVALID_HOST_MASK}, {"224.0.0.0", MSG_OK}, {"255.128.0.0", MSG_OK}, {"255.250.0.0", MSG_INVALID_HOST_MASK}, {"255.255.250.0", MSG_INVALID_HOST_MASK}, {"255.255.255.250", MSG_INVALID_HOST_MASK}, {"255.255.255.254", MSG_OK}, {"255.255.255.255", MSG_LSB_ONE}}) {
            System.out.println(String.format("isValidHostMask(): %s: %s (%s)", mask[0], IPv4Validator.isValidHostMask(mask[0]), mask[1]));
        }
        System.out.println();
        for (String[] mask : masks = new String[][]{{"0.0.0.00", MSG_INVALID_IP_FORMAT}, {"0.0.0.0", MSG_OK}, {"0.0.0.1", MSG_MSB_ZERO}, {"127.0.0.0", MSG_MSB_ZERO}, {"128.0.0.0", MSG_OK}, {"128.0.0.1", MSG_INVALID_ROUTE_MASK}, {"128.0.0.7", MSG_INVALID_ROUTE_MASK}, {"192.0.0.0", MSG_OK}, {"192.1.0.0", MSG_INVALID_ROUTE_MASK}, {"223.0.0.0", MSG_INVALID_ROUTE_MASK}, {"224.0.0.0", MSG_OK}, {"255.128.0.0", MSG_OK}, {"255.250.0.0", MSG_INVALID_ROUTE_MASK}, {"255.255.250.0", MSG_INVALID_ROUTE_MASK}, {"255.255.255.250", MSG_INVALID_ROUTE_MASK}, {"255.255.255.254", MSG_OK}, {"255.255.255.255", MSG_OK}}) {
            System.out.println(String.format("isValidRouteMask(): %s: %s (%s)", mask[0], IPv4Validator.isValidRouteMask(mask[0]), mask[1]));
        }
        System.out.println();
        for (String[] ipPair : ipPairs = new String[][]{{"a.b.c.d", "255.0.0.0", MSG_INVALID_IP_FORMAT}, {"1.0.0.0", "127.0.0.0", MSG_INVALID_HOST_MASK}, {"0.0.0.0", "255.0.0.0", MSG_RESERVED_IP}, {"127.0.0.0", "255.0.0.0", MSG_LOOPBACK}, {"210.24.7.2", "255.255.255.252", MSG_HOST_IP}, {"210.24.7.3", "255.255.255.252", MSG_BROADCAST_IP}, {"210.24.7.4", "255.255.255.252", MSG_OK}, {"210.24.3.0", "255.255.248.0", MSG_HOST_IP}, {"210.24.7.255", "255.255.248.0", MSG_BROADCAST_IP}, {"210.24.8.0", "255.255.248.0", MSG_OK}, {"210.15.0.0", "255.240.0.0", MSG_HOST_IP}, {"210.15.255.255", "255.240.0.0", MSG_BROADCAST_IP}, {"210.16.0.0", "255.240.0.0", MSG_OK}, {"31.0.0.0", "224.0.0.0", MSG_HOST_IP}, {"31.255.255.255", "224.0.0.0", MSG_BROADCAST_IP}, {"192.0.0.0", "224.0.0.0", MSG_OK}}) {
            System.out.println(String.format("isValidNetworkIp(): %s/%s: %s (%s)", ipPair[0], ipPair[1], IPv4Validator.isValidNetworkIp(ipPair[0], ipPair[1]), ipPair[2]));
        }
        System.out.println();
        for (String[] ipPair : ipPairs = new String[][]{{"a.b.c.d", "255.0.0.0", MSG_INVALID_IP_FORMAT}, {"1.0.0.0", "63.0.0.0", MSG_INVALID_HOST_MASK}, {"127.128.0.0", "255.255.255.255", MSG_LOOPBACK}, {"224.0.0.0", "255.0.0.0", MSG_RESERVED_IP}, {"0.0.0.0", "0.0.0.0", MSG_OK_SPECIAL_CASE}, {"127.0.0.0", "255.0.0.0", MSG_OK_SPECIAL_CASE}, {"210.24.7.2", "255.255.255.255", MSG_OK}, {"210.24.7.2", "255.255.255.252", MSG_HOST_IP}, {"210.24.7.3", "255.255.255.252", MSG_BROADCAST_IP}, {"210.24.7.4", "255.255.255.252", MSG_OK}, {"210.24.3.0", "255.255.255.255", MSG_OK}, {"210.24.3.0", "255.255.248.0", MSG_HOST_IP}, {"210.24.7.255", "255.255.248.0", MSG_BROADCAST_IP}, {"210.24.8.0", "255.255.248.0", MSG_OK}, {"210.15.0.0", "255.255.255.255", MSG_OK}, {"210.15.0.0", "255.240.0.0", MSG_HOST_IP}, {"210.15.255.255", "255.240.0.0", MSG_BROADCAST_IP}, {"210.16.0.0", "255.240.0.0", MSG_OK}, {"31.0.0.0", "255.255.255.255", MSG_OK}, {"31.0.0.0", "224.0.0.0", MSG_HOST_IP}, {"31.255.255.255", "224.0.0.0", MSG_BROADCAST_IP}, {"192.0.0.0", "224.0.0.0", MSG_OK}}) {
            System.out.println(String.format("isValidRouteIp(): %s/%s: %s (%s)", ipPair[0], ipPair[1], IPv4Validator.isValidRouteIp(ipPair[0], ipPair[1]), ipPair[2]));
        }
        System.out.println();
        for (String[] ipPair : ipPairs = new String[][]{{"a.b.c.d", "255.0.0.0", MSG_INVALID_IP_FORMAT}, {"63.255.255.255", "31.0.0.0", MSG_INVALID_HOST_MASK}, {"0.255.255.255", "255.0.0.0", MSG_RESERVED_IP}, {"127.255.255.255", "255.0.0.0", "Reserved IP, otherwise it is a valid broadcast IP"}, {"191.9.1.3", "255.255.255.252", MSG_OK}, {"191.9.1.2", "255.255.255.252", MSG_HOST_IP}, {"191.9.1.4", "255.255.255.252", MSG_NETWORK_IP}, {"191.9.7.255", "255.255.248.0", MSG_OK}, {"191.9.7.254", "255.255.248.0", MSG_HOST_IP}, {"191.9.8.0", "255.255.248.0", MSG_NETWORK_IP}, {"191.15.255.255", "255.240.0.0", MSG_OK}, {"191.15.255.254", "255.240.0.0", MSG_HOST_IP}, {"191.16.0.0", "255.240.0.0", MSG_NETWORK_IP}, {"31.255.255.255", "224.0.0.0", MSG_OK}, {"31.255.255.254", "224.0.0.0", MSG_HOST_IP}, {"32.0.0.0", "224.0.0.0", MSG_NETWORK_IP}}) {
            System.out.println(String.format("isValidBroadcastIp(): %s/%s: %s (%s)", ipPair[0], ipPair[1], IPv4Validator.isValidBroadcastIp(ipPair[0], ipPair[1]), ipPair[2]));
        }
        System.out.println();
        for (String[] ipPair : ipPairs = new String[][]{{"a.b.c.d", "255.0.0.0", MSG_INVALID_IP_FORMAT}, {"1.0.0.0", "251.0.0.0", MSG_INVALID_HOST_MASK}, {"0.0.0.0", "255.0.0.0", MSG_RESERVED_IP}, {"127.0.0.0", "255.0.0.0", MSG_RESERVED_IP}, {"172.24.7.2", "255.255.255.252", MSG_OK}, {"172.24.7.3", "255.255.255.252", MSG_BROADCAST_IP}, {"172.24.7.4", "255.255.255.252", MSG_NETWORK_IP}, {"172.24.3.0", "255.255.248.0", MSG_OK}, {"172.24.7.255", "255.255.248.0", MSG_BROADCAST_IP}, {"172.24.8.0", "255.255.248.0", MSG_NETWORK_IP}, {"172.15.0.0", "255.240.0.0", MSG_OK}, {"172.15.255.255", "255.240.0.0", MSG_BROADCAST_IP}, {"172.16.0.0", "255.240.0.0", MSG_NETWORK_IP}, {"31.0.0.0", "224.0.0.0", MSG_OK}, {"31.255.255.255", "224.0.0.0", MSG_BROADCAST_IP}, {"224.0.0.0", "224.0.0.0", MSG_NETWORK_IP}}) {
            System.out.println(String.format("isValidHostIp(): %s/%s: %s (%s)", ipPair[0], ipPair[1], IPv4Validator.isValidHostIp(ipPair[0], ipPair[1]), ipPair[2]));
        }
    }
}

