/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

import com.bwanms.validation.IPv4Mask;
import com.bwanms.validation.IPv4Validator;
import org.hibernate.mapping.Property;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPv4MaskValidator
implements Validator<IPv4Mask>,
PropertyConstraint {
    private boolean acceptRouteMask;
    private boolean acceptFFMask;

    public void initialize(IPv4Mask parameters) {
        this.acceptRouteMask = parameters.acceptRouteMask();
        this.acceptFFMask = parameters.acceptFFMask();
    }

    public boolean isValid(Object maskAddress) {
        if (maskAddress == null) {
            return true;
        }
        if (maskAddress instanceof String) {
            if (this.acceptRouteMask) {
                return IPv4Validator.isValidRouteMask((String)maskAddress);
            }
            if (this.acceptFFMask && "255.255.255.255".equals(maskAddress)) {
                return true;
            }
            return IPv4Validator.isValidHostMask((String)maskAddress);
        }
        if (maskAddress instanceof Integer) {
            if (this.acceptRouteMask) {
                return IPv4Validator.isValidRouteMask((Integer)maskAddress);
            }
            if (this.acceptFFMask && -1 == (Integer)maskAddress) {
                return true;
            }
            return IPv4Validator.isValidHostMask((Integer)maskAddress);
        }
        if (maskAddress instanceof Long) {
            long mask = (Long)maskAddress;
            if ((mask >>> 32 & 0xFFFFFFFFFFFFFFFFL) != 0L) {
                return false;
            }
            if (this.acceptRouteMask) {
                return IPv4Validator.isValidRouteMask((int)mask);
            }
            return IPv4Validator.isValidHostMask((int)mask);
        }
        return false;
    }

    public void apply(Property property) {
    }
}

