/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

import com.bwanms.validation.IPv4Address;
import com.bwanms.validation.IPv4Validator;
import org.hibernate.mapping.Property;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class IPv4AddressValidator
implements Validator<IPv4Address>,
PropertyConstraint {
    private boolean acceptAnyIp = false;
    private boolean acceptZeroIp = false;

    public void initialize(IPv4Address parameters) {
        this.acceptAnyIp = parameters.acceptAnyIp();
        this.acceptZeroIp = parameters.acceptZeroIp();
    }

    public boolean isValid(Object ipAddress) {
        if (ipAddress == null) {
            return true;
        }
        if (ipAddress instanceof String) {
            if (this.acceptAnyIp) {
                return IPv4Validator.isIp((String)ipAddress);
            }
            if (this.acceptZeroIp && "0.0.0.0".equals(ipAddress)) {
                return true;
            }
            return IPv4Validator.isValidIp((String)ipAddress);
        }
        if (ipAddress instanceof Integer) {
            if (this.acceptAnyIp) {
                return true;
            }
            if (this.acceptZeroIp && (Integer)ipAddress == 0) {
                return true;
            }
            return IPv4Validator.isValidIp((Integer)ipAddress);
        }
        if (ipAddress instanceof Long) {
            long ip = (Long)ipAddress;
            if ((ip >>> 32 & 0xFFFFFFFFFFFFFFFFL) != 0L) {
                return false;
            }
            if (this.acceptAnyIp) {
                return true;
            }
            return IPv4Validator.isValidIp((int)ip);
        }
        return false;
    }

    public void apply(Property property) {
    }
}

