/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.validation;

import com.bwanms.validation.FileExists;
import java.io.File;
import org.hibernate.mapping.Property;
import org.hibernate.validator.PropertyConstraint;
import org.hibernate.validator.Validator;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class FileExistsValidator
implements Validator<FileExists>,
PropertyConstraint {
    private boolean isDirectory;
    private boolean checkOnlyIfAbsolutePath;

    public boolean isValid(Object arg0) {
        if (arg0 == null) {
            return true;
        }
        if (!(arg0 instanceof String)) {
            return false;
        }
        String filePath = (String)arg0;
        if (filePath.length() == 0) {
            return true;
        }
        File f = new File(filePath);
        if (this.checkOnlyIfAbsolutePath && !f.isAbsolute()) {
            return true;
        }
        if (this.isDirectory) {
            if (f.isDirectory()) {
                return f.exists();
            }
            return false;
        }
        if (f.isDirectory()) {
            return false;
        }
        return f.exists();
    }

    public void initialize(FileExists properties) {
        this.isDirectory = properties.isDirectory();
        this.checkOnlyIfAbsolutePath = properties.checkOnlyIfAbsolutePath();
    }

    public void apply(Property arg0) {
    }

    public void initialize(boolean isDirectory, boolean checkOnlyIfAbsolutePath) {
        this.isDirectory = isDirectory;
        this.checkOnlyIfAbsolutePath = checkOnlyIfAbsolutePath;
    }
}

