/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.version.impl;

import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionException;
import com.bwanms.util.version.VersionPart;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;

public class DefaultVersion
implements Version {
    private static final int MIN_ELEMENTS = 2;
    private String delimiters = null;
    private List<VersionPart> valuePairVector = new ArrayList<VersionPart>();

    public DefaultVersion(String pVersion) throws VersionException {
        this(pVersion, ".");
    }

    public DefaultVersion(String pVersion, String pDelimiters) throws VersionException {
        if (pVersion == null) {
            throw new NullPointerException("pVersion");
        }
        if (pDelimiters == null) {
            throw new NullPointerException("pDelimiters");
        }
        StringTokenizer versionTokenizer = new StringTokenizer(pVersion, pDelimiters);
        int tokensQty = versionTokenizer.countTokens();
        if (tokensQty < 2) {
            throw new VersionException("Invalid Software Version (Ver=" + pVersion + ", Delim.=" + pDelimiters + "). The number of Elements is less then " + 2 + ". Found " + tokensQty + ".");
        }
        int i = 1;
        while (versionTokenizer.hasMoreTokens()) {
            this.valuePairVector.add(this.getValuePair(versionTokenizer.nextToken()));
            ++i;
        }
        this.delimiters = pDelimiters;
    }

    public boolean equals(Object obj) {
        return obj instanceof DefaultVersion && this.isEqualWith((Version)obj);
    }

    public int getBuild() {
        VersionPart versionValuePair = this.getValuePairAt(3);
        if (versionValuePair != null) {
            return versionValuePair.getVersion();
        }
        return -1;
    }

    public String getBuildTail() {
        VersionPart versionValuePair = this.getValuePairAt(3);
        if (versionValuePair != null) {
            return versionValuePair.getTail();
        }
        return null;
    }

    VersionPart getBuildValuePair() {
        return this.getValuePairAt(3);
    }

    public int getMaint() {
        VersionPart versionValuePair = this.getValuePairAt(2);
        if (versionValuePair != null) {
            return versionValuePair.getVersion();
        }
        return -1;
    }

    public String getMaintTail() {
        VersionPart versionValuePair = this.getValuePairAt(2);
        if (versionValuePair != null) {
            return versionValuePair.getTail();
        }
        return null;
    }

    VersionPart getMaintValuePair() {
        return this.getValuePairAt(2);
    }

    public int getMajor() {
        return this.getValuePairAt(0).getVersion();
    }

    public String getMajorTail() {
        return this.getValuePairAt(0).getTail();
    }

    VersionPart getMajorValuePair() {
        return this.getValuePairAt(0);
    }

    public int getMinor() {
        return this.getValuePairAt(1).getVersion();
    }

    public String getMinorTail() {
        return this.getValuePairAt(1).getTail();
    }

    VersionPart getMinorValuePair() {
        return this.getValuePairAt(1);
    }

    private VersionPart getValuePair(String pVer) throws VersionException {
        String tail = null;
        int ver = -1;
        int lastNum = -1;
        for (int i = 0; i < pVer.length(); ++i) {
            char chr = pVer.charAt(i);
            if (chr <= '9' && chr >= '0') continue;
            lastNum = i - 1;
            break;
        }
        String verStr = pVer;
        if (lastNum >= 0) {
            verStr = pVer.substring(0, lastNum + 1);
            if (lastNum + 1 <= pVer.length()) {
                tail = pVer.substring(lastNum + 1);
            }
        } else {
            verStr = pVer;
        }
        try {
            ver = Integer.parseInt(verStr);
        }
        catch (Exception e) {
            throw new VersionException("Failed to parse Software Version: " + pVer + ". The " + verStr + " is not Integer.");
        }
        return new VersionPart(ver, tail);
    }

    VersionPart getValuePairAt(int pPos) {
        if (this.valuePairVector.size() > pPos) {
            return this.valuePairVector.get(pPos);
        }
        return null;
    }

    public String getVersion() {
        String retVal = "";
        for (int i = 0; i < this.size(); ++i) {
            VersionPart versionValuePair = this.getValuePairAt(i);
            if (i > 0) {
                retVal = retVal + ".";
            }
            retVal = retVal + versionValuePair.getAsString();
        }
        return retVal;
    }

    public int size() {
        return this.valuePairVector.size();
    }

    public String toString() {
        String retVal = "";
        for (int i = 0; i < this.size(); ++i) {
            VersionPart versionValuePair = this.getValuePairAt(i);
            switch (i) {
                case 0: {
                    retVal = retVal + "Major = ";
                    break;
                }
                case 1: {
                    retVal = retVal + ", Minor = ";
                    break;
                }
                case 2: {
                    retVal = retVal + ", Maint = ";
                    break;
                }
                case 3: {
                    retVal = retVal + ", Build = ";
                    break;
                }
                default: {
                    retVal = retVal + ", ";
                }
            }
            retVal = retVal + versionValuePair.toString();
        }
        return retVal;
    }

    public String toShortString() {
        StringBuilder builder = new StringBuilder();
        for (int i = 0; i < this.size(); ++i) {
            if (i > 0) {
                builder.append(this.delimiters);
            }
            builder.append(this.getValuePairAt(i).toString());
        }
        return builder.toString();
    }

    public VersionPart getPart(int index) {
        return this.getValuePairAt(index);
    }

    public boolean isNewerThan(Version version) {
        return this.compareTo(version) > 0;
    }

    public boolean isNewerOrEqualWith(Version version) {
        return this.compareTo(version) >= 0;
    }

    public boolean isOlderOrEqualWith(Version version) {
        return this.compareTo(version) <= 0;
    }

    public boolean isOlderThan(Version version) {
        return this.compareTo(version) < 0;
    }

    public boolean isEqualWith(Version version) {
        return this.compareTo(version) == 0;
    }

    public int compareTo(Version version) throws NullPointerException {
        return this.compare(this, version);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public int compare(Version v1, Version v2) {
        if (v1 == null) {
            throw new NullPointerException("pVersion");
        }
        if (v2 == null) {
            throw new NullPointerException("pVersion");
        }
        int i = 0;
        while (true) {
            if (i < v1.size()) {
                if (i >= v2.size()) return 1;
                int compVal = v1.getPart(i).compareTo(v2.getPart(i));
                if (compVal != 0) {
                    return compVal;
                }
            } else {
                if (i >= v2.size()) return 0;
                return -1;
            }
            ++i;
        }
    }

    public boolean isSupersetOf(Version version) {
        return version.getVersion().startsWith(this.getVersion());
    }
}

