/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.version;

import com.bwanms.util.version.Version;
import com.bwanms.util.version.VersionDomain;
import com.bwanms.util.version.impl.DefaultVersion;
import com.bwanms.util.version.impl.IntersectionCompositeVersionDomain;
import com.bwanms.util.version.impl.RangeAboveOrEqualVersionDomain;
import com.bwanms.util.version.impl.UniversalVersionDomain;

public class VersionFactory {
    private static VersionFactory instance;

    public static VersionFactory getInstance() {
        if (instance == null) {
            instance = new VersionFactory();
        }
        return instance;
    }

    private VersionFactory() {
    }

    public VersionDomain createUniversalDomain() {
        return new UniversalVersionDomain();
    }

    public Version createVersion(String version) {
        return new DefaultVersion(version);
    }

    public Version createVersion(String version, String delimiters) {
        return new DefaultVersion(version, delimiters);
    }

    public VersionDomain createDomain(String domain) {
        if (domain.startsWith(">=")) {
            return this.createRangeAboveOrEqual(this.createVersion(domain.substring(2)));
        }
        if (domain.startsWith(">")) {
            return this.createRangeAbove(this.createVersion(domain.substring(1)));
        }
        if (domain.startsWith("<=")) {
            return this.createRangeBelowOrEqual(this.createVersion(domain.substring(2)));
        }
        if (domain.startsWith("<")) {
            return this.createRangeBelow(this.createVersion(domain.substring(1)));
        }
        if (domain.startsWith("~")) {
            return this.createRangeLike(this.createVersion(domain.substring(1)));
        }
        if (domain.startsWith("[") && domain.endsWith("]")) {
            return this.createRangeInclusive(domain.substring(1, domain.length() - 1));
        }
        if (!domain.startsWith("(") || domain.endsWith(")")) {
            // empty if block
        }
        throw new RuntimeException("Can't create a domain from string " + domain);
    }

    private VersionDomain createRangeInclusive(String domain) {
        String[] domainLimits = domain.split("-");
        if (domainLimits.length != 2) {
            throw new RuntimeException("Can't create a domain from string " + domain);
        }
        IntersectionCompositeVersionDomain verDom = new IntersectionCompositeVersionDomain();
        verDom.addInterval(this.createRangeAboveOrEqual(this.createVersion(domainLimits[0].trim())));
        verDom.addInterval(this.createRangeBelowOrEqual(this.createVersion(domainLimits[1].trim())));
        return verDom;
    }

    private VersionDomain createRangeLike(final Version domainVersion) {
        return new VersionDomain(){

            public boolean includes(Version version) {
                return domainVersion.isSupersetOf(version);
            }
        };
    }

    private VersionDomain createRangeBelow(final Version domainVersion) {
        return new VersionDomain(){

            public boolean includes(Version version) {
                return domainVersion.isNewerThan(version);
            }
        };
    }

    private VersionDomain createRangeBelowOrEqual(final Version domainVersion) {
        return new VersionDomain(){

            public boolean includes(Version version) {
                return domainVersion.isNewerOrEqualWith(version);
            }
        };
    }

    private VersionDomain createRangeAbove(final Version domainVersion) {
        return new VersionDomain(){

            public boolean includes(Version version) {
                return domainVersion.isOlderThan(version);
            }
        };
    }

    private VersionDomain createRangeAboveOrEqual(final Version domainVersion) {
        return new VersionDomain(){

            public boolean includes(Version version) {
                return domainVersion.isOlderOrEqualWith(version);
            }
        };
    }

    public VersionDomain createRangeAfter(Version version) {
        return new RangeAboveOrEqualVersionDomain(version);
    }

    public VersionDomain createRangeAfter(String version) {
        return this.createRangeAfter(this.createVersion(version));
    }
}

