/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.task;

import com.bwanms.gui.Internationalizer;
import com.bwanms.gui.taskmanager.xsl.XSLTransformer;
import com.bwanms.util.task.InternationalizerHandler;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.apache.log4j.Logger;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class OperationXSLTransformer
extends XSLTransformer {
    private static final Logger log = Logger.getLogger(OperationXSLTransformer.class);
    private InternationalizerHandler handler;

    public OperationXSLTransformer(Internationalizer i18n) {
        this.handler = new InternationalizerHandler(i18n);
    }

    public OperationXSLTransformer(InternationalizerHandler handler) {
        this.handler = handler;
    }

    public URL getXSLInputStream() {
        return OperationXSLTransformer.class.getResource("operationtaskhistorytransformer.xsl");
    }

    public String processContent(String content) throws IOException {
        try {
            SAXParser parser = SAXParserFactory.newInstance().newSAXParser();
            parser.parse((InputStream)new ByteArrayInputStream(content.getBytes("UTF8")), (DefaultHandler)this.handler);
            String ret = this.handler.getOutputString();
            log.debug((Object)ret);
            return ret;
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
    }
}

