/*
 * Decompiled with CFR 0.152.
 */
package com.bwanms.util.task;

import com.bwanms.gui.Internationalizer;
import com.bwanms.util.task.OperationTree;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.Rectangle;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JTree;
import javax.swing.UIManager;
import javax.swing.tree.TreeCellRenderer;

public class OperationTreeCellRenderer
implements TreeCellRenderer {
    private Internationalizer i18n;
    private static final Internationalizer localI18N = Internationalizer.getInternationalizer(OperationTreeCellRenderer.class);
    private Icon pendingIcon = new ImageIcon(this.getClass().getResource("resource_obj.gif"));
    private Icon runningIcon = new ImageIcon(this.getClass().getResource("debugtt_obj.gif"));
    private Icon completedIcon = new ImageIcon(this.getClass().getResource("cheatsheet_view.gif"));
    private Icon failedIcon = new ImageIcon(this.getClass().getResource("error_log.gif"));
    protected boolean selected;
    protected boolean hasFocus;
    protected Color textSelectionColor;
    protected Color textNonSelectionColor;
    protected Color backgroundSelectionColor;
    protected Color backgroundNonSelectionColor;
    protected Color borderSelectionColor;
    private OperationGroupRenderer operationGroupRenderer = new OperationGroupRenderer();
    private OperationRenderer operationRenderer = new OperationRenderer();

    public OperationTreeCellRenderer(Internationalizer i18n) {
        this.i18n = i18n;
        this.setTextSelectionColor(UIManager.getColor("Tree.selectionForeground"));
        this.setTextNonSelectionColor(UIManager.getColor("Tree.textForeground"));
        this.setBackgroundSelectionColor(UIManager.getColor("Tree.selectionBackground"));
        this.setBackgroundNonSelectionColor(UIManager.getColor("Tree.textBackground"));
        this.setBorderSelectionColor(UIManager.getColor("Tree.selectionBorderColor"));
    }

    public void setTextSelectionColor(Color newColor) {
        this.textSelectionColor = newColor;
    }

    public Color getTextSelectionColor() {
        return this.textSelectionColor;
    }

    public void setTextNonSelectionColor(Color newColor) {
        this.textNonSelectionColor = newColor;
    }

    public Color getTextNonSelectionColor() {
        return this.textNonSelectionColor;
    }

    public void setBackgroundSelectionColor(Color newColor) {
        this.backgroundSelectionColor = newColor;
    }

    public Color getBackgroundSelectionColor() {
        return this.backgroundSelectionColor;
    }

    public void setBackgroundNonSelectionColor(Color newColor) {
        this.backgroundNonSelectionColor = newColor;
    }

    public Color getBackgroundNonSelectionColor() {
        return this.backgroundNonSelectionColor;
    }

    public void setBorderSelectionColor(Color newColor) {
        this.borderSelectionColor = newColor;
    }

    public Color getBorderSelectionColor() {
        return this.borderSelectionColor;
    }

    private String getOperationLabel(OperationTree.OperationTreeNode opTreeNode) {
        if (this.i18n != null) {
            String text = opTreeNode.operation.getTranslatedName(this.i18n) + ((opTreeNode.operation.getDisplayStyle() & 1) != 0 ? " - " + localI18N.translateString(opTreeNode.currentStatus.getStatus().toString()) : "");
            Serializable message = opTreeNode.currentStatus.getMessage();
            if (message != null && message instanceof String) {
                text = this.i18n.canTranslate((String)((Object)message)) ? text + ": " + this.i18n.translateString((String)((Object)message), opTreeNode.currentStatus.getParams()) : text + ": " + (String)((Object)message);
            }
            return text;
        }
        String text = opTreeNode.operation.getName() + " " + opTreeNode.operation.getNameParams() + ((opTreeNode.operation.getDisplayStyle() & 1) != 0 ? " - " + opTreeNode.currentStatus.getStatus().toString() : "");
        Serializable message = opTreeNode.currentStatus.getMessage();
        if (message != null && message instanceof String) {
            text = text + ": " + (String)((Object)message);
        }
        return text;
    }

    private Icon getOperationIcon(OperationTree.OperationTreeNode opTreeNode) {
        switch (opTreeNode.currentStatus.getStatus()) {
            case PENDING: {
                return this.pendingIcon;
            }
            case IN_PROGRESS: {
                return this.runningIcon;
            }
            case SKIPPED: 
            case COMPLETED: {
                return this.completedIcon;
            }
            case FAILED: {
                return this.failedIcon;
            }
        }
        return null;
    }

    public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
        return leaf ? this.operationRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus) : this.operationGroupRenderer.getTreeCellRendererComponent(tree, value, selected, expanded, leaf, row, hasFocus);
    }

    private class OperationRenderer
    extends JLabel
    implements TreeCellRenderer {
        private static final long serialVersionUID = -7555550130355076453L;

        public OperationRenderer() {
            super.setOpaque(true);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            OperationTree.OperationTreeNode opTreeNode = (OperationTree.OperationTreeNode)value;
            this.setFont(tree.getFont());
            this.setForeground(selected ? OperationTreeCellRenderer.this.textSelectionColor : OperationTreeCellRenderer.this.textNonSelectionColor);
            this.setBackground(selected ? OperationTreeCellRenderer.this.backgroundSelectionColor : OperationTreeCellRenderer.this.backgroundNonSelectionColor);
            this.setText(OperationTreeCellRenderer.this.getOperationLabel(opTreeNode));
            this.setIcon(OperationTreeCellRenderer.this.getOperationIcon(opTreeNode));
            return this;
        }

        public void validate() {
        }

        public void invalidate() {
        }

        public void revalidate() {
        }

        public void repaint(long tm, int x, int y, int width, int height) {
        }

        public void repaint(Rectangle r) {
        }

        public void repaint() {
        }

        protected void firePropertyChange(String propertyName, Object oldValue, Object newValue) {
            if (propertyName == "text") {
                super.firePropertyChange(propertyName, oldValue, newValue);
            }
        }

        public void firePropertyChange(String propertyName, byte oldValue, byte newValue) {
        }

        public void firePropertyChange(String propertyName, char oldValue, char newValue) {
        }

        public void firePropertyChange(String propertyName, short oldValue, short newValue) {
        }

        public void firePropertyChange(String propertyName, int oldValue, int newValue) {
        }

        public void firePropertyChange(String propertyName, long oldValue, long newValue) {
        }

        public void firePropertyChange(String propertyName, float oldValue, float newValue) {
        }

        public void firePropertyChange(String propertyName, double oldValue, double newValue) {
        }

        public void firePropertyChange(String propertyName, boolean oldValue, boolean newValue) {
        }
    }

    private class OperationGroupRenderer
    extends JPanel
    implements TreeCellRenderer {
        private static final long serialVersionUID = 3457497158342040579L;
        private JLabel label;
        private JProgressBar progressBar;

        public OperationGroupRenderer() {
            this.setLayout(new FlowLayout(0, 5, 0));
            this.label = new JLabel();
            this.progressBar = new JProgressBar(0, 100);
            this.add(this.label);
            this.add(this.progressBar);
        }

        public Component getTreeCellRendererComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row, boolean hasFocus) {
            OperationTree.OperationTreeNode opTreeNode = (OperationTree.OperationTreeNode)value;
            this.label.setText(OperationTreeCellRenderer.this.getOperationLabel(opTreeNode));
            this.label.setIcon(OperationTreeCellRenderer.this.getOperationIcon(opTreeNode));
            if (opTreeNode.isPending()) {
                this.progressBar.setVisible(false);
            } else {
                this.progressBar.setVisible(true);
                this.progressBar.setValue(opTreeNode.getPercentCompleted());
            }
            if ((opTreeNode.operation.getDisplayStyle() & 2) == 0) {
                this.progressBar.setVisible(false);
            }
            this.setBackground(selected ? OperationTreeCellRenderer.this.backgroundSelectionColor : OperationTreeCellRenderer.this.backgroundNonSelectionColor);
            this.label.setForeground(selected ? OperationTreeCellRenderer.this.textSelectionColor : OperationTreeCellRenderer.this.textNonSelectionColor);
            this.label.setFont(tree.getFont());
            return this;
        }
    }
}

